/*------------------------------------------------------------------------------*
 * File Name:ThemeFilter.c	 													*
 * Creation: CPY																*
 * Purpose: OriginC Source C file for Theme Properties Filter Dialog			*
 * Copyright (c) Originlab Corp.	2003										*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *------------------------------------------------------------------------------*/
#include <Origin.h>
//#include <Project.h>
//#include <sys_utils.h> // basic routines implemeted through Origin C, see sys_utils.c
#include <Dialog.h>
//#include <utilities.h>
//#include <tree_utils.h>
#include "ResizeDialog.h"
#include <TreeEditor.h>
#include <vsFlexGrid.h>
#include "ODlg.h" // resource IDs, ODlg.dll also use this file for its res ids
#include "HelpID.h"
#include "theme_utils.h"

bool ThemeFilter(LPCSTR lpcszThemeFilename, HWND hWndParent)//= NULL)
{
	ThemeFilterDlg myDlg(lpcszThemeFilename);
	
	int nRet = myDlg.DoModalEx(hWndParent);
	return (IDCANCEL == nRet)? false:true;
}

enum {FBITS_GET, FBITS_SET_ALL_ON, FBITS_SET_ALL_OFF};

class ThemeFilterDlg : public Dialog
{
public:
	ThemeFilterDlg(LPCSTR lpcszThemeFilename):Dialog(IDD_THEME_FILTER, "ODlg")
	{
		if(m_tempThemeFile.Init(lpcszThemeFilename))
			m_strSrcFilename = lpcszThemeFilename;
	}
	
	int  	DoModalEx(HWND hParent)
	{
		InitMsgMap();// will be called from internal later
		int nRet = DoModal(hParent);
		return nRet;
	}
	
	
		
///----------------- Message Map ----------------
EVENTS_BEGIN
	ON_INIT(OnInitDialog) 
	ON_OK(OnOK)
	ON_BN_CLICKED(IDC_THEMEFILTER_APPLY, OnApplyFilterToThemeTree)
	ON_BN_CLICKED(IDC_THEMEFILTER_RESTORE, OnRestoreThemeTree)	
	ON_BN_CLICKED(IDC_THEMEFILTER_LIST_VIEW, OnListViewCheck)
	ON_USER_MSG(WM_USER_ON_CONTROL_CHANGE, OnTreeChanged)
EVENTS_END
///----------------------------------------------
		
		
	
	BOOL OnInitDialog()
	{
		// load from s_strTempFilename
		m_treeEditor = GetItem(IDC_THEMEFILTER_TREE);
		m_treeEditor.Load(m_tempThemeFile.GetFileName());
		update_theme_tree_view();
		property_filter_bits(FBITS_SET_ALL_ON);
		categtory_filter_bits(FBITS_SET_ALL_ON);
		
		return TRUE;	
	}
	
private:	
	string			m_strSrcFilename;
	TempThemeFile	m_tempThemeFile;
	TreeEditor 		m_treeEditor;
	
	
///////////////////////////////////////////////////////
/// General utilities
///////////////////////////////////////////////////////
	void update_theme_tree_view()
	{
		theme_update_tree_list_view(*this, IDC_THEMEFILTER_LIST_VIEW, IDC_THEMEFILTER_TREE);
		theme_update_size(*this, m_tempThemeFile.GetFileName(), IDC_THEMEFILTER_COUNT);
		//CPY 6/11/03, theme filter should disable editing since that will be confusing to support both filtering and editing
		Object flx = m_treeEditor.GetActiveXControl();
		flx.Editable = flexEDNone;
		flx.HighLight = flexHighlightNever;
		flx.FocusRect = flexFocusLight;
		//
	}

	///////////////////////////////////////////////////////
	/// Event Handlers
	///////////////////////////////////////////////////////
	BOOL OnRestoreThemeTree(Control cntrl)
	{
		FileCopy(m_strSrcFilename, m_tempThemeFile.GetFileName());
		m_treeEditor.Load(m_tempThemeFile.GetFileName());
		update_theme_tree_view();
		return TRUE;
	}

	BOOL OnApplyFilterToThemeTree(Control cntrl)
	{
		DWORD dwPropertiesFilter = property_filter_bits();
		DWORD dwObjectsFilter = categtory_filter_bits();
		ApplyFilterToTheme(m_strSrcFilename, m_tempThemeFile.GetFileName(), dwPropertiesFilter, dwObjectsFilter);
		m_treeEditor.Load(m_tempThemeFile.GetFileName());
		update_theme_tree_view();
		return TRUE;
	}

	BOOL OnOK()
	{	
		m_treeEditor.Save(m_strSrcFilename);
		return TRUE;
	}


	BOOL OnListViewCheck(Control oCntrl)
	{
		theme_update_tree_list_view(*this, IDC_THEMEFILTER_LIST_VIEW, IDC_THEMEFILTER_TREE);
		return TRUE;
	}

	BOOL OnTreeChanged(uint wParam, uint lParam)
	{
		theme_update_size(*this, m_tempThemeFile.GetFileName(), IDC_THEMEFILTER_COUNT, IDC_THEMEFILTER_TREE);
		return TRUE;
	}

	DWORD categtory_filter_bits(int nAction = FBITS_GET)
	{
		// the following two arrays must match, and the IDs array must have zero termination
		DWORD dwCategoryBits[] = {
			FOB_LABELS, 				FOB_LINES | FOB_SHAPES,				FOB_SCALE,
			FOB_AXIS, 					FOB_PLOT, 							FOB_BACKGROUND, 
			FOB_DIMENSION,				FOB_GLOBAL, 						FOB_OTHER|FOB_INCREMENT|FOB_COLORMAP
		};
		int nCategoryIDs[] = {
			IDC_THEMEFILTER_CAT_LABELS,	IDC_THEMEFILTER_CAT_OTHER_LABELS,	IDC_THEMEFILTER_CAT_SCALE,
			IDC_THEMEFILTER_CAT_AXIS,	IDC_THEMEFILTER_CAT_PLOTS,			IDC_THEMEFILTER_CAT_BACKGROUND,
			IDC_THEMEFILTER_CAT_DIM,	IDC_THEMEFILTER_CAT_GLOBAL,			IDC_THEMEFILTER_CAT_OTHERS,
			0
		};
		
		return filter_bits(dwCategoryBits, nCategoryIDs, nAction);	
	}

	DWORD property_filter_bits(int nAction = FBITS_GET)
	{
		// the following two arrays must match, and the IDs array must have zero termination
		DWORD dwPropertyBits[] = {
			FPB_STYLE_FONT,				FPB_STYLE_COLOR_MASK,			FPB_STYLE_LINE,				FPB_STYLE_BORDER,
			FPB_STYLE_FILL,				FPB_STYLE_SIZE, 				FPB_SHOW,					FPB_OTHER|(FPB_STYLE_LIST_MASK & ~FPB_STYLE_COLOR_LIST),
			FPB_STYLE_SYMBOL_MASK,		FPB_SCALE,						FPB_TEXT,					FPB_DIMENSION
		};
		int nPropertyIDs[] = {
			IDC_THEMEFILTER_PROP_FONT,		IDC_THEMEFILTER_PROP_COLOR,	IDC_THEMEFILTER_PROP_LINE,	IDC_THEMEFILTER_PROP_BORDER,
			IDC_THEMEFILTER_PROP_FILL,		IDC_THEMEFILTER_PROP_SIZE,	IDC_THEMEFILTER_PROP_SHOW,	IDC_THEMEFILTER_PROP_OTHERS,
			IDC_THEMEFILTER_PROP_SYMBOL,	IDC_THEMEFILTER_CAT_SCALE,	IDC_THEMEFILTER_PROP_TEXT,	IDC_THEMEFILTER_CAT_DIM,
			0
		};
		
		return filter_bits(dwPropertyBits, nPropertyIDs, nAction);
	}

	DWORD filter_bits(DWORD dwFilterBits[], int nIDs[], int nAction)
	{
		DWORD dwBits = 0;
		int ii = 0;
		int id;
		while(id = nIDs[ii])
		{
			Button btn = GetItem(id);
			
			if(btn)
			{
				if(FBITS_GET == nAction)
				{
					if(btn.Check)
						dwBits |= dwFilterBits[ii];
				}
				else
					btn.Check = FBITS_SET_ALL_ON == nAction? true:false;
			}
					
			ii++;
		}
		
		return dwBits;
	}
};

		






