/*------------------------------------------------------------------------------*
 * File Name: Themes.h					 										*
 * Purpose: Declare functions that are related to Themes						*
 * Copyright (c)2003 OriginLab Corp.											*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	CPY 10/21/03 QA70-4680 v7.5727 TREE_BRANCHESOPEN_CLOSE_REMEMBERED			*
 *------------------------------------------------------------------------------*/

#ifndef _THEMES_H
#define _THEMES_H


enum {THEME_APPLY_LOAD_TEMPLATE, THEME_APPLY_NEW_GRAPH};

#define THEME_FILE_NODE_NAME 	"File"
#define THEME_TYPE_ATTRIBUTE 	"Type"

enum {
	THTYPE_SYSTEM,
	THTYPE_USER,
};

enum {
	THEMEAPPLY_SELECTION = 0,
	THEMEAPPLY_ACTIVE,
	THEMEAPPLY_FOLDER,
	THEMEAPPLY_PROJECT
};


#define STR_THEME_TYPE_SYSTEM	"Origin"
#define STR_THEME_TYPE_USER		"User"
#define STR_THEME_COMMENT_ATTRIB	"Comment"

string 	theme_get_system_theme_file_name(int nThemeType = THEME_APPLY_LOAD_TEMPLATE);
string 	theme_get_theme_file_name(string strThemeName, bool bIsEXEpath = false);
bool 	theme_rename(string strThemeName, string strOldName, bool bIsEXEpath);
bool 	theme_system_getset(string strThemeName, bool bSet = false, bool bSetAs = false, bool bIsEXEPath=false); // if not set, then test
bool 	theme_is_in_clipboard();
string 	theme_get_path(bool bEXEpath = false);
uint 	theme_find_all_theme_files(TreeNode& trNode);
TreeNode theme_add_one_theme_file(TreeNode& trNode, const string& strFilename, bool bUser = true);
bool 	theme_get_next_file_name(string& strFilename, bool bCheckCreatePath=true);
int		theme_count_properties(LPCSTR lpcszThemeFilename, int* lpnSections = NULL);
string	theme_get_system_theme();
bool	theme_apply(int nTo, string strFile);

enum {
	SAVETHEME_ALL = 0,
	SAVETHEME_ALL_STYLES,
	SAVETHEME_COLORS,
	SAVETHEME_FONTS,
	SAVETHEME_DIMS,
	SAVETHEME_SCALES,
	SAVETHEME_TEXT,
	SAVETHEME_BACKGROUND,
	SAVETHEME_PLOTS,

	SAVETHEME_TOTAL,
};

bool	theme_copy_format_to_file(LPCSTR lpcszFilename, DWORD dwPropertiesFilter = FPB_ALL, DWORD dwObjFilter = FOB_ALL);
bool	theme_copy_format(DWORD dwPropertiesFilter = FPB_ALL, DWORD dwObjFilter = FOB_ALL);
bool 	theme_copy_format_menu(int nType = SAVETHEME_ALL);
bool	theme_combine_filter_bits(int nType, DWORD& dwProperties, DWORD& dwObjects);


#ifdef _CONTROL_H
/**
	Parameters:
		theDlg = the current dilaog object
		nListViewCheckID = id of the check box "List View"
		nTreeID = id of the TreeEditor control
	Example:
		static BOOL OnListViewCheck(Control oCntrl)
		{
			theme_update_tree_list_view(MyDlg, IDC_STYLSHT_LIST_VIEW, IDC_STYLSHT_TREE);
			return TRUE;
		}
*/
void theme_update_tree_list_view(Dialog& theDlg, int nListViewCheckID, int nTreeID, bool bShowEmpty=false, bool bShowCollection=false);

/**
	Parameters:
		theDlg = the current dilaog object
		lpcszFilename = a theme file name
		nSizeID = id of the static box to display size of theme
*/
void theme_update_size(Dialog& theDlg, LPCSTR lpcszFilename, int nSizeID, int nTreeID = 0);

/**
	Provides Filtering support for the Theme Tree in a dialog
	Parameters:
		theDlg = the current dilaog object
		nListViewCheckID = id of the check box "List View"
		nTreeID = id of the TreeEditor control that holds the theme tree
	Returns:
		TRUE if the Theme is modified by the Filer dialog, return FALSE otherwise
	Example:
		static BOOL OnThemeFilter(Control oCntrl)
		{
			theme_filter_dialog(MyDlg, IDC_STYLSHT_LIST_VIEW, IDC_STYLSHT_TREE);
			return TRUE;
		}	
*/
bool theme_filter_dialog(Dialog& theDlg, int nIDListView, int nIDTree);

class TempThemeFile
{
	~TempThemeFile()
	{
		if(m_strTempFilename.IsFile())
			DeleteFile(m_strTempFilename);
		
		m_strTempFilename.Empty();
	}
public:
	bool Init(LPCSTR lpcszThemeFilename)
	{
		string strFilename = lpcszThemeFilename;
		if(!strFilename.IsFile())
			return false;
		if(!GetTempFileName(m_strTempFilename))
			return false;
		
		
		FileCopy(strFilename, m_strTempFilename);
		return true;
	}
	string GetFileName() {return m_strTempFilename;}
private:
	string	m_strTempFilename; 
};

#ifdef _GRID_CONTROL_H_

#define STR_ATTRIB_COLLAPSE "Collaps"	//---- CPY 10/21/03 QA70-4680 v7.5727 TREE_BRANCHESOPEN_CLOSE_REMEMBERED

class ThemeTreeControl : public GridListControl
{
public:
	void Init(int nID, Dialog& dlg)
	{
		GridListControl::InitControl(nID, dlg);
		m_treeEditor = dlg.GetItem(nID);
		m_flx = m_treeEditor.GetActiveXControl();

		SetFont();
	}
	bool Load(LPCSTR lpcszFilename)
	{
		return m_treeEditor.Load(lpcszFilename);
	}
	bool Save(LPCSTR lpcszFilename)
	{
		return m_treeEditor.Save(lpcszFilename);
	}
	bool GetTree(Tree& tr)
	{
		//TreeNode tr1 = m_treeEditor.Root;
		tr = m_treeEditor.Root;
		return tr.IsValid()?true:false;
	}
	//---- CPY 10/21/03 QA70-4680 v7.5727 TREE_BRANCHESOPEN_CLOSE_REMEMBERED
	/*
	bool Load(LPCSTR lpcszFilename)
	{
		if(m_treeEditor.Load(lpcszFilename))
		{
			string strTemp = getFileAttribute(lpcszFilename, STR_ATTRIB_COLLAPSE);
			if(!strTemp.IsEmpty())
			{
				BitsHex temp;
				vector<byte> vn;
				temp.HexStrToBits(strTemp, vn);
				SetCollapsed(vn);
			}
			return true;
		}
		return false;
	}
	bool Save(LPCSTR lpcszFilename)
	{
		if(m_treeEditor.Save(lpcszFilename))
		{
			vector<byte> vn;
			if(GetCollapsed(vn) > 1)
			{
				BitsHex temp;
				string	strTemp;
				temp.BitsToHexStr(vn, strTemp);
				setFileAttribute(lpcszFilename, STR_ATTRIB_COLLAPSE, strTemp);
			}
			return true;
		}
		return false;
	}
	*/
	//---- end TREE_BRANCHESOPEN_CLOSE_REMEMBERED
private:
	TreeEditor	m_treeEditor;
	//---- CPY 10/21/03 QA70-4680 v7.5727 TREE_BRANCHESOPEN_CLOSE_REMEMBERED
	string getFileAttribute(LPCSTR lpcszFile, LPCSTR lpcszAttribute)
	{
		string str;
		Tree trTemp(lpcszFile);
		if(trTemp.IsValid())
		{
			trTemp.GetAttribute(lpcszAttribute, str);
		}
		return str;
	}
	void setFileAttribute(LPCSTR lpcszFile, LPCSTR lpcszAttribute, LPCSTR lpcszVal)
	{
		string str;
		Tree trTemp(lpcszFile);
		if(trTemp.IsValid())
		{
			trTemp.SetAttribute(lpcszAttribute, lpcszVal);
		}
	}
	//---- end TREE_BRANCHESOPEN_CLOSE_REMEMBERED
	
};
#endif //_GRID_CONTROL_H_

/**
	Parameters:
		dlg = the current dilaog object
		nButtonIDs = zero terminated array of button ids for all the buttons that should be placed at the top right corner of the dialog
		nMainItemID = id of the control that is to be sized on the left of the buttons specified by nButtonIDs
	Returns:
		The gap (pixels) between controls. This can be used by the calling function to further poisition other controls
	Example:
		static BOOL OnDlgResize(int nType, int cx, int cy)
		{
			uint nBtnIds[] = {
				IDOK,
				IDCANCEL,
				IDC_STYLSHT_FILTER,
				IDC_STYLSHT_LIST_VIEW, 0};
			
			dlg_resize_buttons_relative_to_main_item(MyDlg, nBtnIds, IDC_STYLSHT_TREE, cx, cy);
				
			return TRUE;
		}
int dlg_resize_buttons_relative_to_main_item(Dialog& dlg, uint nButtonIDs[], uint nMainItemID, int cx, int cy);
*/

#endif //_CONTROL_H

#endif //_THEMES_H


