/*------------------------------------------------------------------------------*
 * File Name: Collection.h														*
 * Creation: TD 9-21-01															*
 * Purpose: Origin C header	for Collection template class						*
 * Copyright (c) OriginLab Corp.2001											*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *------------------------------------------------------------------------------*/

#ifndef _COLLECTION_H
#define _COLLECTION_H

/** >Internal Origin Objects
		The Collection class provides a template for collections of various internal
		Origin objects such as "Pages" (the collection of all PageBase objects in a
		project file), etc. The Collection class has an implicit templatized type
		_TemplType, which is the type of one element of the collection. For example,
		for the Project class Pages collection (Collection<PageBase> Pages;) the
		templatized type is PageBase. Each collection usually has a parent class which
		is the class whose data member is the collection. For example, Collection<PageBase> Pages
		is a member of the Project class because Project contains all the pages. Therefore,
		each collection can be attached to one internal object or be unattached. The
		methods of the Collection class are common for all collections.	One of the most
		useful ways to use a collection is in the foreach loop (see the Example).
	Example:
		// This function demonstrates looping over all the members of a collection
		// using a foreach loop
		// Default constructor creates an unattached Collection object:
		Collection<PageBase> pbColl;

		// Attach to the collection of all the pages in the project:
		pbColl = Project.Pages;

		PageBase pb;
	
		foreach(pb in pbColl)
		{
			// Display the name of the page:
			out_str(pb.GetName());
		}
*/
class Collection
{
public:
	/**
		The default constructor which constructs an uninitialized collection.
	Parameters:
		None.
	Returns:
		None.
	Example:
		void	run_Collection()
		{
			Collection<PageBase>	pgColl;
		}
	*/
	Collection();
	
	/**
		Returns the count of all the objects in the collection.
	Parameters:
		None.
	Returns:
		the count of objects
	Example:
		// The function display the total number of pages in the project.
		void	run_Collection_Count()
		{
			// Default constructor creates an unattached Collection object:
			Collection<PageBase>	pgColl;
			
			// Attach to the collection of all the pages in the project:
			pgColl = Project.Pages;
			
			// Get the total count:
			printf("Total count of objects is %d.\n", pgColl.Count());
		}
	*/
	UINT Count();
	
	/**
		It returns the nIndex'th item of the collection.
	Parameters:
		nIndex = 0-offset index of the needed item in the collection
	Returns:
		the item corresponding to the supplied index.
	Example:
		void	run_Collection_Item()
		{
			// Default constructor creates an unattached Collection object:
			Collection<PageBase>	pgColl;
			
			// Attach to the collection of all the pages in the project:
			pgColl = Project.Pages;
		
			// Get the first page in the collection:
			PageBase				pg = pgColl.Item(0);
			
			// Display the name of the page:
			out_str(pg.GetName());
		}
	*/
	_TemplType Item(int nIndex);
	
	/**
		It returns the item with the name lpcszName in the collection.
	Parameters:
		lpcszName = the name of the desired item.
	Returns:
		the item corresponding to the supplied name.
	Example:
		// For this example to run, make sure that the project contains
		// a window with the name "Data1".
		void	run_Collection_Item()
		{
			// Default constructor creates an unattached Collection object:
			Collection<PageBase>	pgColl;
			
			// Attach to the collection of all the pages in the project:
			pgColl = Project.Pages;
		
			// Get the page "Data1" in the collection:
			PageBase				pg = pgColl.Item("Data1");
			
			// Display the name of the page:
			out_str(pg.GetName());
		}
	*/
	_TemplType Item(LPCSTR lpcszName);
	
	//int			Count;
};

#endif // _COLLECTION_H
