/*------------------------------------------------------------------------------*
 *	File Name: 	DialogMessages.h												*
 *	Purpose:	OC level ID's for Dialog Msg and Handler prototypes				* 
 *																				*
 *																				*
 *	Author:		TD																*
 *  Creation:	10-31-02														*
 *  	Copyright (c) OriginLab Corp. 2000-2003									*
 *																				*
 *	Modification log     														*
 *	Created TD 10/29/02 QA70-3182 v7.0424	OCDIALOG_MSG_MAP_IMPLEMENT			*
 *	CPY v7.0469 12/19/02 QA70-3526 SKIP_PAGES_FROM_OC							*
 *	TD 12-27-02 ORIGINC_ACCESS_TO_EDIT_ON_RETURN								*
 *	CPY 12-28-02 QA70-3589 ORIGINC_ACCESS_TO_PRETRANSLATE_KEY_MSG				*
 *	TD 1-8-03 QA70-3630 v7.0481 EVENT_SINK_FOR_DIALOG_BUILDER					*
 *	CPY 1/28/03 QA70-3796 COL_CHANGE_NOTIFICATIONS								*
 *	RVD 3/17/2003 QA70-3855 v7.0539 SYSTEM_THEME								*
 *	TD 4-14-03 QA70-4258 ADD_PAGE_ONKILLACTIVE									*
 *	TD 10-21-03 QA70-5067 PROPERTY_SHEET_AND_WIZARD_CLASS_IN_OC					*
 *------------------------------------------------------------------------------*/



#ifndef _DIALOGMESSAGES_H_
#define _DIALOGMESSAGES_H_



#define		MT_DLG					0x00000100
#define		MT_WND					0x00000200
#define		MT_ORG					0x00000300
#define		MT_EVNT					0x00000400				///	TD 1-8-03 QA70-3630 v7.0481 EVENT_SINK_FOR_DIALOG_BUILDER

// As per Marko's suggestion not making things harder by demanding user to know what's notify and what's command
// Since then most times they will have to try both and check which is which 
// leaving the info here for the time being incase we want to do this
//#define		MFC_COMMAND				0x00010000
//#define		MFC_NOTIFY				0x00020000

#define MT_FILTER(_ID)		(0x0000FF00 & (_ID)) 
#define MHO_FILTER(_ID)		(0x000000FF & (_ID)) 
//#define MFC_FILTER(_ID)		(0x00FF0000 & (_ID))



// Dialog Messages, corresponding to MFC CDialog Virtual functions and DialogBuilder specific
enum
{
	SN_INIT = 1,
	SN_ON_INIT,	
	SN_ONREADY,
	SN_OK,
	SN_APPLY,
	SN_NEXT,
	SN_FINISH,
	SN_CANCEL,
	SN_BACK,
	SN_HELP,
	SN_ACTIVE,
	SN_WINDOW_PROC,
	SN_IS_SHOW_PAGE,  //CPY v7.0469 12/19/02 QA70-3526 SKIP_PAGES_FROM_OC
	SN_KILLACTIVE,	/// TD 4-14-03 QA70-4258 ADD_PAGE_ONKILLACTIVE
	SN_RESET,		/// TD 4-22-03 QA70-3608 MORE_WORK_IN_DDK
	SN_ONKEY, /// TD 6-10-03 QA70-4631 MODAL_TO_BE_NOMODAL_ON_ROLLUP
	SN_ON_INIT_RESIZE, /// TD 9-8-03 QA70-NOTRACKER OCMSG_ON_RESIZE_BY_INI
};





// Origin Messages, 
enum
{
	//LY 12/3/02 v7.0452 QA70-3422 CENTRALIZE_DDK_MSG_HANDLING
	//SN_ONMDIACTIVATE = 1,
	SN_ACTIVE_WINDOW = 0,
	SN_ACTIVE_PAGE,			//different to the SN_ACTIVE_WINDOW due to note page
	SN_ACTIVE_LAYER,
	SN_ACTIVE_SELECTION,
	SN_ACTIVE_DATASET,
	SN_NUM_ORIGIN_OBJECTS,
	// other non Origin object notifications
	SN_ONMDIACTIVATE,
	//LY 12/3/02 QA70-3422 CENTRALIZE_DDK_MSG_HANDLING	   
	SN_ONMDIDEACTIVATE,
	SN_ONLAYERACTIVATE,
	SN_ONDATASETACTIVATE,

	//------- CPY 1/28/03 QA70-3796 COL_CHANGE_NOTIFICATIONS
	SN_COL_CHANGE_FORMAT,
	SN_COL_CHANGE_PLOT_DESIGNATION,
	SN_COL_CHANGE_ANALYSIS, // formula, auto update ranged
	SN_COL_CHANGE_RANGE,
	//------- end CPY 1/28/03 QA70-3796 COL_CHANGE_NOTIFICATIONS
	SN_ONIDLE,
};


/// TD 10-21-03 QA70-5067 PROPERTY_SHEET_AND_WIZARD_CLASS_IN_OC
enum{
	RESIZE_DEPENDENCY_DOMINANT_NONE,
	RESIZE_DEPENDENCY_DOMINANT_PAGE,
	RESIZE_DEPENDENCY_DOMINANT_DIALOG,
};
/// end PROPERTY_SHEET_AND_WIZARD_CLASS_IN_OC



//--------- CPY 12-28-02 QA70-3589 ORIGINC_ACCESS_TO_PRETRANSLATE_KEY_MSG
//outside EN_VSCROLL etc range
///// TD 12-27-02 QA70-3589 ORIGINC_ACCESS_TO_EDIT_ON_RETURN
//#define DDK_DLG_CTRL_MSG_EDITBOX_RETURN				1000
/// end ORIGINC_ACCESS_TO_EDIT_ON_RETURN
enum{
	OC_NOTIFICATION_KEY = 0x2000,
	OC_NOTIFICATION_EDITBOX_RETURN,
	OC_NOTIFICATION_OLE_DROP,/// TD 10-14-03 QA70-5322 DROPING_DATA_INTO_ORIGIN_FROM_DBX_CONTROL
};
#define DDK_DLG_CTRL_MSG_EDITBOX_RETURN	OC_NOTIFICATION_EDITBOX_RETURN
//--------- end CPY 12-28-02 QA70-3589 ORIGINC_ACCESS_TO_PRETRANSLATE_KEY_MSG

#endif //_DIALOGMESSAGES_H_