/*------------------------------------------------------------------------------*
 * File Name: Selection.h														*
 * Creation: YuI 12/18/2002													    *
 * Purpose: Selection class														*
 * Copyright (c) OriginLab Corp.2001, 2002										*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *------------------------------------------------------------------------------*/
#ifndef	_SELECTION_H
#define _SELECTION_H

/** >Internal Origin Objects 
		The Selection class provides methods and properties to access objects in selection

	Example:
		foreach(OriginObject obj in Selection.Objects)
		{
			// .. do something ..
		}
*/
class Selection
{
public:	
	Selection();
	~Selection();
public:
	/**
		Deselect all objects
	Example:
	void ResetSelection()
	{
		Selection.Reset();
	}
	*/
	void	Reset();
	/** 
		Selects object
	Return:
		FALSE if OriginObject passed to the function is invalid or can not be selected
	Example:
	void AddObjectToSelection(GraphObject& gr)
	{
		if( gr )
			Selection.Add(gr);
	}
	*/
	BOOL	Add(OriginObject& obj);
	
	/**
		Unselects object
	Return:
		FALSE if OriginObject passed to the function is invalid or not selected
	Example:
	void RemoveObjectFromSelection(GraphObject& gr)
	{
		if( gr )
			Selection.Remove(gr);
	}
	*/
	BOOL	Remove(OriginObject& obj);
	
	/**
		Example:
			void run_Objects()
			{
				OriginObject OrgObj;
				OrgObj = Selection.Objects(0);
				
				GraphObject go;
				go = (GraphObject)OrgObj;
				out_str(go.GetName());
			}
	*/
	OriginObject	Objects(int nIndex = 0);
	
	/**
		Collection of all objects in the selection
		Example:
		foreach(OriginObject obj in Selection.Objects)
		{
			// .. do something ..
		}
	*/
	Collection<OriginObject>	Objects;
};

#endif// _SELECTION_H