/*------------------------------------------------------------------------------*
 * File Name: Storage.h															*
 * Creation: TD 10-08-2002														*
 * Purpose: Origin C support for info variables in Origin objects				*
 * Copyright (c) OriginLab Corp.2003											*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *------------------------------------------------------------------------------*/

#ifndef _STORAGE_H
#define _STORAGE_H

//#include <string.h>

/** >Internal Origin Objects
*/
class storage
{
	
public:
	
	/**
	*/
	storage();
	
	/**
		Example:
			void run_Text()
			{	
				Page pg = Project.Pages();
				if(pg==NULL)
					return;
				
				storage st;	
				string strStorage = "Test";	
				st = pg.GetStorage(strStorage);	
				
				if(st.IsValid())
				{
					string strText = st.Text;
					out_str(strText);
				}	
			}
	*/
	string Text;

	/**
		Copy a storage section into a treenode
	Parameters:
		lpcszSecName = name of an existing section, 
		trNode = a TreeNode to receive the data
	Example:
		Page pg = Project.Pages();
		if(pg == NULL)
		   return;
		string strStorage = "Test";
		string strSection = "Params";
		Tree trTemp;
		storage st;
		st = pg.GetStorage(strStorage);
		if(st)
		{
			if(st.GetSection(strSection, trTemp))
				out_tree(trTemp);
		}
		
	Return:
		Returns TRUE on success and FALSE on failure.	
	*/
	BOOL GetSection(LPCSTR lpcszSecName, TreeNode& trNode);

	/**
		Copy a TreeNode branch into a storage section. Section is created if not already present
	Parameters:
		lpcszSecName = name of an existing section or a new section, must be valid C identifier name 
		trNode = a TreeNode to set the data
	Example:
		Page pg = Project.Pages();
		if(pg == NULL)
		   return;
		
		string strStorage = "Test";
		string strSection = "Params";
		
		Tree trTemp;
		trTemp.AA.factor.dVal = 1.2345;
		trTemp.AA.title.strVal = "This is a test";
		trTemp.BB.nOrder.nVal = 2;
		trTemp.BB.decay.dVal = 4.32;
		
		pg.Info.Add(strStorage);
		storage st;
		st = pg.GetStorage(strStorage);
		if(st)
		{
			if(st.SetSection(strSection, trTemp))
				out_str("done");
		}
		
	Return:
		Returns TRUE on success and FALSE on failure.	
	*/
	BOOL SetSection(LPCSTR lpcszSecName, TreeNode& trNode);
	
	/**
		Example:
			void run_GetSectionNames()
			{
				Page pg = Project.Pages();
				if(pg==NULL)
					return;
				
				storage st;
				string strStorage = "Test";
				st = pg.GetStorage(strStorage);
				if(st)
				{
					vector<string> vs;
					if(st.GetSectionNames(vs))
					{
						for(int ii=0;ii<vs.GetSize();ii++)
							out_str(vs[ii]);
					}
				}	
			}
	*/
	BOOL GetSectionNames(vector<string> &vsNames);

	/**
			Checks Validity of the Storage object.
		Return:
			FALSE if an Storage Object is not valid, non-zero otherwise.
		Example:
			void run_IsValid()
			{
				Page pg = Project.Pages();
				if(pg==NULL)
					return;
				
				storage st;
				string strStorage = "Test";
				st = pg.GetStorage(strStorage);
				if(st.IsValid())
				{
					out_str("OK");
				}	
			}
	*/
	BOOL IsValid();

	/**
			Load contents from file into storage class. They can be retrieved by GetTxt method.
		Parameters:
			lpcszFile = File name
		Return:
			Returns TRUE on success and FALSE on failure.
		Example:
			void run_Read()
			{
				storage st;	
				bool bRet = st.Read("C:\\Test.xml");
			}
	*/
	bool Read(LPCSTR lpcszFile);

	/**
			Write contents of a storage class into a file.
		Parameters:
			lpcszFile = File name
		Return:
			Returns TRUE on success and FALSE on failure.	
		Example:
			void run_Write()
			{	
				Page pg = Project.Pages();
				if(pg==NULL)
					return;
				
				storage st;	
				string strStorage = "Test";	
				st = pg.GetStorage(strStorage);	
				
				if(st.IsValid())
				{
					bool bRet = st.Write("C:\\Test.xml");
				}	
			}
	*/	
	bool Write(LPCSTR lpcszFile);
};


#endif //_STORAGE_H
