/*------------------------------------------------------------------------------*
 * File Name: Page_Utils.h														*
 * Creation: July 25, 2003														*
 * Purpose: Declare page utility functions										*
 * Copyright (c) OriginLab Corp. 2003											*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *------------------------------------------------------------------------------*/
enum {
	FILTER_TYPE_UNKNOWN = -1,
	FILTER_TYPE_ASCII = 0,
	FILTER_TYPE_BINARY,
	FILTER_TYPE_USERDEFINED,
	FILTER_TYPE_IGNORE = 100, // use with fuIsApplicable
};
#define IS_FILTER_TYPE(i)		(FILTER_TYPE_ASCII <= (i) && (i) <= FILTER_TYPE_USERDEFINED)

/** >Info Storage
	Get a section from an OriginObject's Info.
	Parameters:
		obj = the OriginObject to get the section from
		trSection = the tree node to put the section into
		lpcszStorageSection = pointer to the storage and section name
	Return:
		If success then true else false
	Example:
		Page pg("Data1");
		if( info_get_section(pg, trSection, "User.Variables") )
		{
		}
*/
bool info_get_section(OriginObject& obj, TreeNode& trSection, LPCSTR lpcszStorageSection);

/** >Info Storage
	Set a section into an OriginObject's Info.
	Parameters:
		obj = the OriginObject to set the section into
		trSection = the tree node containing the section
		lpcszStorageSection = pointer to the storage and section name
	Return:
		If success then true else false
	Example:
		void Run_info_set_section()
		{
			Tree    trSection;
			trSection.user.var.nVal = 1;
			
			Page pg("Data1");
			bool bRet = info_set_section(pg, trSection, "user.var");
		}
*/
bool info_set_section(OriginObject& obj, TreeNode& trSection, LPCSTR lpcszStorageSection);

/** >Info Storage
	Get the value of a variable in a Page's Info section
	Parameters:
		pg = the page to get the value from
		lpcszVarName = pointer to the name of the variable
		strVal = the string to receive the value
		lpcszInfo = pointer to the name of the section.  If NULL then the Variables section is used.
	Return:
		If success then true else false
	Example:
		void Run_page_get_info_var_value()
		{
			string 	strVal;	
			Page pg("Data1");
			bool bRet = page_get_info_var_value(pg,"var",strVal,"user.var");		
		}
*/
bool page_get_info_var_value(Page& pg, LPCSTR lpcszVarName, string& strVal, LPCSTR lpcszStorageSection=NULL);

/** >Info Storage
	Set the value of a variable in a Page's Info section
	Parameters:
		pg = the page containing the variable to set
		lpcszVarName = pointer to the name of the variable
		lpcszVarVal = pointer to the string value
		lpcszInfo = pointer to the name of the section.  If NULL then the Variables section is used.
	Return:
		If success then true else false
	Example:
		void Run_page_set_info_var_value()
		{
			Page pg("Data1");	
			bool bRet = page_set_info_var_value(pg,"var","abc","user.var");	
		}
*/
bool page_set_info_var_value(Page& pg, LPCSTR lpcszVarName, LPCSTR lpcszVarVal, LPCSTR lpcszStorageSection=NULL);

/** >Info Storage
	Get the value of a variable in a Page's Info section
	Parameters:
		pg = the page to get the value from
		lpcszVarName = pointer to the name of the variable
		dVal = the double to receive the value
		lpcszInfo = pointer to the name of the section.  If NULL then the Variables section is used.
	Return:
		If success then true else false
	Example:
		void Run_page_get_info_var_value()
		{
			double 	dVal;	
			Page pg("Data1");
			bool bRet = page_get_info_var_value(pg,"var",dVal,"user.var");		
		}

*/
bool page_get_info_var_value(Page& pg, LPCSTR lpcszVarName, double& dVal, LPCSTR lpcszStorageSection=NULL);

/** >Info Storage
	Set the value of a variable in a Page's Info section
	Parameters:
		pg = the page containing the variable to set
		lpcszVarName = pointer to the name of the variable
		lpcszVarVal = pointer to the string value
		lpcszInfo = pointer to the name of the section.  If NULL then the Variables section is used.
	Return:
		If success then true else false
	Example:
		void Run_page_set_info_var_value()
		{
			Page pg("Data1");	
			bool bRet = page_set_info_var_value(pg,"var",12.25,"user.var");	
		}
*/
bool page_set_info_var_value(Page& pg, LPCSTR lpcszVarName, double dVal, LPCSTR lpcszStorageSection=NULL);

/** >Info Storage
	Get a binary storage from a page into a string.
	Parameters:
		pg = the page containing the binary storage
		lpcszName = pointer to the name of the binary storage
		strVal = the string to receive the value
	Return:
		If success then true else false
	Example:
		void  Run_page_get_storage_str()
		{
			Page pg("Data1");
			string strName = "var";
			string strVal;
			bool bRet = page_get_storage_str(pg,strName,strVal);
			out_str(strVal);
		}
*/
bool page_get_storage_str(Page& pg, LPCSTR lpcszName, string &strValue);

/** >Info Storage
	Set a string into a page as a binary storage
	Parameters:
		pg = the page to contain the binary storage
		lpcszName = pointer to the name of the binary storage
		lpcszVarVal = pointer to the string value
	Return:
		If success then true else false
	Example:
		void  Run_page_set_storage_str()
		{
			Page pg("Data1");
			string strName = "var";
			string strVal = "Testing";
		    bool bRet = page_set_storage_str(pg,strName,strVal);
		}
*/
bool page_set_storage_str(Page& pg, LPCSTR lpcszName, LPCSTR lpcstrValue);


/** >Plotting
	Get Graphpage's DataPlots contents into a tree
	Parameters:
		pg = the Graph page to get the contents from
		tr = Tree to retrive the contents
	Return:
		If success then return the plot type for the next added plot, or return 0 if error
	Example:
		void Run_gpage_get_plots()
		{	
			Tree tr;
			GraphPage gp("graph1");
			int nRet = gpage_get_plots(gp,tr);
			out_tree(tr);
		}
*/
int	gpage_get_plots(const GraphPage &pg, TreeNode &tr);
// tree attributes that will be added for additional layer info
#define		STR_LAYER_TYPE_BITS				"LayerTypeBits"
#define		STR_ACTIVE_LAYER			"ActiveLayer"	// attribute in resulting tr if applicable

/** >Plotting
	Get the active layer number from the given page, if page is not the active window, then return -1
	Parameters:
		pg = the page to get the layer number
	Return:
		0-offset layer number if given page is the active window, otherwise return -1
	Example:
		void Run_page_active_layer_index()
		{
			GraphPage gp("Graph1");
			int nIndex = page_active_layer_index(gp);
		}
*/
int page_active_layer_index(Page& pg);


