<?php
/**
 * phpwind ͳ
 *
 * @author phpwind team
 * @version 1.0
 * @package api
 */
!defined('P_W') && exit('Forbidden');
require_once(R_P . 'api/class_Statistics.php');

class Statistics_House extends Statistics {

	/**
	 *
	 * ÿ췢۷Դ
	 */
	function getSalesOfDay($day = null){
		$this->_setTimestamp( $day );
		$sales = intval($this->db->get_value(
 			"SELECT COUNT(*) FROM `pw_house_saleinfo` 
 			WHERE `posttime` BETWEEN $this->startTime AND $this->endTime"
		));
		return new ApiResponse($sales);
	}

	/**
	 *
	 * ÿ췢ⷿԴ
	 */
	function getHiresOfDay($day = null){
		$this->_setTimestamp( $day );
		$hires = intval($this->db->get_value(
 			"SELECT COUNT(*) FROM `pw_house_hireinfo` 
 			WHERE `posttime` BETWEEN $this->startTime AND $this->endTime"
		));
		return new ApiResponse($hires);
	}

	/**
	 *
	 * ۷Դ
	 */
	function getSalesCount(){
		$sales = 0;
		$sales = intval($this->db->get_value("SELECT SUM(salenum) FROM `pw_house_secondpost` "));
		return new ApiResponse($sales);
	}

	/**
	 *
	 * ⷿԴ
	 */
	function getHireCount(){
		$hires = 0;
		$hires = intval($this->db->get_value("SELECT SUM(hirenum) FROM `pw_house_secondpost` "));
		return new ApiResponse($hires);
	}

	/**
	 *
	 * ԴԴ
	 */
	function getNewHouseCount(){
		$hires = intval($this->db->get_value(
 			"SELECT COUNT(*) FROM `pw_house_info` "
 			));
 			return new ApiResponse($hires);
	}

	/**
	 *
	 * ȡtop10
	 */
	function getTopSales($num = 10){
		require_once R_P.'require/showimg.php';
		$sales = array();
		$num = (int)$num;
		$query = $this->db->query(
			"SELECT m.`username`,m.`icon`,d.`uid`,d.`salenum` AS `count` FROM `pw_house_secondpost` AS d
				LEFT JOIN `pw_members` AS m ON d.`uid`=m.`uid`
				ORDER BY `count` DESC 
				LIMIT $num"
		);
		while ($rt = $this->db->fetch_array($query)) {
			$sales[] = array(
			$rt['uid'],
			$rt['username'],
			showfacedesign($rt['icon']),
			$rt['count']
			);
		}
		return new ApiResponse($sales);
	}

	/**
	 *
	 * ȡtop10
	 */
	function getTopHires($num = 10){
		require_once R_P.'require/showimg.php';
		$hires = array();
		$num = (int)$num;
		$query = $this->db->query(
			"SELECT m.`username`,m.`icon`,d.`uid`,d.`hirenum` AS `count` FROM `pw_house_secondpost` AS d
				LEFT JOIN `pw_members` AS m ON d.`uid`=m.`uid`
				ORDER BY `count` DESC 
				LIMIT $num"
		);
		while ($rt = $this->db->fetch_array($query)) {
			$hires[] = array(
			$rt['uid'],
			$rt['username'],
			showfacedesign($rt['icon']),
			$rt['count']
			);
		}
		return new ApiResponse($hires);
	}

	/**
	 *
	 * ÿ쿪ͨ˵
	 */
	function getBrokersOfDay($day = null){
		$this->_setTimestamp( $day );
		$brokers = intval($this->db->get_value(
 			"SELECT COUNT(*) FROM `pw_house_broker` 
 			WHERE `createtime` BETWEEN $this->startTime AND $this->endTime"
		));
		return new ApiResponse($brokers);
	}

	/**
	 *
	 * ˷Դ
	 */
	function getSalesOfBroker(){
		$sales = intval($this->db->get_value(
 			"SELECT COUNT(*) FROM `pw_house_saleinfo` WHERE isbroker = 1"
 			));
 			return new ApiResponse($sales);
	}

	/**
	 *
	 * ˷ⷿԴ
	 */
	function getHiresOfBroker(){
		$hires = intval($this->db->get_value(
 			"SELECT COUNT(*) FROM `pw_house_hireinfo` WHERE isbroker = 1"
 			));
 		return new ApiResponse($hires);
	}
}