/**
* @fileoverview 
*
* @author yuyang <yuyangvi@gmail.com>
* @version 1.0
*/
Breeze.namespace('util.dialog', function(B){
	var dialogDef = {
		/**
		 * ĬϵĵID
		 * @type String
		 */
		id: 'pw_box',
		/**
		 * ǷظѾĵ
		 * @type Boolean
		 */
		reuse: true,
		/**
		 * HTML
		 * @type String
		 */
		data: null,
		/**
		* λ
		* @type Array
		* ĸԪص飬ֱ
		* <ol><li>һԪΪ'left'(),'leftalign'ض룩,'center'(),'right'У,'rightalign'ض룩еһ,</li>
		* <li>ڶԪΪ'top'(),'topalign'(ض),'center'(),'bottom'(),'bottomalign'(ض)еһ</li>
		* <li>ԪΪ֣ʾҵƫֵ,Ϊ0</li>
		* <li>ĸԪΪ֣ʾµƫֵ,Ϊ0</li></ol>
		*/
		pos: ['center','center',0,0],
		/**
		 * λõĲ
		 * @type HTMLElement
		 */
		posrel: null,
		/**
		 * ƿԶر
		 * @type Boolean
		 */
		autoHide: false, 
		/**
		 * 
		 * @type Boolean
		 */
		mask: false,
		/**
		 * ִкô˰¼档
		 * @type Function
		 */
		callback: null,
		outWin: false
	};
	
	/**
	 * @class 
	 */
	function Mask(){
		this.mask;
	}
	Mask.prototype={
		create: function(){
			if(this.mask){
				B.css(this.mask, 'display', '');
			}else{
				this.mask =  B.createElement('div', {}, {
					position: 'absolute',
					top: 0,
					left: 0,
					width: B.width(window),
					height: B.height(window),
					'background-color': '#000000',
					opacity: 0.6
				});
				var self = this;
				B.require('event', function(B){
					B.addEvent( window, 'resize', function(){
						self.resize.call(self);
					});
				}); 
				document.body.appendChild(this.mask);
			}
		},
		closep: function(){
			B.css(this.mask, 'display', 'none');
		},
		distory: function(){
			B.remove(this.mask);
		},
		resize: function(){
			B.css(this.mask,{
				width: B.width(window),
				height: B.height(window)
			});
		}
	};
	var mask = new Mask();
	/**
	 * 
	 */
	function Dialog(setting, ele)
	{
		if( !(this instanceof Dialog) ){
			return new Dialog(setting, ele);
		}
		/**
		 * յ
		 * @private {Setting}
		 */
		var popwin, self = this;
		B.merge(self, dialogDef, setting);
		ele && (self.posrel = ele);
		
		/*
		* IE6select
		if(B.UA.ie === 6) {
		    B.$$('select').forEach(function(n){
		        n.style.visibility = 'hidden';
		    });
		}
		*/
		/**
		 * չ
		 */
		B.require('dom', function(B){
			var popwin = B.$('#' + self.id);
			//趨
			if(self.mask){
				mask.create();
			}
			if (!popwin || !self.reuse){//û
				//ɵ
				popwin = B.$query(B.createElement(self.data))(B.attr, 'id', self.id)(B.css,{position:'absolute',visibility:'hidden'})();
				
				//趨߿
				self.width && B.css(popwin, 'width', self.width);
				self.height && B.css(popwin, 'height', self.height);
				document.body.appendChild(popwin);
				//󶨹ر¼
				B.require('event', function(B){
					B.$$query('.B_close', popwin)(B.addEvent, 'click', function(e){
						self.closep();
						e.preventDefault();
					});
				});
			}else{
				B.css(popwin, {display:'block', visibility:'hidden'});
			}
			//ʾ
			B.query(popwin)
				.layerOut(self.pos, self.posrel, self.outWin)
				.css({visibility:'visible', backgroundColor:'#ffffff'});
			self.win = popwin;
			self.callback && self.callback(self);
			//¼
			if(self.autoHide){
				B.require('event',function(B){
					var stopp = function(e){
						e.stopPropagation();
					};
					var closep = function(e){
						self.closep();
						B.removeEvent(document, 'click', closep);
						B.removeEvent(self.posrel, 'click', stopp);
						B.removeEvent(popwin,   'click', stopp);
					}
					B.addEvent(document, 'click', closep);
					B.addEvent(self.posrel, 'click', stopp);
					B.addEvent(popwin,   'click', stopp);
				});
			}
			
			//϶
			if(B.$('.B_drag_handle', popwin)){
				B.require('util.draggable', function(){
					B.util.draggable('#'+self.id, '.B_drag_handle');
				});
			}
		});
		
		return self;
	}
	
	Dialog.prototype = {
		closep: function(){
			if(this.reuse){
				B.css(this.win, 'display', 'none');
			} else {
				B.remove(this.win);
			}
			this.mask && mask.closep();
			var self = this;
			//ie6 select
			if(B.UA.ie === 6) {
		        B.$$('select').forEach(function(n){
		            n.style.visibility = 'visible';
		        });
		    }
			//TODO:ڴ
			setTimeout(function(){delete self;}, 0);
			//delete this;
		}
	};
	
	B.util.dialog = Dialog;

	/**
	 * λλ
	 * @type Array
	 */
	function layerOut(popwin, pos, rel, isOutWin)
	{
		var res = rel ? B.offset(rel) : 
			{
				left: (pos[0].indexOf('left') < 0) ? B.width(document.body) : 0,
				top:  (pos[1].indexOf('top') < 0) ? B.height(document) : 0
			};
		//ҳУбΪ
		if (!rel) {
			['left','right'].indexOf(pos[0])>-1 && (pos[0]+='Align');
			['top','bottom'].indexOf(pos[1])>-1 && (pos[1]+='Align');
		}
		
		//Xλ
		if (pos[0].indexOf('right') > -1 || pos[0]=='center') {
			pos[0] == 'center' && rel && (res.left *= 2);
			rel && (res.left += B.width(rel));
		}

		if (['left', 'rightAlign', 'center'].indexOf(pos[0])>-1){
			res.left -= B.width(popwin);
			pos[0] == 'center' && (res.left /= 2);
		}
		//res.left += B.scrollLeft();
		
		//Yλ
		if (pos[1].indexOf('bottom') > -1 || pos[1]=='center') {
			pos[1] == 'center' && rel && (res.top *= 2);
			rel && (res.top += B.height(rel));
		}

		if (['top', 'bottomAlign','center'].indexOf(pos[1])>-1) {
			res.top -= B.height(popwin);
			pos[1] == 'center' && (res.top /= 2);
		}
		//res.top += B.scrollTop();
		
		//ƫ
		pos[2] && (res.left += parseInt(pos[2]));
		pos[3] && (res.top += parseInt(pos[3]));
		
		//ֹƶĻ
		if(!isOutWin){
			if( res.left < B.scrollLeft() ){
				res.left = B.scrollLeft();
			}else if( res.left > B.scrollLeft()+B.width(window)-B.width(popwin) ){
				res.left = B.scrollLeft()+B.width(window)-B.width(popwin);
			}
			
			if( res.top < B.scrollTop() ){
				res.top = B.scrollTop();
			}else if( res.top > B.scrollTop()+B.height(window)-B.height(popwin) ){
				res.top = B.scrollTop()+B.height(window)-B.height(popwin);
			}
		}
		B.css(popwin, res);
	}
	B.extend('layerOut', function() {
		var arg = B.makeArray(arguments),finalEls = [];
		for(var i = 0,j = this.nodes.length; i < j; i++) {
			var el = this.nodes[i],
				result = layerOut.apply(el,[el].concat(arg));
			finalEls = finalEls.concat(B.makeArray(result || []));
		}
		//ǻȡԪ,µǰthis.el
		if(finalEls.length > 0){
			this.nodes = finalEls;
			this.length = finalEls.length;
		}
		return this;
	});
	/**
	 * Ѻ;
	 */
	B.util.alert = function(str){
		Dialog({
			pos: ['center', 'center'],
			data:'<div class="B_dialog_alert"><h4></h4><p>'+str+'</p><div><input type="button" class="B_close" value="ر" /></div></div>',
			reuse: true,
			mask:true
		});
	}
});