<?php
!function_exists('readover') && exit('Forbidden');
/**
 * ݵʵ幤ߣ˵һϵжʵ
 * ײķװ͵ãÿԵã
 * ʵⲿ󣬱Ҫбתôֱӵ
 * еıתɻݣ
 *
 * @package Filter
 */
class PW_FilterUtil {
	/**
	 * лֵŵĬ·
	 * @var string
	 */
	var $dict_bin_path;
	/**
	 * ĬֵĴλ
	 * @var string
	 */
	var $dict_dir;
	/**
	 * Ĭıʽֵ·
	 * @var string
	 */
	var $dict_source_path;
	/**
	 * μдȨصȼ
	 * @var int
	 */
	var $filter_weight = 0;
	/**
	 * μд
	 * @var array
	 */
	var $filter_word;

	var $code;
	var $fbwords = null;
	var $replace = null;
	var $_list = array();

	function PW_FilterUtil($file = array()) {
		if ($file) {
			$this->dict_dir = $file['dir'];
			$this->dict_bin_path = $file['bin'];
			$this->dict_source_path = $file['source'];
		} else {
			$this->dict_dir = D_P.'data/bbscache/';
			$this->dict_path = $this->dict_dir . 'wordsfb.php';
			$this->dict_bin_path = $this->dict_dir . 'dict_all.dat';
			$this->dict_source_path = $this->dict_dir . 'dict_all.txt';
		}
		$this->code = $GLOBALS['db_wordsfb'];
	}

	function setFiles($file) {
		$this->dict_dir = $file['dir'];
		$this->dict_bin_path = $file['bin'];
		$this->dict_source_path = $file['source'];
	}

	/**
	 * ַǷҪ滻
	 */
	function ifwordsfb($str) {
		return ($this->comprise($str) === false) ? $this->code : 0;
	}

	function equal($currcode) {
		return ($currcode == $this->code);
	}

	function loadWords() {
		if (!is_array($this->fbwords)) {
			//* include pwCache::getPath(D_P."data/bbscache/wordsfb.php");
			extract(pwCache::getData(D_P."data/bbscache/wordsfb.php", false));
			$this->fbwords	= (array)$wordsfb;
			$this->replace	= (array)$replace;
			$this->alarm	= (array)$alarm;
		}
	}
	/**
	 * һ滻ַ
	 */
	function convert($str, $wdstruct = array()) {
		$this->loadWords();
		$replacedb = $this->fbwords + $this->replace + $this->alarm;
		$msg = $str;
		if ($replacedb) {
			foreach ($replacedb as $key => $value) {
				$msg = preg_replace("/$key/i", $value, $msg);
			}
		}
		if ($wdstruct) {
			if ($msg == $str) {
				$this->addList('yes', $wdstruct['type'], $wdstruct['id']);
			} elseif ($wdstruct['code'] > 0) {
				$this->addList('no', $wdstruct['type'], $wdstruct['id']);
			}
		}
		return $msg;
	}
	function addList($key, $type, $id) {
		if (empty($this->_list)) {
			register_shutdown_function(array($this, 'updateWordsfb'));
		}
		$this->_list[$key][$type][] = $id;
	}
	/**
	 * ݵĴϵ
	 */
	function updateWordsfb() {
		if ($this->_list['yes']) {
			$this->_update($this->_list['yes'], $this->code);
		}
		if ($this->_list['no']) {
			$this->_update($this->_list['no'], 0);
		}
		$this->_list = array();
	}

	function _update($arr, $val) {//private function
		global $db;
		foreach ($arr as $k => $v) {
			list($table, $field) = $this->tablestruct($k);
			if ($table && $v) {
				/**
				$db->update("UPDATE $table SET ifwordsfb=" . S::sqlEscape($val) . " WHERE $field IN (" . S::sqlImplode($v) . ')');
				**/
				pwQuery::update("{$table}", "$field IN (:$field)", array($v), array('ifwordsfb' => $val));
			}
		}
	}

	function tablestruct($type) {
		$struct = array(
			'topic'		=> array($GLOBALS['pw_tmsgs'], 'tid'),
			'posts'		=> array($GLOBALS['pw_posts'], 'pid'),
			'comments'	=> array('pw_comment', 'id'),
			'oboard'	=> array('pw_oboard','id'),
			'diary'		=> array('pw_diary','did')
		);
		return isset($struct[$type]) ? $struct[$type] : array('','');
	}

	/**
	 * ַǷô
	 *
	 * @param $str
	 * @param $replace
	 * @param $alarm
	 * @return bool ǷôtrueΪfalseΪûнô
	 */
	function comprise($str, $replace = true,$alarm = true) {
		if (empty($str)) {
			return false;
		}
		$this->loadWords();
		foreach ($this->fbwords as $key => $value) {
			if (preg_match("/$key/i", $str)) {
				return $this->getTrueBanword($key);
			}
		}
		if ($replace) {
			foreach ($this->replace as $key => $value) {
				if (preg_match("/$key/i", $str)) {
					return $this->getTrueBanword($key);
				}
			}
		}
		if ($alarm) {
			foreach ($this->alarm as $key => $value) {
				if (preg_match("/$key/i", $str)) {
					return $this->getTrueBanword($key);
				}
			}
		}
		return false;
	}

	function getTrueBanword($word) {
		$word = stripslashes($word);
		//$word = substr($s_word,1,strlen($word)-3);
		$word = preg_replace('/\.\{0\,(\d+)\}/i', '', $word);
		return $word;
	}
	/**
	 * Ƿб
	 */
	function alarm($title, $content = '') {
		if ($this->alarm) {
			foreach ($this->alarm as $key => $value) {
				if (preg_match($key,$title) || preg_match($key,$content)) {
					return true;
				}
			}
		}
		return false;
	}

    /**
	* @desc Ψһʵ,Ϊ

	function getInstance() {
		static $instance = null;
		if (!isset($instance)) {
			$instance = new FilterUtil();
		}
		return $instance;
	}*/

    /**
     * ֵ
     * @param $path лֵ·
     * @return $return int ɹ󷵻ص
     */
    function buildDict($path = null) {
        if($path == null) {
           $path = array(
                'bin'    => $this->dict_bin_path,
                'source' => $this->dict_source_path
            );
        }
        $trie = new Trie($path);
        $return = $trie->build();
        return $return;
    }

    /**
     * 
     * 1.HTML 2. ˻ 3.Ӣı
     * 4. ת 5. ʺϲ 6. ִƥ 7.Ȩ
     * ע:ӢıȫǷţִܻ
     * @param $content string ɾĴִʵ
     * @param $skip int  ʾ
     * @param $convert boll  ת
     * @param $dic_path string лֵ·
     * @return $weight int ĵȨ
     */
	function paraseContent($content, $skip = 0, $convert = false, $dict_path = null) {

		//ûıUBBǩ
		//$content = $this->filterWindCode($content);

		//ûıHTMLǩ
		$content = $this->filterHtml($content);

		//״̬ż,Ƭ
		//$content = $this->filterChineseCode($content);

		//˼óĸֱţȫǺͰ
		// $content = $this->filterSymbol($content);

		if($convert){
			//бתҪڷת
			$content = $this->convertCode($content);
		}

		if ($skip >= 1) {
			$skip = intval($skip);
			//ʴ
			$content = $this->skipWords($skip,$content);
		}
		$file = array(
			'bin'    => $this->dict_bin_path,
			'source' => $this->dict_source_path
		);
		$trie = new Trie($file);

		//ṩҹؼֵķ
		$result = $trie->search($content, $dict_path);
		if (empty($result)) {
            return 0;
        }

		$bayes = new Bayes();
		//ȡȨ
		$weight = $bayes->getWeight($result);
		return array($weight,$result);
    }

	function getFilterResult($content, $skip = 0, $convert = false, $dict_path = null ) {
		//жд
		$result = $this->paraseContent($content);
		$array = array();
		//жϽ
		if (is_array($result)) {
			foreach ($result[1] as $key=>$value) {
				$array[$key] = $value[0];
			}
			$array = array_unique($array);

			$this->filter_weight = $result[0] >= 1 ? 1 : ($result[0] >= 0.8 ? 2 : 3);
		}
		$this->filter_word = $array;
	}

	/**
	 * @desc filter¼
	 *
	 * @param int $tid -- id
	 * @param int $pid -- ظid
	 * @param string $filter -- д
	 */
	function insert($tid, $pid, $filter, $state=0) {
    	global $db,$timestamp;

    	//жǷظ¼
    	$sql = "SELECT id,state FROM pw_filter WHERE tid=".S::sqlEscape($tid)." AND pid=".S::sqlEscape($pid);
    	$record = $db->get_one($sql);

	    if (!$record) {
	    	//
	    	$value = array(
	    	    'tid'    => $tid,
	    	    'pid'    => $pid,
	            'filter' => $filter,
	            'state'  => ($state!=3 ? 0 : 3),
				'assessor'=> ($state!=3 ? '' : 'SYSTEM'),
	            'created_at' => $timestamp,
				'updated_at' => $timestamp,
	        );
	        //¼¼
	        $db->update("INSERT INTO pw_filter SET " . S::sqlSingle($value));
    	} else {
    		if ($record['state'] == 2 || $record['state'] == 1) {
    			//
				$value = array(
					'state'  => 0,
					'filter' => $filter,
					'created_at' => $timestamp,
				);
				$value = S::sqlSingle($value);

    			//¼¼
				$sql = "UPDATE pw_filter SET {$value} WHERE tid=".S::sqlEscape($tid)." AND pid=" . S::sqlEscape($pid);
				$db->update($sql);
    		}
    	}
    }

	/**
	 * @desc ɾfilter
	 *
	 * @param int $tid id
	 * @param int $pid ظid
	 */
	function delete($tid, $pid) {
		global $db;
		$db->update("DELETE FROM pw_filter WHERE tid=" . S::sqlEscape($tid) . " AND pid=" . S::sqlEscape($pid));
	}

	/**
	 * ˼óĸֱţȫǺͰ
	 * @param $content HTMLǩ˵
	 * @return $ret string ع˺Ľ
	 */
	function filterSymbol($content) {
		$length = strlen($content);
		$i = 0;
		$ret = '';
		while ($i < $length) {
			$c = ord($content[$i]);
			if($c<48 || ($c>58 && $c <65) || ($c>90 && $c <97) ||($c>122 && $c<127) ) {
				$i++;
				continue;  //ASCIIй涨ķĸ
			}
			$ret .= chr($c);
			$i++;
		}
		return $ret;
	}

    /**
     * бתҪڷת
     * @param $fcode from code ԭı,"BIG5"
     * @param $tcode to codeĿ,"GB2312"
     * @param $content Ѿıת
     * @param $dict_dir תַձλ
     * @return $ret string תı
     */
    function convertCode($content, $fcode = 'CHST', $tcode = 'CHSS', $dict_dir = null) {
        if(is_null($dict_dir)) {
            $dict_dir = $this->dict_dir;
        }
        L::loadClass('Chinese', 'utility/lang', false);
        $ch = new Chinese($fcode, $tcode, true);
        $ret = $ch->Convert($content);
        return $ret;
    }

    /**
     * ʴ
     * @param $skip Ծ
     * @param $content ı
     * @param $dict_dir ֵıļλ
     * @return $ret ʴı
     */
    function skipWords($skip, $content, $dict_dir=null) {
        $ret = $content;
        if(is_null($dict_dir)) {
            $dict_dir = $this->dict_source_path;
        }

        $handle = fopen($dict_dir,"r");
        while (!feof($handle)) {
            $lines = fgets($handle);
			//echo $lines;
			//exit;
			//echo $lines;
			//$lines = "ŷ 1";
            preg_match('/^(.*?)\s+(.*)/i', $lines, $key);
            $len = strlen($key[1]); //ؼʳ
            for($i=0; $i<$len;$i++) { //ʼƴװ
                if($i == 0) {
					if(ord($key[1][$i]) > 127){
						$rgx = substr($key[1], $i,2);
						$i++;
					}else{
						$rgx = substr($key[1], $i,1);
					}
                } else  {
					if(ord($key[1][$i]) > 127){
						$rgx .= "(.{0,".$skip."}?)". substr($key[1], $i,2);
						$i++;
					}else{
						$rgx .=  substr(str_replace(array('/','.'),array('\/','\.'),$key[1]), $i,1);
					}
                    if($i == $len-1) {
                        $rgx ="/" . $rgx ."/";
                    }
                }
            }
			//echo "$rgx, $key[1], $ret";

			//echo $rgx;exit;
            $ret = preg_replace($rgx, $key[1], $ret);
        }
        fclose($handle);
        return $ret;
    }

    /**
     * ûıUBBǩ
     * @param $content string ûı
     * @return string  ر˺ı
     */
    function filterWindCode($content) {
    	$pattern = array();
    	if (strpos($content,"[post]")!==false && strpos($content,"[/post]")!==false) {
    		$pattern[] = "/\[post\].+?\[\/post\]/is";
    	}
    	if (strpos($content,"[hide=")!==false && strpos($content,"[/hide]")!==false) {
    		$pattern[] = "/\[hide=.+?\].+?\[\/hide\]/is";
    	}
    	if (strpos($content,"[sell")!==false && strpos($content,"[/sell]")!==false) {
    		$pattern[] = "/\[sell=.+?\].+?\[\/sell\]/is";
    	}
    	$pattern[] = "/\[[a-zA-Z]+[^]]*?\]/is";
    	$pattern[] = "/\[\/[a-zA-Z]*[^]]\]/is";

    	$content = preg_replace($pattern,'',$content);
    	return trim($content);
    }

    /**
     * ûıHTMLǩ
     * @param $content string ûı
     * @return $ret string  ر˺ı
     */
    function filterHtml($content) {
        $ret = strip_tags($content);
        return $ret;
    }

    /**
     * ״̬ż,Ƭ
     * @param $content  string  Ҫ˵ַ
     * @return $ret string ˺ַ
     */
    function filterChineseCode($content) {
        $ret = "";
        $chars = array();
        //ΪǷΪı
        $is_code = false;
        $length = iconv_strlen($content,"GBK");
        for ($i=0; $i<$length; $i++) {
            $chars[] = iconv_substr($content, $i, 1, "GBK");
        }

        foreach($chars as $char){

            for($byte = 0xA0; $byte<= 0xA9; $byte++) {
                if(strlen($char) == 2 && ord($char[0]) == $byte) {
                    $is_code = true;
                    continue;
                }
            }
            if(!$is_code) {
                $ret .= $char;
            }
            //ݱλ
            $is_code = false;
        }
        return $ret;
    }
}

class Trie {
    //Ĭлֵ·
    var $default_out_path ;
    //Ĭԭʼֵ·
    var $default_dict_path ;
    //ڵ顣ÿڵΪԪ飬ΪǷҶӽڵ㣬ӽڵ.
    var $nodes ;

    function Trie($file) {
        $this->default_out_path  = $file['bin'];
        $this->default_dict_path = $file['source'];
    }

    /**
     * 洢лıȲװ
     * @param $path  string ֵλ
     * @param $out_path  string лλ
     * @return $ret mixed Ƿɹɹfalse
     */
    function build($path = null, $out_path = null) {
        if(empty($path)) {
            $path = $this->default_dict_path;
        }
        if(empty($out_path)) {
            $out_path = $this->default_out_path;
        }

        $words = $this->getDict($path);
        $tree = $this->getTree($words);
        $ret = $this->putBinaryDict($out_path, $tree);
        $a = true;
        return $ret;
    }

    /**
     * ṩҹؼֵķ
     * @param $content string Ҫҵı
     * @param $dict_path лֵ·
     * @return $matchs array ҵĹؼֺȨ
     */
    function search($content, $dict_path) {
        if(empty($dict_path)) {
            $dict_path = $this->default_out_path;
        }
        $words = $this->getBinaryDict($dict_path);
		if ($words) {
			$this->nodes = $words;
			$matchs = $this->match($content);
			return $matchs;
		} else {
			return false;
		}
    }

    /**
     * ļеֵзŵȥ
     * @param $path string ֵ·
     * @return $words array ֵ
     */
    function getDict($path) {
        $i = 0;
        $words = array();

        $handle = fopen($path, "r");

        if($handle == false) {
            return $words;
        }
        while(!feof($handle)) {
            $words[$i] = trim(fgets($handle));
            $i++;
        }
        fclose($handle);
        return $words;
    }

    /**
     * ȡлֵ䲢л
     * @param $path string лֵ·
     * @return $words array л
     */
    function getBinaryDict($path = null) {
        if(empty($path)) {
            $path = $this->default_out_path;
        }
		$words = readover($path);
        if(!$words) {
            return array();
        }
        $words = unserialize ($words);
        return $words;
    }

    /**
     * ֵл󱣴浽ļ
     * @param $path string ·
     * @param $words array ʽֵ
     * @return $ret mixed ûбɹfalse
     */
    function putBinaryDict($path, $words) {
        if(empty($path)) {
            $path = $this->default_out_path;
        }
        if(!$words) {
            return ;
        }
        $words = serialize($words);
        $handle = fopen($path, 'wb');
        $ret = fwrite($handle, $words);
        if($ret == false) {
            return false;
        }
        fclose($handle);
        return $ret;

    }

    /**
     * Ĺ̷
     * @param $words array ֵȨ
     */
    function getTree($words) {
        $this->nodes = array( array(false, array()) ); //ʼӸڵ
        $p = 1; //һҪĽڵ
        foreach ($words as $word) {
			$cur = 0; //ǰڵ
			//preg_match('/^(.*?)\s+(.*)/i', $word, $weight); //ȡؼֺȨ
			//$weight = explode("|", $word);
			//$word = trim($weight[0]);
			list($word, $weight) = $this->split($word);
			for ($len = strlen($word), $i = 0; $i < $len; $i++) {
				$c = ord($word[$i]);
				if (isset($this->nodes[$cur][1][$c])) { //Ѵھ
					$cur = $this->nodes[$cur][1][$c];
					continue;
				}
				$this->nodes[$p]= array(false, array()); //½ڵ
				$this->nodes[$cur][1][$c] = $p; //ڸڵ¼ӽڵ
				$cur = $p; //ѵǰڵΪ²
				$p++; //
			}
			$this->nodes[$cur][0] = true; //һʽҶӽڵ
			$this->nodes[$cur][2] = trim($weight); //ȨطҶӽڵ
		}
		return $this->nodes;
	}

	function split($str) {
		if (($pos = strrpos($str, '|')) === false) {
			return array($str, 0);
		}
		return array(substr($str, 0, $pos), substr($str, $pos+1));
	}

    /**
     * ؼֵķ
     * @param $s string Ҫҵı
     * @return $ret array ҵĹؼʼȨ
     */
    function match($s) {
        $isUTF8 = strtoupper(substr($GLOBALS['db_charset'],0,3)) === 'UTF' ? true : false;
        $ret = array();
        $cur = 0; //ǰڵ㣬ʼΪڵ
        $i = 0; //ַǰƫ
        $p = 0; //ַλ
        $len = strlen($s);
        while($i < $len) {
            $c = ord($s[$i]);
            if (isset($this->nodes[$cur][1][$c])) { //
                $cur = $this->nodes[$cur][1][$c]; //Ƶǰڵ
                if ($this->nodes[$cur][0]) { //Ҷӽڵ㣬ƥ䣡
                    $ret[$p] = array(substr($s, $p, $i - $p + 1), $this->nodes[$cur][2]); //ȡƥλúƥĴԼʵȨ
                    $p = $i + 1; //һλ
                    $cur = 0; //õǰڵΪڵ
                }
				$i++; //һַ
            } else { //ƥ
				$cur = 0; //õǰڵΪڵ
                if (!$isUTF8 && ord($s[$p]) > 127 && ord($s[$p+1]) > 127) {
					$p += 2; //һλ
				} else {
					$p += 1; //һλ
				}
				$i = $p; //ѵǰƫΪλ
            }
        }
        return $ret;
    }
}

/**
 * ݸȨضĵ֣ĿǰʹBayes㷨ǴƵӰ
 * 㷨£
 * ĵзִt1,t2,t3,tn,ȨطֱΪw1,w2,w3,,wn
 * Bayes㷨ĵȨΪ
 * p1 = w1*w2*w3**wn
 * p2 = (1-w1)*(1-w2)*(1-w3)**(1-wn)
 * ĵȨ w = p1/(p1+p2)
 * p1+p2=0,ĵȨΪ1
 * Ȩص0.5ĹؼʻήȨأ0.5Ȩ
 * 0.9, 0.8, 0.5, 0.6 BayesȨΪ0.98
 * 0.9, 0.8, 0.5, 0.1 ȨؽΪ0.8
 */
class Bayes {

    /**
     * ȡȨ
     * @param $keys ĵƥĹؼ鼰ȨϢ
     * @return  $weight Bayes㷨Ȩ
     */
    function getWeight($keys) {
		//print_r($keys);
        $p1 = 1;
        $p2 = 1;
        foreach($keys as $key) {
            if( empty($key[1]) ) {
                continue;
            }
            $weight = floatval($key[1]);
            $p1 *= $weight;
            $p2 *= (1- $weight);
        }
        if( ($p1 + $p2) == 0 ) {
            $weight = 1;
            return $weight;
        }

        $weight = $p1 / ($p1 + $p2);
        return $weight;
    }
}
?>