<?php
!defined('P_W') && exit('Forbidden');

/**
 * ǩݲ
 * @package  PW_TagsDB
 * @author panjl @2010-12-27
 */
class PW_TagsDB extends BaseDB {
	var $_tableName 	= 	'pw_membertags';
	var $_primaryKey 	= 	'tagid';
	var $_membertags_detail = "pw_membertags_relations";
	/**
	 * 
	 * 
	 * @param array $fieldsData 飬ݿֶΪkey
	 * @return int
	 */
	function insert($fieldsData) {
		$fieldsData = $this->_checkData($fieldsData);
		return $this->_insert($fieldsData);
	}

	/**
	 * 
	 * 
	 * @param array $fieldsData 飬ݿֶΪkey
	 * 
	 */
	function update($fieldsData,$tagid) {
		$fieldsData = $this->_checkData($fieldsData);
		return $this->_update($fieldsData,$tagid);
	}
	
	/**
	 * ±ǩʹ
	 * 
	 * @param int $tagid ǩ
	 * @return boolean
	 */
	function updateNumByTagId($tagid,$num) {
		if(!$tagid) return false;
		return (bool)$this->_db->update("update " . $this->_tableName . " SET num = num + " . $num . " WHERE tagid = " . $this->_addSlashes($tagid));
	}
	
	/**
	 * ɾǩ
	 * 
	 * @param array $tagids
	 * @return boolean
	 */
	function deleteTagsByTagIds($tagids) {
		if(!S::isArray($tagids)) return false;
		pwQuery::delete($this->_tableName, "tagid in(:tagid)", array($tagids));
		return (bool)$this->_db->affected_rows();
	}
	
	/**
	 * ݱǩIDȡǩϢ
	 * 
	 * @param int $tagid ǩ
	 * @return array
	 */
	function getTagsByTagid($tagid) {
		if(!$tagid) return array();
		return $this->_db->get_one("SELECT * FROM " . $this->_tableName . " WHERE tagid = " . $this->_addSlashes($tagid));
	}


	/**
	 * ݱǩIDȡǩϢ
	 * 
	 * @param int $uid ûID
	 * @return array
	 */
/*
	function getTagsByTagids($tagids) {
		if(!S::isArray($tagids)) return array();
		$query = $this->_db->query("SELECT * FROM " . $this->_tableName . " WHERE tagid IN(" . S::sqlImplode($tagids) . ")");
		return $this->_getAllResultFromQuery($query);
	}
*/
	function getTagsByUid($uid) {
		if(!$uid) return array();
		$query = $this->_db->query("SELECT t.tagid,t.tagname FROM " . $this->_tableName . " t LEFT JOIN " . $this->_membertags_detail . " mt USING(tagid) WHERE mt.userid = " . $this->_addSlashes($uid) . " ORDER BY crtime DESC");
		return $this->_getAllResultFromQuery($query);
	}

	/**
	 * ûuidsȡǩϢ
	 * 
	 * @param int $uids ûuids
	 * @return array
	 */
	function getTagsByUids($uids) {
		if(!S::isArray($uids)) return array();
		$query = $this->_db->query("SELECT t.tagid,t.tagname,mt.userid FROM " . $this->_tableName . " t LEFT JOIN " . $this->_membertags_detail . " mt USING(tagid) WHERE mt.userid IN(" . S::sqlImplode($uids) . ")");
		return $this->_getAllResultFromQuery($query);
	}
	
	/**
	 * ݱǩȡǩϢ
	 * 
	 * @param string $name ǩ
	 * @return int stidֵ
	 */
	function getTagsByName($name) {
		if (!is_string($name)) return array();
		return $this->_db->get_one("SELECT * FROM " . $this->_tableName . " WHERE tagname = " . $this->_addSlashes($name));
	}
	
	/**
	 * Ƿűǩ
	 * 
	 * @param array $tagids
	 * @return boolean
	 */
	function setHotByTagids($tagids,$ifhot) {
		if(!S::isArray($tagids)) return false;
		pwQuery::update($this->_tableName, "tagid in(:tagid)", array($tagids), array('ifhot'=>$ifhot));
		return $this->_db->affected_rows();
	}
	
	/**
	 * űǩtop100
	 * 
	 * @param int $num
	 * @return int stidֵ
	 */
	function getTagsByNum($num = 100) {
		$num = ($num < 100) ? $num : 100;
		$query = $this->_db->query("SELECT tagid,tagname,num FROM  " . $this->_tableName . " WHERE ifhot = 1 ORDER BY num DESC " . S::sqlLimit($num));
		return $this->_getAllResultFromQuery($query);
	}
	
	/**
	 * ǩϢ
	 * 
	 * @param string $name ǩ
	 * @param int $ifhot Ƿűǩ
	 * @param int $startnum minʹ 
	 * @param int $endnum maxʹ 
	 * @param int $page
	 * @param int $perpage
	 * @return array
	 */
	function getTagsByCondition($name, $ifhot, $startnum, $endnum, $page = 1, $perpage = 20, $precision = null) {
		$addsql = " WHERE 1";
		if ($name != '' && !$precision) $addsql .= ' AND tagname = ' . $this->_addSlashes($name);
		if ($name != '' && ($precision == 'like')) $addsql .= ' AND tagname like ' . $this->_addSlashes('%'.$name.'%');
		if ($startnum != '') $addsql .= ' AND num >= ' . $this->_addSlashes($startnum);
		if ($endnum != '') $addsql .= ' AND num <= ' . $this->_addSlashes($endnum);
		if ($ifhot != '') $addsql .= ' AND ifhot = ' . $this->_addSlashes($ifhot);
		$total =  $this->_db->get_value('SELECT count(*) FROM  ' . $this->_tableName . ' ' . $addsql);
		$addsql .= ' ORDER BY num DESC';
		$offset = ($page - 1) * $perpage;
		$addsql .= $this->_Limit($offset,$perpage);
		$query = $this->_db->query('SELECT * FROM  ' . $this->_tableName .' '. $addsql);
		return array($total,$this->_getAllResultFromQuery($query));
	}

	/**
	 * ݱkey
	 * 
	 * @return array key
	 */
	function _checkData($data) {
		if(!S::isArray($data)) return null;
		$data = $this->_checkAllowField($data,$this->getStruct());
		return $data;
	}

	/**
	 * ݱkey
	 * 
	 * @return array key
	 */
	function getStruct() {
		return array('tagid','tagname','num','ifhot');
	}
}