Add-Type @"
namespace AcquireDeveloper
{
    using System;
    using System.Runtime.InteropServices;
  

internal static class NativeMethods
{
          
    [DllImport("WSClient.dll", EntryPoint = "AcquireDeveloperLicense", SetLastError = true)]
    public static extern int AcquireDeveloperLicense(IntPtr hwnd, out System.Runtime.InteropServices.ComTypes.FILETIME filetime);

	[DllImport("WSClient.dll", EntryPoint = "CheckDeveloperLicense", SetLastError = true)]
    public static extern int CheckDeveloperLicense(out System.Runtime.InteropServices.ComTypes.FILETIME filetime);
}

public class Program
{
    public static void Main(string[] args)
    {
        System.Runtime.InteropServices.ComTypes.FILETIME ft;
        
		try{
		int checkRet = NativeMethods.CheckDeveloperLicense(out ft);
		long hFTicks = (((long)ft.dwHighDateTime) << 32) + ft.dwLowDateTime;
		DateTime dtExpiry1 = DateTime.FromFileTime(hFTicks);
		Console.WriteLine("CheckDeveloperLicense returned {0}, filetime is {1}", checkRet, dtExpiry1.ToString());
		
		if(dtExpiry1>DateTime.Now){
			Console.WriteLine("Ѿװ˿֤");
			return;
		}
		}catch{}
		
        int iRet = NativeMethods.AcquireDeveloperLicense(IntPtr.Zero, out ft);
        long hFT2 = (((long)ft.dwHighDateTime) << 32) + ft.dwLowDateTime;
		
        DateTime dtExpiry = DateTime.FromFileTime(hFT2);

        Console.WriteLine("AcquireDeveloperLicense returned {0}, filetime is {1}", iRet, dtExpiry.ToString());
		Console.ReadKey();
    }
}

}

"@

[AcquireDeveloper.Program]::Main($null)