
hintType = {}

hintType.bottomRight	= 0
hintType.bottomLeft		= 1
hintType.topRight		= 2
hintType.topLeft		= 3

emptyObj = nil

function copy(obj, template)
	obj = {}
	for key, value in pairs(template) do
		if(type(value) == 'table') then
			obj[key] = copy(obj[key], template[key])
		else
			obj[key] = value
		end 
	end
	
	return obj
end

hintCorners = 
{
	Image = "Icons.jpg",
	Animation  =
	{        
		FramesList =
		{	
			{553, 398, 602, 453}
		}
	}
};

StuffMarkRect = {923, 153, 975, 216}

HintUpgradeRects = 
{
	{
		maxUpgrades = 3,
		data = 
		{
			{0, 634, 17, 708},
			{17, 634, 34, 708},
			{34, 634, 51, 708}
		}
	},

	{
		maxUpgrades = 4,
		data = 
		{
			{51, 634, 68, 708},
			{68, 634, 85, 708},
			{85, 634, 102, 708},
			{102, 634, 119, 708}
		},
	},
		
	{
		maxUpgrades = 5,
		data = 
		{
			{119, 634, 136, 708},
			{136, 634, 153, 708},
			{153, 634, 170, 708},
			{170, 634, 187, 708},
			{187, 634, 204, 708}
		}   
	}
}

mapHintTitles = 
{
	"Gardener",
	"Employee",
	"Fairy",
	"Leftcounter",
	"Rightcounter",
	"Storehouse",
	"MillBuilding",
	"OilBuilding",
	"PackingBuilding",
	"JuiceBuilding",
	"ConfectioneryBuilding",
	"TomatoBuilding",
	"BakeryBuilding",
	"RoasterBuilding",
	"SandwichBuilding",
	"FriesBuilding",
	"DoughBuilding",
	"Garden",
	"Shop",
	"WaterWell",
	"Rope",
	"RopeLadder",
	"WoodenLadder",
	"Teleport",
	"Cage",
}

MapHint = 
{
	--hint window settings
	delay=0,
	windowStyle =
	{
		SrcRect          = {0, 313, 152, 465},
		Image            = "Icons.jpg",
		WinSize          = {220, 140},
		AngleScrSize     = {25, 25},
	},

	-- ""
	levelNumCaption = 
	{
		name			= "levelNumCaption",
		dataType		= "text",
		Caption 		= "Level",
		Font			= "font05.fnt",
		TextArea		= {10, 22, 140, 32},
		Colour			= {0.07901, 0.02745, 0.39512, 1}, --
		SRatio 			= 0.8,
		HAlign			= "right",
		VAlign			= "center",
		SizeW			= 1.0,
		SizeH			= 1.0,
	},
	-- 
	levelNum = 
	{
		name			= "levelNum",
		dataType		= "text",
		Caption 		= "one_num",
		Font			= "font05.fnt",
		TextArea		= {140, 22, 210, 32},
		Colour			= {0.42352, 0.0, 0.0392, 1}, -- 
		SRatio 			= 0.8,
		HAlign			= "left",
		VAlign			= "center",
		SizeW			= 1,
		SizeH			= 1,
	},
	
	bestTimeCaption = 
	{
		dataType		= "text",
		Caption 		= "LevStat_BestTime",
		Font			= "font05.fnt",
		TextArea		= {15, 47, 205, 62},
		Colour			= {0.07901, 0.02745, 0.39512, 1}, --
		SRatio 			= 0.8,
		HAlign			= "center",
		VAlign			= "center",
		SizeW			= 1,
		SizeH			= 1
	},
	
	bestTimeValue = 
	{
		name			= "bestTimeValue",
		dataType		= "text",
		Caption 		= "one_num",
		Font			= "font05.fnt",
		TextArea		= {44, 59+15, 175, 69+15},
		Colour			= {0.42352, 0.0, 0.0392, 1}, -- 
		SRatio 			= 0.8,
		HAlign			= "center",
		VAlign			= "center",
		SizeW			= 1,
		SizeH			= 1,
	},
	
	bestTimeUserName = 
	{
		name			= "bestTimeUserName",
		dataType		= "text",
		Caption 		= "",
		Font			= "font05.fnt",
		TextArea		= {0, 70+20, 220, 100+20},
		Colour			= {0.42352, 0.0, 0.0392, 1}, -- 
		SRatio 			= 0.8,
		HAlign			= "center",
		VAlign			= "center",
		SizeW			= 1,
		SizeH			= 1,
	}
}

StuffRects = 
{
	{0, 0, 0, 0},
	{0, 0, 0, 0},
	{0, 0, 0, 0}
}

BuyStuffMapHintTable1 = 
{
	delay = 0,
	--hint window settings
	windowStyle =
	{
		SrcRect          = {0, 313, 152, 465},
		Image            = "Icons.jpg",
		WinSize          = {495 - 127, 145 + 25},
		AngleScrSize     = {25, 25},
	},
	--    /
	stuffBase1= 
	{
		name 			= "_stuffBase1",
		dataType		= "image",
		Image			= "Icons.jpg",
		Pos				= {230, 30-10},
		SrcRect			= {846, 398, 953, 505},
	},
	-- /  
	stuff1= 
	{
		name 			= "stuff1",
		dataType		= "image",
		Image			= "MapShopIcons.jpg",
		Pos				= {230-2, 40-10}, 
		--SrcRect			= {0, 0, 0, 0},
	},
	-- 
	upgradeRect1 = 
	{
		name 			= "upgradeRect1",
		dataType		= "image",
		Image			= "MapShopIcons.jpg",
		Pos				= {338, 40},
		--SrcRect			= {0, 0, 0, 0},
	},
	--    
	stuffname1 = 
	{
		name 			= "stuffname1",
		dataType		= "text",
		Caption 		= "TomatoBuilding",
		Font			= "font05.fnt",
		TextArea		= {225-20, 125, 225+120+20, 155},
		Colour			= {0.07901, 0.02745, 0.39512, 1}, --
		SRatio 			= 0.8,
		HRatio 			= 0.8,
		HAlign			= "center",
		VAlign			= "center",
		SizeW			= 0.75,
		SizeH			= 0.75,
	},
	--  
	stuffMark1= 
	{
		name 			= "stuffMark1",
		dataType		= "image",
		Image			= "Icons.jpg",
		Pos				= {280, 80-10},
		--SrcRect			= {0, 0, 0, 0},
	},

	-- ""
	levelNumCaption = 
	{
		name			= "levelNumCaption",
		dataType		= "text",
		Caption 		= "Level",
		Font			= "font05.fnt",
		TextArea		= {20-2, 50, 145+12-2, 60},
		Colour			= {0.07901, 0.02745, 0.39512, 1}, --
		SRatio 			= 0.8,
		HAlign			= "right",
		VAlign			= "center",
		SizeW			= 1.0,
		SizeH			= 1.0,
	},
	--  - 
	levelNum = 
	{
		name			= "levelNum",
		dataType		= "text",
		Caption 		= "one_num",
		Font			= "font05.fnt",
		TextArea		= {145+10, 50, 220+2, 60},
		Colour			= {0.42352, 0.0, 0.0392, 1}, -- 
		SRatio 			= 0.8,
		HAlign			= "left",
		VAlign			= "center",
		SizeW			= 1.0,
		SizeH			= 1.0,
	},
	-- " :"
	bestTimeCaption = 
	{
		dataType		= "text",
		Caption 		= "LevStat_BestTime",
		Font			= "font05.fnt",
		TextArea		= {10, 70, 20+155, 80},
		Colour			= {0.07901, 0.02745, 0.39512, 1}, --
		SRatio 			= 0.8,
		HAlign			= "right",
		VAlign			= "center",
		SizeW			= 1,
		SizeH			= 1,
	},
	--  
	bestTimeValue = 
	{
		name			= "bestTimeValue",
		dataType		= "text",
		Caption 		= "one_num",
		Font			= "font05.fnt",
		TextArea		= {20+152, 70, 220, 80},
		Colour			= {0.42352, 0.0, 0.0392, 1}, -- 
		SRatio 			= 0.8,
		HAlign			= "left",
		VAlign			= "center",
		SizeW			= 1,
		SizeH			= 1,
	},
	-- 
	bestTimeUserName = 
	{
		name			= "bestTimeUserName",
		dataType		= "text",
		Caption 		= "",
		Font			= "font05.fnt",
		TextArea		= {20, 92, 220, 102},
		Colour			= {0.42352, 0.0, 0.0392, 1}, -- 
		SRatio 			= 0.8,
		HAlign			= "center",
		VAlign			= "center",
		SizeW			= 1.0,
		SizeH			= 1.0,
	}
}

local delta_two = 130

BuyStuffMapHintTable2 =
{
	--hint window settings
	delay = 0,
	windowStyle =
	{
		SrcRect          = {0, 313, 152, 465},
		Image            = "Icons.jpg",
		WinSize          = {495 - 127 + delta_two, 145 + 25},
		AngleScrSize     = {25, 25},
	},

	
	--    /
	stuffBase2= 
	{
		name 			= "_stuffBase2",
		dataType		= "image",
		Image			= "Icons.jpg",
		Pos				= {230+delta_two, 30-10},
		SrcRect			= {846, 398, 953, 505},
	},
	-- /  
	stuff2= 
	{
		name 			= "stuff2",
		dataType		= "image",
		Image			= "MapShopIcons.jpg",
		Pos				= {230-2+delta_two, 40-10}, 
		--SrcRect			= {0, 0, 0, 0},
	},
	-- 
	upgradeRect2 = 
	{
		name 			= "upgradeRect2",
		dataType		= "image",
		Image			= "MapShopIcons.jpg",
		Pos				= {338+delta_two, 40},
		--SrcRect			= {0, 0, 0, 0},
	},
	--    
	stuffname2 = 
	{
		name 			= "stuffname2",
		dataType		= "text",
		Caption 		= "JuiceBuilding",
		Font			= "font05.fnt",
		TextArea		= {225+delta_two-20, 125, 225+120+delta_two+20, 155},
		Colour			= {0.07901, 0.02745, 0.39512, 1}, --
		SRatio 			= 0.8,
		HRatio 			= 0.8,
		HAlign			= "center",
		VAlign			= "center",
		SizeW			= 0.75,
		SizeH			= 0.75,
	},
	--  
	stuffMark2= 
	{
		name 			= "stuffMark2",
		dataType		= "image",
		Image			= "Icons.jpg",
		Pos				= {280+delta_two, 80-10},
		--SrcRect			= {0, 0, 0, 0},
	},

}
--    1-
BuyStuffMapHintTable2.stuffBase1 = copy(emptyObj, BuyStuffMapHintTable1.stuffBase1)
BuyStuffMapHintTable2.stuff1 = copy(emptyObj, BuyStuffMapHintTable1.stuff1)
BuyStuffMapHintTable2.upgradeRect1 = copy(emptyObj, BuyStuffMapHintTable1.upgradeRect1)
BuyStuffMapHintTable2.stuffname1 = copy(emptyObj, BuyStuffMapHintTable1.stuffname1)
BuyStuffMapHintTable2.stuffMark1 = copy(emptyObj, BuyStuffMapHintTable1.stuffMark1)
BuyStuffMapHintTable2.levelNumCaption = copy(emptyObj, BuyStuffMapHintTable1.levelNumCaption)
BuyStuffMapHintTable2.levelNum = copy(emptyObj, BuyStuffMapHintTable1.levelNum)
BuyStuffMapHintTable2.bestTimeCaption = copy(emptyObj, BuyStuffMapHintTable1.bestTimeCaption)
BuyStuffMapHintTable2.bestTimeValue = copy(emptyObj, BuyStuffMapHintTable1.bestTimeValue)
BuyStuffMapHintTable2.bestTimeUserName = copy(emptyObj, BuyStuffMapHintTable1.bestTimeUserName)


SimpleMapHint = 
{
	delay = 0,
	--hint window settings
	windowStyle =
	{
		SrcRect          = {0, 313, 152, 465},
		Image            = "Icons.jpg",
		WinSize          = {240, 90},
		AngleScrSize     = {25, 25},
	},

	text = 
	{
		dataType		= "text",
		Caption 		= "Enter your caption here",
		Font			= "font05.fnt",
		TextArea		= {114, 5, 310, 50},
		Colour			= {0.27843, 0.0941, 0, 1},
		SRatio 			= 0.8,
		HRatio 			= 0.75,
		HAlign			= "center",
		VAlign			= "center",
		SizeW			= 1,--0.9,
		SizeH			= 1,--0.9
	}
}

--startGame
StartGameHint = {}
StartGameHint.data = copy(emptyObj, SimpleMapHint)
StartGameHint.data.text.Caption = "ClickToContinueNewGame"
StartGameHint.data.text.TextArea = {20, 20, StartGameHint.data.windowStyle.WinSize[1]-15, StartGameHint.data.windowStyle.WinSize[2]-15}

NormalMapHint = {}
NormalMapHint.data = copy(emptyObj, MapHint)

-- -    
BuyStuffMapHint1 = {}
BuyStuffMapHint1.data = copy(emptyObj, BuyStuffMapHintTable1)
--BuyStuffMapHint1.data.windowStyle.WinSize[1] = 495 - 127
--BuyStuffMapHint1.data.windowStyle.WinSize[2] = 145 + 25

BuyStuffMapHint2 = {}
BuyStuffMapHint2.data = copy(emptyObj, BuyStuffMapHintTable2)
--BuyStuffMapHint1.data.windowStyle.WinSize[1] = 495 - 127 + delta_two
--BuyStuffMapHint1.data.windowStyle.WinSize[2] = 145 + 25

BuyStuffMapHintCross1 = {}
BuyStuffMapHintCross1.data = copy(emptyObj, BuyStuffMapHintTable1)
BuyStuffMapHintCross1.data.windowStyle.WinSize[1] = 495 - 127
BuyStuffMapHintCross1.data.windowStyle.WinSize[2] = 145 + 25

BuyStuffMapHintCross2 = {}
BuyStuffMapHintCross2.data = copy(emptyObj, BuyStuffMapHintTable2)
BuyStuffMapHintCross2.data.windowStyle.WinSize[1] = 495 - 127 + delta_two
BuyStuffMapHintCross2.data.windowStyle.WinSize[2] = 145 + 25


FirstHint = 
{
	--hint window settings
	isClickable = 1,
	delay=0,
	windowStyle =
	{
		SrcRect			= {0, 313, 152, 465},
		Image			= "Icons.jpg",
		WinSize			= {220, 120},
		AngleScrSize	= {25, 25},
	},
	--character's name
	text = 
	{
		name			= "text",
		dataType		= "text",
		Caption 		= "super hint text",
		Font			= "font05.fnt",
		TextArea		= {0, 22, 220, 32},
		Colour			= {0, 0.0941, 0.27843, 1},
		SRatio 			= 0.8,
		HRatio 			= 0.82,
--		HAlign			= "center",
		VAlign			= "top",
		SizeW			= 1,
		SizeH			= 1,
	},
	
	hyperLink = 
	{
		name			= "hyperLink",
		dataType		= "text",
		Caption 		= "ClickToContinue",
		Font			= "font05.fnt",
		TextArea		= {30, 22, 220, 32},
		Colour			= {0.455, 0.587, 0.587, 1},
		SRatio 			= 0.75,
		HRatio 			= 0.8,
		--HAlign			= "center",
		VAlign			= "center",
		SizeW			= 0.8,
		SizeH			= 0.8,
	},
}

stepx=30
stepy=25

_shintEdu_1 = {}
_shintEdu_1.data = copy(emptyObj, FirstHint)
_shintEdu_1.data.windowStyle.WinSize = {400, 160}
_shintEdu_1.data.text.TextArea = {stepx-10, stepy, _shintEdu_1.data.windowStyle.WinSize[1], _shintEdu_1.data.windowStyle.WinSize[2]-15}
_shintEdu_1.data.text.Caption = 'Hint_gotothestore'
_shintEdu_1.data.isClickable = 0
_shintEdu_1.data.cornerType = 1



HintList = 
{
	"StartGameHint",
	"NormalMapHint",
	"BuyStuffMapHint1",
	"BuyStuffMapHintCross1",
	"BuyStuffMapHintCross2",
	"BuyStuffMapHint2",
	"_shintEdu_1"
}

for k, v in pairs(HintList)
do
	item = _G[v]
	if item.data.isClickable ~= nil and item.data.isClickable == 1
	then
		item.data.hyperLink.TextArea = {30, item.data.windowStyle.WinSize[2] - 60, item.data.windowStyle.WinSize[1]-7, item.data.windowStyle.WinSize[2]}
	else
		item.data.hyperLink = nil

	end
end
