// PDFImport.cpp : Defines the entry point for the DLL application.
//


#include "stdafx.h"
#include "PDFImport.h"

#include "SDK_Types.h"
#include "SDK_Framework.h"
#include "PDF_DrawingImporter.h"

static PDF_DrawingImporter importer;
static SDK_Framework *sg_Framework = 0;

BOOL APIENTRY DllMain( HANDLE hModule, 
                       DWORD  ul_reason_for_call, 
                       LPVOID lpReserved
					 )
{
    switch (ul_reason_for_call)
	{
		case DLL_THREAD_ATTACH:
			break;

		case DLL_THREAD_DETACH:
			break;

		case DLL_PROCESS_ATTACH:
			break;

		case DLL_PROCESS_DETACH:
			if (sg_Framework)
				sg_Framework->UnregisterDrawingImporter(&importer);
			sg_Framework = 0;
			break;
    }
    return TRUE;
}


// This is an example of an exported function.
PDFIMPORT_API int SDK_IMPORTER_INIT_SYMBOL_NAME(SDK_Framework &framework)
{
	framework.RegisterDrawingImporter(&importer);
	sg_Framework = &framework;

	return SDK_IMPORT_NO_ERROR;
}


