//========== Copyright ToonBoom Technologies Inc. 2002 ============
//
// SOURCE FILE : IM_Illustrator9.cpp
// MODULE NAME : 
// DESCRIPTION : 
//
//=================================================================
// Author : Jacques Tremblay
// Modif  : 
//
// Creation Date		 : 2002-2-21
//========================VSS Auto=================================
// $Revision: 1.9 $
// $Date: 2002/04/19 14:27:45 $
// $Author: jtremblay $
//=================================================================
// REVISION: 
// 
//=========== Copyright ToonBoom Technologies Inc. 2002  ==========

//=================================================================
//						INCLUDE
//=================================================================
//=================================================================
//						DEFINE
//=================================================================

#ifdef __GNUC__
#pragma implementation
#endif

#include "StdAfx.h"

#include "PDF_DrawingImporter.h"

#include "SDK_DrawingFactory.h"
#include "SDK_Framework.h"
#include "SDK_PaletteManager.h"
#include "SDK_ComplexTypes.h"
#include "SDK_MessageHandler.h"

#include "GlobalParams.h"
#include "GfxState.h"
#include "PDFDoc.h"
#include "Gfx.h"

#include <assert.h>

#define ASSERT assert

#define UT_COORDINATE_12_FIELD_SIZE (m_drawingFactory->GetModelWidth())

// Check this when we port to mac...
#ifdef MACOS
// needed for setting type/creator of MacOS files
#include "ICSupport.h"
#endif

/////////////////////////////////////////////////////////////////////
// DrawingImporter Protocol
/////////////////////////////////////////////////////////////////////

SDK_DrawingImporter::~SDK_DrawingImporter()
{

}

const char *PDF_DrawingImporter::GetFileDescription()
{
	static char buf[] = "PDF File";
	return buf;
}

int PDF_DrawingImporter::GetNumFileExtensions()
{
	return 2;
}
	
const char *PDF_DrawingImporter::GetExtension(int i)
{
	static char *extensions[2] = { "pdf", "ai" };

	if (i)
		return extensions[1];
	else
		return extensions[0];
}

PDF_DrawingImporter::PDF_DrawingImporter()
{
	m_paletteManager = 0;
	m_framework = 0;
	m_drawingFactory = 0;
	m_palette = 0;
	m_thicknessFactor = 1.0f;

	m_currentClipPath = 0;

	m_fillColor = 0;
	m_strokeColor = 0;

	m_cancelByUser = false;
	m_strokeWithClipPath = false;
}


//========================  METHOD DECLARATION  =======================
// METHOD NAME : ImportPdfFile
//---------------------------------------------------------------------
/// \param PL_FileSpec& 
/// \param colorPalette 
/// \param outputDrawings 
/// \return 
//---------------------------------------------------------------------
// DESCRIPTION :
/// 
//=====================================================================
int PDF_DrawingImporter::Import(const SDK_FileSpec &fileName, SDK_DrawingFactory &factory)
{
	int firstPage, lastPage;

	GlobalParams gParams(0);
	globalParams = &gParams;

	FILE *file = _wfopen(fileName.GetFileName(), L"rb");
	
	if (!file)
	{
		globalParams = 0;
		return 0;
	}

	PDFDoc *doc = 0;
 
	Object obj;
	obj.initNull();

	BaseStream *baseStr = new FileStream(file, 0, -1, &obj);

	// The document becomes the owner of the stream...
	doc = new PDFDoc( baseStr );

	if (!doc->isOk()) {
		goto err1;
	}

	// check for print permission
	if (!doc->okToPrint()) {
		goto err1;
	}

	firstPage = 1;
	lastPage = doc->getNumPages();

	m_drawingFactory = &factory;
	m_framework = &factory.GetFramework();
	m_paletteManager = &m_framework->GetPaletteManager();
	m_palette = m_paletteManager->AddPalette("PDF Importer");

	setupResources(doc);
	doc->displayPages(this, firstPage, lastPage, 72, 0, gFalse);

	m_drawingFactory = 0;

err1:
	delete doc;
	doc = 0;

	fclose(file);

	globalParams = 0;

	return lastPage-firstPage+1;
}

void PDF_DrawingImporter::setupResources(PDFDoc *doc)
{
	int first = 1;
	int last = doc->getNumPages();

	XRef *xref = doc->getXRef();
	Page *page;
	Dict *resDict;
	Catalog *catalog = doc->getCatalog();
 
	for (int pg = first; pg <= last; ++pg)
	{
		page = catalog->getPage(pg);
		if ((resDict = page->getResourceDict()))
		{
			m_resources = new GfxResources(xref, resDict, NULL);
			setupResources(resDict);
			delete m_resources;
			m_resources = 0;
		}
	}
}

void PDF_DrawingImporter::setupResources(Dict *resDict) {
	setupImages(resDict);
}

void PDF_DrawingImporter::setupImages(Dict *resDict) {
	Object xObjDict, xObj, xObjRef, subtypeObj;
	int i;

	resDict->lookup("XObject", &xObjDict);
	if (xObjDict.isDict())
	{
		for (i = 0; i < xObjDict.dictGetLength(); ++i)
		{
			xObjDict.dictGetValNF(i, &xObjRef);
			xObjDict.dictGetVal(i, &xObj);
			if (xObj.isStream()) 
			{
				xObj.streamGetDict()->lookup("Subtype", &subtypeObj);
				if (subtypeObj.isName("Image")) 
				{
					if (xObjRef.isRef()) {
						setupImage(xObjRef.getRef(), xObj.getStream());

						Dict *imageDict = xObj.getStream()->getDict();
						Object smaskRef;
						imageDict->lookupNF("SMask", &smaskRef);
						if (!smaskRef.isNull() && smaskRef.isRef())
						{
							Object smask;
							imageDict->lookup("SMask", &smask);
							if (!smask.isNull() && smask.isStream())
							{
								setupImage(smaskRef.getRef(), smask.getStream());
							}
							smask.free();
						}
						smaskRef.free();
					}
				} else {
				 //error(-1, "Image in resource dict is not an indirect reference");
				}
			}
			subtypeObj.free();
		}
		xObj.free();
		xObjRef.free();
	}
	xObjDict.free();
}

void PDF_DrawingImporter::setupImage(Ref id, Stream *str) {
	GfxImageColorMap *colorMap = 0;
	GfxColorSpace *colorSpace = 0;
	Object obj1, obj2;

	int bits, mask, height, width;

	Dict *dict = str->getDict();

	// Fetch the size....
	dict->lookup("Width", &obj1);
	if (obj1.isNull()) {
		obj1.free();
		dict->lookup("W", &obj1);
	}
	if (!obj1.isInt())
		goto err2;

	width = obj1.getInt();
	obj1.free();

	dict->lookup("Height", &obj1);
	if (obj1.isNull()) {
		obj1.free();
		dict->lookup("H", &obj1);
	}
	if (!obj1.isInt())
		goto err2;
	
	height = obj1.getInt();
	obj1.free();

	// We do not support masks...
	dict->lookup("ImageMask", &obj1);
	if (obj1.isNull()) {
		obj1.free();
		dict->lookup("IM", &obj1);
	}
	
	mask = gFalse;
	if (obj1.isBool())
		mask = obj1.getBool();
	else if (!obj1.isNull())
		goto err2;
	obj1.free();

	// We do not support masks yet...
	if (mask) 
		goto err2;

	// bit depth
	dict->lookup("BitsPerComponent", &obj1);
	if (obj1.isNull()) {
		obj1.free();
		dict->lookup("BPC", &obj1);
	}
	if (!obj1.isInt())
		goto err2;
	bits = obj1.getInt();
	obj1.free();

	// get color space and color map
	dict->lookup("ColorSpace", &obj1);
	if (obj1.isNull()) {
		obj1.free();
		dict->lookup("CS", &obj1);
	}
	if (obj1.isName()) {		
		m_resources->lookupColorSpace(obj1.getName(), &obj2);
		if (!obj2.isNull()) {
			obj1.free();
			obj1 = obj2;
		} else {
			obj2.free();
		}
	}

   colorSpace = GfxColorSpace::parse(&obj1);
   obj1.free();
   if (!colorSpace) {
		goto err1;
   }
   
	dict->lookup("Decode", &obj1);
   if (obj1.isNull()) {
		obj1.free();
      dict->lookup("D", &obj1);
   }
   
	colorMap = new GfxImageColorMap(bits, &obj1, colorSpace);
   obj1.free();

   if (!colorMap->isOk()) {
		delete colorMap;
      goto err1;
   }

	      // Do not support masks yet...
			// get the mask
			//   haveMask = gFalse;
			//  dict->lookup("Mask", &maskObj);
			//if (maskObj.isArray()) {
			//for (i = 0; i < maskObj.arrayGetLength(); ++i) {
			//maskObj.arrayGet(i, &obj1);
			//maskColors[i] = obj1.getInt();
			//obj1.free();
			//}
			//haveMask = gTrue;
			//}
			//maskObj.free();

	// Fetch the image and store it in the image map
	{
		SDK_Image *image = new SDK_Image(width, height);

		// Setup an image stream
		ImageStream *imageStr = new ImageStream(str, width, colorMap->getNumPixelComps(), colorMap->getBits());
		imageStr->reset();

		Guchar pixBuf[gfxColorMaxComps];
		GfxRGB gRGB;
		SDK_RGBA pix;
		for(int y=0 ; y<height ; ++y)
		{
			for(int x=0 ; x<width ; ++x)
			{
				imageStr->getPixel(pixBuf);
				colorMap->getRGB(pixBuf, &gRGB);

				pix.SetA(0xff);
				pix.SetR(gRGB.r * 255);
				pix.SetG(gRGB.g * 255);
				pix.SetB(gRGB.b * 255);
				image->GetPixelRefAt(x, y) = pix;
			}
		}
		delete imageStr;
		delete colorMap;
		m_documentImages[std::pair<int, int>(id.num, id.gen)] = image;
		return;
	}

 err2:
  obj1.free();
 err1:
  return;
}

//------------------------------------------------------------------------
// PDF_DrawingImporter
//------------------------------------------------------------------------

//========================  METHOD DECLARATION  =======================
// METHOD NAME : ~PDF_DrawingImporter (destructor)
//---------------------------------------------------------------------
//---------------------------------------------------------------------
// DESCRIPTION :
/// 
//=====================================================================
PDF_DrawingImporter::~PDF_DrawingImporter() {
	delete m_currentClipPath;

	ImageMap::iterator iter;
	for(iter = m_documentImages.begin() ; iter != m_documentImages.end() ; ++iter)
	{
		delete iter->second;
		iter->second = 0;
	}
	m_documentImages.clear();
}


//========================  METHOD DECLARATION  =======================
// METHOD NAME : startPage
//---------------------------------------------------------------------
/// \param pageNum 
/// \param state 
/// \return 
//---------------------------------------------------------------------
// DESCRIPTION :
/// 
//=====================================================================
void PDF_DrawingImporter::startPage(int pageNum, GfxState *state) {

	DrawingFactory().BeginDrawing();

	SDK_Vector xAxis(state->getX2() - state->getX1(), 0);
	SDK_Vector yAxis(0, state->getY2() - state->getY1());
	SDK_Vector translation = xAxis * 0.5 + yAxis * 0.5; 


	double halfWidth = xAxis.GetX()/2.0;
	if (halfWidth == 0.0)
		halfWidth = 1.0;

	m_pageTo12Field.Identity();
	m_pageTo12Field.Translate(-translation);
	m_pageTo12Field.Scale(SDK_Vector(UT_COORDINATE_12_FIELD_SIZE/halfWidth, UT_COORDINATE_12_FIELD_SIZE/halfWidth));

	m_thicknessFactor = sqrt(xAxis.GetLength()*yAxis.GetLength());

	if (m_thicknessFactor != 0.0)
		m_thicknessFactor = UT_COORDINATE_12_FIELD_SIZE/m_thicknessFactor;
	else
		m_thicknessFactor = 1.0;

	m_currentNestingLevel = 0;
}

//========================  METHOD DECLARATION  =======================
// METHOD NAME : endPage
//---------------------------------------------------------------------
/// \return 
//---------------------------------------------------------------------
// DESCRIPTION :
/// 
//=====================================================================
void PDF_DrawingImporter::endPage() {
	while(!m_clipNestingLevels.empty())
	{
		ASSERT(m_clipNestingLevels.back() == 0);
		m_drawingFactory->EndClip();
		m_clipNestingLevels.pop_back();
	}

	m_drawingFactory->EndDrawing();
}

//========================  METHOD DECLARATION  =======================
// METHOD NAME : saveState
//---------------------------------------------------------------------
/// \param state 
/// \return 
//---------------------------------------------------------------------
// DESCRIPTION :
/// 
//=====================================================================
void PDF_DrawingImporter::saveState(GfxState *state) {
	++m_currentNestingLevel;
	m_savedFillColor.push_back(m_fillColor);
	m_savedStrokeColor.push_back(m_strokeColor);
}

//========================  METHOD DECLARATION  =======================
// METHOD NAME : restoreState
//---------------------------------------------------------------------
/// \param state 
/// \return 
//---------------------------------------------------------------------
// DESCRIPTION :
/// 
//=====================================================================
void PDF_DrawingImporter::restoreState(GfxState *state) {
	--m_currentNestingLevel;
	
	ASSERT(m_savedFillColor.size());
	ASSERT(m_savedStrokeColor.size());

	m_fillColor = m_savedFillColor.back();
	m_strokeColor = m_savedStrokeColor.back();

	m_savedFillColor.pop_back();
	m_savedStrokeColor.pop_back();
	
	while (!m_clipNestingLevels.empty() && m_currentNestingLevel < m_clipNestingLevels.back())
	{
		m_clipNestingLevels.pop_back();
		m_drawingFactory->EndClip();
	}

	if (m_drawingFactory->CancelImport())
		m_cancelByUser = true;
}

//========================  METHOD DECLARATION  =======================
// METHOD NAME : updateCTM
//---------------------------------------------------------------------
/// \param state 
/// \param m11 
/// \param m12 
/// \param m21 
/// \param m22 
/// \param m31 
/// \param m32 
/// \return 
//---------------------------------------------------------------------
// DESCRIPTION :
/// Hook to handle a new reference frame...
//=====================================================================
void PDF_DrawingImporter::updateCTM(
				GfxState *state, double m11, double m12,
			   double m21, double m22, double m31, double m32) {
}

//========================  METHOD DECLARATION  =======================
// METHOD NAME : updateFillColor
//---------------------------------------------------------------------
/// \param state 
/// \return 
//---------------------------------------------------------------------
// DESCRIPTION :
/// 
//=====================================================================
void PDF_DrawingImporter::updateFillColor(GfxState *state) {
	GfxRGB rgb;
	state->getFillRGB(&rgb);
	
	SDK_RGBA rgba(rgb.r*255, rgb.g*255, rgb.b*255, state->getFillOpacity()*255);

	m_fillColor = m_paletteManager->FindOrAddColor(m_palette, rgba);

}

//========================  METHOD DECLARATION  =======================
// METHOD NAME : updateStrokeColor
//---------------------------------------------------------------------
/// \param state 
/// \return 
//---------------------------------------------------------------------
// DESCRIPTION :
/// 
//=====================================================================
void PDF_DrawingImporter::updateStrokeColor(GfxState *state) {
	GfxRGB rgb;
	state->getStrokeRGB(&rgb);
	
	SDK_RGBA rgba(rgb.r*255, rgb.g*255, rgb.b*255, state->getStrokeOpacity()*255);

	m_strokeColor = m_paletteManager->FindOrAddColor(m_palette, rgba);
}

void PDF_DrawingImporter::updateFillOpacity(GfxState *state)
{
	updateFillColor(state);
}

void PDF_DrawingImporter::updateStrokeOpacity(GfxState *state)
{
	updateStrokeColor(state);
}


//========================  METHOD DECLARATION  =======================
// METHOD NAME : handleFillShading
//---------------------------------------------------------------------
/// \param state 
/// \param shading 
/// \return True if it could handle the shading.
//---------------------------------------------------------------------
// DESCRIPTION :
/// Builds a gradient color.
//=====================================================================
bool PDF_DrawingImporter::handleFillShading(GfxState *state, GfxShading *shading, bool doStroke)
{
	if (m_currentClipPath)
	{
		GfxAxialShading *axialShading = dynamic_cast<GfxAxialShading*>(shading);
		if (axialShading)
		{
			double *ts = 0;
			int n = axialShading->GetFunctionCaracteristics(&ts);
	
			SDK_Gradient gradient;

			if (n > 8)
			{
				n = 8;
				m_drawingFactory->GetFramework().GetMessageHandler().HandleUnsupportedFeatureWarning(SDK_MessageHandler::ShadingType);
			}

			for(int i=0 ; i<n ; ++i)
			{
				GfxColor gfxCol;
				axialShading->getColor(ts[i], &gfxCol);

				GfxRGB gRGB;
				axialShading->getColorSpace()->getRGB(&gfxCol, &gRGB);

				SDK_RGBA rgba(gRGB.r*255, gRGB.g*255, gRGB.b*255, state->getFillOpacity()*255);

				gradient.GetMarkersBegin()[i] = rgba;
				gradient.GetPositionBegin()[i] = ts[i];
			}
		
			gradient.SetNumMarkers(n);
			gradient.SetType(SDK_Gradient::LINEAR);

			delete [] ts;

			SDK_GradientID *gradientID = m_paletteManager->FindOrAddGradient(m_palette, gradient);
			
			double x0, y0, x1, y1;
			axialShading->getCoords(&x0, &y0, &x1, &y1);

			SDK_Matrix2x3 grMat(SDK_Vector(x1-x0, y1-y0), SDK_Vector(y1-y0, x0-x1), SDK_Point(x0, y0));
			SDK_Matrix2x3 mat(state->getCTM());
			SDK_Matrix2x3 applicationMatrix = grMat * mat * m_pageTo12Field;

			SDK_ColorID *oldFillColor = m_fillColor;
			SDK_ColorID *oldStrokeColor = m_strokeColor;

			m_drawingFactory->SetCurrentColor(SDK_DrawingFactory::STROKE_RIGHT, gradientID, applicationMatrix);
			m_drawingFactory->SetCurrentColor(SDK_DrawingFactory::STROKE_LEFT, 0);
			m_drawingFactory->SetCurrentStrokeColor(0);
			m_drawingFactory->SetCurrentStrokeStyle(SDK_DrawingFactory::NO_LINESTYLE);

			state = state->save();
			double ctm[6];
			for(int c=0; c<6 ; ++c)
				ctm[c] = state->getCTM()[c];
			
			state->setCTM(m_clipCTM[0], m_clipCTM[1], m_clipCTM[2], m_clipCTM[3], m_clipCTM[4], m_clipCTM[5]);

			doPath(state, MODE_FILL, true);

			// Strokes on the boundary of the clip mask gets clipped...
			if (doStroke && m_strokeColor)
			{
				m_drawingFactory->EndClip();
				m_strokeWithClipPath = true;
				stroke(state);
				m_strokeWithClipPath = false;
				m_drawingFactory->BeginClip();
				doPath(state, MODE_CLIP, true);
			}

			state = state->restore();

			m_drawingFactory->SetCurrentColor(SDK_DrawingFactory::STROKE_RIGHT, oldFillColor);
			m_drawingFactory->SetCurrentColor(SDK_DrawingFactory::STROKE_LEFT, 0);
			m_drawingFactory->SetCurrentStrokeColor(0);
			m_drawingFactory->SetCurrentStrokeStyle(SDK_DrawingFactory::NO_LINESTYLE);

			return true;
		}
		GfxRadialShading *radialShading = dynamic_cast<GfxRadialShading*>(shading);
		if (radialShading)
		{
			double *ts = 0;
			int n = radialShading->GetFunctionCaracteristics(&ts);

			if (n>8) 
			{
				n = 8;
				m_drawingFactory->GetFramework().GetMessageHandler().HandleUnsupportedFeatureWarning(SDK_MessageHandler::ShadingType);
			}

			SDK_Gradient gradient;

			for(int i=0 ; i< n ; ++i)
			{
				GfxColor gfxCol;
				radialShading->getColor(ts[i], &gfxCol);

				GfxRGB gRGB;
				radialShading->getColorSpace()->getRGB(&gfxCol, &gRGB);

				SDK_RGBA rgba(gRGB.r*255, gRGB.g*255, gRGB.b*255, state->getFillOpacity()*255);
				gradient.GetMarkersBegin()[i] = rgba;
				gradient.GetPositionBegin()[i] = ts[i];
			}
			gradient.SetNumMarkers(n);
			gradient.SetType(SDK_Gradient::RADIAL);		
			
			delete [] ts;

			SDK_GradientID *gradientID = m_paletteManager->FindOrAddGradient(m_palette, gradient);

			double x0, y0, x1, y1, r0, r1;
			radialShading->getCoords(&x0, &y0, &r0, &x1, &y1, &r1);

			SDK_Matrix2x3 grMat(SDK_Vector(r1, 0), SDK_Vector(0, r1), SDK_Point(x1, y1));
			SDK_Matrix2x3 mat(state->getCTM());
			SDK_Matrix2x3 applicationMatrix = grMat * mat * m_pageTo12Field;

			SDK_ColorID *oldFillColor = m_fillColor;
			SDK_ColorID *oldStrokeColor = m_strokeColor;

			m_drawingFactory->SetCurrentColor(SDK_DrawingFactory::STROKE_RIGHT, gradientID, applicationMatrix);
			m_drawingFactory->SetCurrentColor(SDK_DrawingFactory::STROKE_LEFT, 0);
			m_drawingFactory->SetCurrentStrokeColor(0);
			m_drawingFactory->SetCurrentStrokeStyle(SDK_DrawingFactory::NO_LINESTYLE);


			state = state->save();
			double ctm[6];
			for(int c=0; c<6 ; ++c)
				ctm[c] = state->getCTM()[c];

			state->setCTM(m_clipCTM[0], m_clipCTM[1], m_clipCTM[2], m_clipCTM[3], m_clipCTM[4], m_clipCTM[5]);
			
			doPath(state, MODE_FILL, true);
			
			// Strokes on the boundary of the clip mask gets clipped...
			if (doStroke && m_strokeColor)
			{
				m_drawingFactory->EndClip();
				m_strokeWithClipPath = true;
				stroke(state);
				m_strokeWithClipPath = false;
				m_drawingFactory->BeginClip();
				doPath(state, MODE_CLIP, true);
			}

			state = state->restore();

			m_drawingFactory->SetCurrentColor(SDK_DrawingFactory::STROKE_RIGHT, oldFillColor);
			m_drawingFactory->SetCurrentColor(SDK_DrawingFactory::STROKE_LEFT, 0);
			m_drawingFactory->SetCurrentStrokeColor(0);
			m_drawingFactory->SetCurrentStrokeStyle(SDK_DrawingFactory::NO_LINESTYLE);

			return true;			
		}
		// Should never get here...
		return false;
	}
	// This will eat up the unsupported shading type...
	m_drawingFactory->GetFramework().GetMessageHandler().HandleUnsupportedFeatureWarning(SDK_MessageHandler::ShadingType);	
	return true;
}

//========================  METHOD DECLARATION  =======================
// METHOD NAME : stroke
//---------------------------------------------------------------------
/// \param state 
/// \return 
//---------------------------------------------------------------------
// DESCRIPTION :
/// Strokes the current path.
//=====================================================================
void PDF_DrawingImporter::stroke(GfxState *state) {
	m_drawingFactory->SetCurrentColor(SDK_DrawingFactory::STROKE_RIGHT, 0);
	m_drawingFactory->SetCurrentColor(SDK_DrawingFactory::STROKE_LEFT, 0);
	m_drawingFactory->SetCurrentStrokeColor(m_strokeColor);
	m_drawingFactory->SetCurrentStrokeStyle(SDK_DrawingFactory::THICK_LINESTYLE);
	m_drawingFactory->SetCurrentStrokeWidth(state->getTransformedLineWidth()*m_thicknessFactor);
	
	doPath(state, MODE_STROKE, m_strokeWithClipPath);
}

//========================  METHOD DECLARATION  =======================
// METHOD NAME : fill
//---------------------------------------------------------------------
/// \param state 
/// \return 
//---------------------------------------------------------------------
// DESCRIPTION :
/// Fills the current path.
//=====================================================================
void PDF_DrawingImporter::fill(GfxState *state) {
	m_drawingFactory->SetCurrentColor(SDK_DrawingFactory::STROKE_RIGHT, m_fillColor);
	m_drawingFactory->SetCurrentColor(SDK_DrawingFactory::STROKE_LEFT, 0);
	m_drawingFactory->SetCurrentStrokeColor(0);
	m_drawingFactory->SetCurrentStrokeStyle(SDK_DrawingFactory::NO_LINESTYLE);

	doPath(state, MODE_FILL);
}

//========================  METHOD DECLARATION  =======================
// METHOD NAME : eoFill
//---------------------------------------------------------------------
/// \param state 
/// \return 
//---------------------------------------------------------------------
// DESCRIPTION :
/// XOR filling... Not supported yet....
//=====================================================================
void PDF_DrawingImporter::eoFill(GfxState *state) {
	m_drawingFactory->GetFramework().GetMessageHandler().HandleUnsupportedFeatureWarning(SDK_MessageHandler::XorFill);	
}

//========================  METHOD DECLARATION  =======================
// METHOD NAME : clip
//---------------------------------------------------------------------
/// \param state 
/// \return 
//---------------------------------------------------------------------
// DESCRIPTION :
/// Builds a clipping layer and push it on the stack of clips.
//=====================================================================
void PDF_DrawingImporter::clip(GfxState *state) {

	delete m_currentClipPath;
	m_currentClipPath = state->getPath()->copy();
	double *ctm= state->getCTM();
	for(int i=0 ; i<6 ; i++)
		m_clipCTM[i] = ctm[i];

	// Skip the page clipping...
	if (!m_currentNestingLevel)
		return;

	m_drawingFactory->BeginClip();

	m_clipNestingLevels.push_back(m_currentNestingLevel);

	doPath(state, MODE_CLIP, false);

}

//========================  METHOD DECLARATION  =======================
// METHOD NAME : eoClip
//---------------------------------------------------------------------
/// \param state 
/// \return 
//---------------------------------------------------------------------
// DESCRIPTION :
/// XOR clipping.. not supported yet...
//=====================================================================
void PDF_DrawingImporter::eoClip(GfxState *state) {
	m_drawingFactory->GetFramework().GetMessageHandler().HandleUnsupportedFeatureWarning(SDK_MessageHandler::XorClip);
}

//========================  METHOD DECLARATION  =======================
// METHOD NAME : doPath
//---------------------------------------------------------------------
/// \param state 
/// \param mode 
/// \param useClipPath 
/// \return 
//---------------------------------------------------------------------
// DESCRIPTION :
/// 
//=====================================================================
void PDF_DrawingImporter::doPath(GfxState *state, int mode, bool useClipPath) {
	GfxPath *path = state->getPath();

	if (useClipPath)
		path = m_currentClipPath;

	if (!path)
		return;

	SDK_BezierPath bezierPath;

	m_drawingFactory->BeginLayer();
 	
	int n = path->getNumSubpaths();
	for(int i=0 ; i<n ; ++i) 
	{
		bezierPath.Clear();

		GfxSubpath *subpath;
		subpath = path->getSubpath(i);
		ASSERT(subpath);

		double x,y;

		state->transform(subpath->getX(0), subpath->getY(0), &x, &y);
		SDK_Point pt(x,y);
		bezierPath.Append(pt*m_pageTo12Field);

		int m = subpath->getNumPoints();
		int j = 1;
		while (j < m) {
			if (subpath->getCurve(j)) {
				state->transform(subpath->getX(j), subpath->getY(j), &x, &y);
				bezierPath.Append(SDK_Point(x, y)*m_pageTo12Field, false);
				state->transform(subpath->getX(j+1), subpath->getY(j+1), &x, &y);
				bezierPath.Append(SDK_Point(x, y)*m_pageTo12Field, false);
				state->transform(subpath->getX(j+2), subpath->getY(j+2), &x, &y);
				bezierPath.Append(SDK_Point(x, y)*m_pageTo12Field);
				j += 3;
			} 
			else {
				state->transform(subpath->getX(j), subpath->getY(j), &x, &y);
				bezierPath.Append(SDK_Point(x, y)*m_pageTo12Field);
				++j;
			}
		}
		if (subpath->isClosed() || mode == MODE_FILL || mode == MODE_CLIP) {
			SDK_Point fromPoint = bezierPath.GetFromPoint();
			if (bezierPath.GetToPoint() != fromPoint)
				bezierPath.Append(fromPoint);
		}
	
		// If we are in FILL or CLIP mode, make sure the bezier path is
		// clockwise for the main contour and ccw for the subcontours.
		if (mode != MODE_STROKE)
		{
			ASSERT(bezierPath.GetToPoint() == bezierPath.GetFromPoint());
			double area = bezierPath.GetPolygonArea();

		//	ASSERT(area != 0.0);

			if (i==0) {
				if (area > 0)
					bezierPath.Reverse();
			} else {
				if (area < 0)
					bezierPath.Reverse();
			}
		}
		
		m_drawingFactory->AddStroke(bezierPath.GetNumBeziers()+1, bezierPath.GetIndicesBegin(), bezierPath.GetPointsBegin());
	}

	m_drawingFactory->EndLayer();

	return;
}

//========================  METHOD DECLARATION  =======================
// METHOD NAME : drawString
//---------------------------------------------------------------------
/// \param state 
/// \param s 
/// \return 
//---------------------------------------------------------------------
// DESCRIPTION :
/// 
//=====================================================================
void PDF_DrawingImporter::drawString(GfxState *state, GString *s) {
	m_drawingFactory->GetFramework().GetMessageHandler().HandleUnsupportedFeatureWarning(SDK_MessageHandler::Text);
}

//========================  METHOD DECLARATION  =======================
// METHOD NAME : drawChar
//---------------------------------------------------------------------
/// \param state 
/// \param x 
/// \param y 
/// \param dx 
/// \param dy 
/// \param originX 
/// \param originY 
/// \param code 
/// \param u 
/// \param uLen 
/// \return 
//---------------------------------------------------------------------
// DESCRIPTION :
/// 
//=====================================================================
void PDF_DrawingImporter::drawChar(GfxState *state, double x, double y,
			double dx, double dy,
			double originX, double originY,
			CharCode code, Unicode *u, int uLen)
{
	m_drawingFactory->GetFramework().GetMessageHandler().HandleUnsupportedFeatureWarning(SDK_MessageHandler::Text);
}

//========================  METHOD DECLARATION  =======================
// METHOD NAME : drawImageMask
//---------------------------------------------------------------------
/// \param state 
/// \param ref 
/// \param str 
/// \param width 
/// \param height 
/// \param invert 
/// \param inlineImg 
/// \return 
//---------------------------------------------------------------------
// DESCRIPTION :
/// 
//=====================================================================
void PDF_DrawingImporter::drawImageMask(GfxState *state, Object *ref, Stream *str,
				int width, int height, GBool invert,
				GBool inlineImg) {
	m_drawingFactory->GetFramework().GetMessageHandler().HandleUnsupportedFeatureWarning(SDK_MessageHandler::ImageMask);
}

//========================  METHOD DECLARATION  =======================
// METHOD NAME : drawImage
//---------------------------------------------------------------------
/// \param state 
/// \param ref 
/// \param str 
/// \param width 
/// \param height 
/// \param colorMap 
/// \param maskColors 
/// \param inlineImg 
/// \return 
//---------------------------------------------------------------------
// DESCRIPTION :
/// 
//=====================================================================
void PDF_DrawingImporter::drawImage(GfxState *state, Object *ref, Stream *str,
			    int width, int height, GfxImageColorMap *colorMap,
			    int *maskColors, GBool inlineImg) {
	if (!width || !height)
		return;

	Ref reference = ref->getRef();

	GfxColorSpace *maskCS = 0;
	ImageStream *maskStream = 0;

	SDK_Image *image = 0;
	ImageMap::iterator imageIter = m_documentImages.find(std::pair<int, int>(reference.num, reference.gen));
	if (imageIter == m_documentImages.end())
		return;
	image = imageIter->second;

	SDK_Image *imageMask = 0;

	// Does the image have a SMask ?
	Dict *dict = str->getDict();
	Object obj1;
	dict->lookupNF("SMask", &obj1);
	if (!obj1.isNull() && obj1.isRef())
	{
		Ref r = obj1.getRef();
		imageMask = m_documentImages[std::pair<int, int>(r.num, r.gen)];
		
		if (imageMask && imageMask->Height() == image->Height() && imageMask->Width() == image->Width())
		{
			int n = image->Height() * image->Width();
			SDK_RGBA *rgb = &image->GetPixelRefAt(0, 0);
			SDK_RGBA *a = &imageMask->GetPixelRefAt(0, 0);
			for(int i=0 ; i<n ; ++i)
			{
				(*rgb).SetA((*a).GetR());
				++rgb;
				++a;
			}
		}
	} else
	{
		// Reset the alpha channel...
		int n = image->Height() * image->Width();
		SDK_RGBA *rgb = &image->GetPixelRefAt(0, 0);
		for(int i=0 ; i<n ; ++i)
		{
			(*rgb).SetA(0xff);
			rgb++;
		}
	}
	obj1.free();


	SDK_TextureID *texture;
	TextureMap::iterator texIter = m_createdTextures.find(std::pair<int, int>(reference.num, reference.gen));
	if (texIter == m_createdTextures.end())
	{
		texture = m_paletteManager->AddTexture(m_palette, width, height, &image->GetPixelRefAt(0,0), true);

		m_createdTextures[std::pair<int, int>(reference.num, reference.gen)] = texture;
	} else
	{
		texture = texIter->second;
	}
	
	obj1.free();

	ASSERT(texture);
	if (!texture) return;

	SDK_Matrix2x3 texMat(SDK_Vector(1, 0), SDK_Vector(0, 1), SDK_Point(0, 0));
	SDK_Matrix2x3 mat(state->getCTM());

	SDK_Matrix2x3 transform = texMat * mat * m_pageTo12Field;

	m_drawingFactory->BeginLayer();

	SDK_BezierPath bezierPath;

	bezierPath.Append(SDK_Point(0, 0)*transform);
	bezierPath.Append(SDK_Point(0, 1)*transform);
	bezierPath.Append(SDK_Point(1, 1)*transform);
	bezierPath.Append(SDK_Point(1, 0)*transform);
	bezierPath.Append(SDK_Point(0, 0)*transform);

	m_drawingFactory->SetCurrentColor(SDK_DrawingFactory::STROKE_RIGHT, texture, transform);
	m_drawingFactory->SetCurrentColor(SDK_DrawingFactory::STROKE_LEFT, 0);
	m_drawingFactory->SetCurrentStrokeColor(0);
	m_drawingFactory->SetCurrentStrokeStyle(SDK_DrawingFactory::NO_LINESTYLE);

	m_drawingFactory->AddStroke(bezierPath.GetNumBeziers()+1, bezierPath.GetIndicesBegin(), bezierPath.GetPointsBegin());

	m_drawingFactory->EndLayer();
}


//////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////
// Unsupported methods...
//////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////

void PDF_DrawingImporter::updateLineDash(GfxState *state) {
	double *dash;
	double start;
	int length;

	state->getLineDash(&dash, &length, &start);

	if (length != 0)
		m_drawingFactory->GetFramework().GetMessageHandler().HandleUnsupportedFeatureWarning(SDK_MessageHandler::DashedLine);
}

void PDF_DrawingImporter::updateFlatness(GfxState *state) {
}

void PDF_DrawingImporter::updateLineJoin(GfxState *state) {
	// Only support round join...
	if (state->getLineJoin() != 1) 
		m_drawingFactory->GetFramework().GetMessageHandler().HandleUnsupportedFeatureWarning(SDK_MessageHandler::LineJoin);
}

void PDF_DrawingImporter::updateLineCap(GfxState *state) {
	if (state->getLineCap() != 1)
		m_drawingFactory->GetFramework().GetMessageHandler().HandleUnsupportedFeatureWarning(SDK_MessageHandler::LineCap);
}

void PDF_DrawingImporter::updateMiterLimit(GfxState *state) {
}

void PDF_DrawingImporter::updateLineWidth(GfxState *state) {
}


void PDF_DrawingImporter::updateFont(GfxState *state) {
}

void PDF_DrawingImporter::updateTextMat(GfxState *state) {
}

void PDF_DrawingImporter::updateCharSpace(GfxState *state) {
}

void PDF_DrawingImporter::updateRender(GfxState *state) {
}

void PDF_DrawingImporter::updateRise(GfxState *state) {
}

void PDF_DrawingImporter::updateWordSpace(GfxState *state) {
}

void PDF_DrawingImporter::updateHorizScaling(GfxState *state) {

}

void PDF_DrawingImporter::updateTextPos(GfxState *state) {
}

void PDF_DrawingImporter::updateTextShift(GfxState *state, double shift) {
}

