#ifndef _PDF_DRAWING_IMPORTER_HEADER_
#define _PDF_DRAWING_IMPORTER_HEADER_

#include "OutputDev.h"
#include "XRef.h"

#include <SDK_Types.h>
#include <SDK_Importer.h>

class GfxPath;
class GfxFont;
class GfxColorSpace;
class GfxSeparationColorSpace;
class PSOutCustomColor;
class XRef;
class Dict;
class PDFDoc;
class GfxResources;

class SDK_TextureID;
class SDK_PaletteManager;
class SDK_PaletteManager;
class SDK_Palette;
class SDK_ColorID;
class SDK_GradientId;
class SDK_TextureID;
class SDK_Image;

class PDF_DrawingImporter : public SDK_DrawingImporter, public OutputDev {
public:
	PDF_DrawingImporter();

	virtual ~PDF_DrawingImporter();

	/// Interface SDK_DrawingImporter
	
	/// This method must be implemented by the client code to
	/// import a drawing who is contained in the file file.
	virtual int Import(const SDK_FileSpec &file, SDK_DrawingFactory &factory);

	/// This must return the description of the files it imports
	virtual const char *GetFileDescription();

	// This must return the number of know extensions. Usually 1.
	virtual int GetNumFileExtensions();
	
	// This must return the ith known extension.
	virtual const char *GetExtension(int i);


  // Check if file was successfully created.
  virtual GBool isOk() { return !m_cancelByUser; }

  //---- get info about output device

  // Does this device use upside-down coordinates?
  // (Upside-down means (0,0) is the top left corner of the page.)
  virtual GBool upsideDown() { return gFalse; }

  // Does this device use drawChar() or drawString()?
  virtual GBool useDrawChar() { return false; }

  //----- initialization and control

  // Start a page.
  virtual void startPage(int pageNum, GfxState *state);

  // End a page.
  virtual void endPage();

  //----- save/restore graphics state
  virtual void saveState(GfxState *state);
  virtual void restoreState(GfxState *state);

  //----- update graphics state
  virtual void updateCTM(GfxState *state, double m11, double m12,
			 double m21, double m22, double m31, double m32);
  virtual void updateLineDash(GfxState *state);
  virtual void updateFlatness(GfxState *state);
  virtual void updateLineJoin(GfxState *state);
  virtual void updateLineCap(GfxState *state);
  virtual void updateMiterLimit(GfxState *state);
  virtual void updateLineWidth(GfxState *state);
  virtual void updateFillColor(GfxState *state);
  virtual void updateStrokeColor(GfxState *state);

  virtual void updateFillOpacity(GfxState *state);
  virtual void updateStrokeOpacity(GfxState *state);

  //----- update text state
  virtual void updateFont(GfxState *state);
  virtual void updateTextMat(GfxState *state);
  virtual void updateCharSpace(GfxState *state);
  virtual void updateRender(GfxState *state);
  virtual void updateRise(GfxState *state);
  virtual void updateWordSpace(GfxState *state);
  virtual void updateHorizScaling(GfxState *state);
  virtual void updateTextPos(GfxState *state);
  virtual void updateTextShift(GfxState *state, double shift);

  //----- path painting
  virtual void stroke(GfxState *state);
  virtual void fill(GfxState *state);
  virtual void eoFill(GfxState *state);

  virtual bool handleFillShading(GfxState *state, GfxShading *shading, bool doStroke);

  //----- path clipping
  virtual void clip(GfxState *state);
  virtual void eoClip(GfxState *state);

  //----- text drawing
  virtual void drawString(GfxState *state, GString *s);

  void drawChar(GfxState *state, double x, double y,
			double dx, double dy,
			double originX, double originY,
			CharCode code, Unicode *u, int uLen);

  //----- image drawing
  virtual void drawImageMask(GfxState *state, Object *ref, Stream *str,
			     int width, int height, GBool invert,
			     GBool inlineImg);
  virtual void drawImage(GfxState *state, Object *ref, Stream *str,
			 int width, int height, GfxImageColorMap *colorMap,
			 int *maskColors, GBool inlineImg);

  SDK_DrawingFactory &DrawingFactory() { return *m_drawingFactory; }

private:

	bool                       m_cancelByUser;

	SDK_PaletteManager                  *m_paletteManager;
	SDK_Framework                       *m_framework;
	SDK_DrawingFactory                  *m_drawingFactory;
	SDK_Palette                         *m_palette;

	SDK_Matrix2x3								m_pageTo12Field;
	double                              m_thicknessFactor;

	GfxPath                            *m_currentClipPath;
	double                              m_clipCTM[6];

	bool                                m_strokeWithClipPath;

	SDK_ColorID                         *m_fillColor;
	SDK_ColorID                         *m_strokeColor;
	std::vector<SDK_ColorID*> m_savedFillColor;
	std::vector<SDK_ColorID*> m_savedStrokeColor;

	typedef std::map<std::pair<int, int>, SDK_TextureID *> TextureMap;
	TextureMap	m_createdTextures;

	std::vector<int>                    m_clipNestingLevels;
	int                                 m_currentNestingLevel;

	enum { MODE_STROKE, MODE_FILL, MODE_CLIP };

	void doPath(GfxState *state, int mode, bool useClipPath=false);

	// Things needed to read images at the begining of the document....
	typedef std::map<std::pair<int, int>, SDK_Image *> ImageMap;
	ImageMap m_documentImages;
	GfxResources *m_resources;
	void setupImages(Dict *resDict);
	void setupImage(Ref id, Stream *str);
	void setupResources(PDFDoc *doc);
	void setupResources(Dict *resDict);
};


#endif // _PDF_DRAWING_IMPORTER_HEADER_
