//========== Copyright ToonBoom Technologies Inc. 2002 ============
//
// SOURCE FILE : SDK_Array.h
// MODULE NAME : 
// DESCRIPTION : 
//
//=================================================================
// Author : Jacques Tremblay
// Modif  : 
//
// Creation Date		 : 2002-3-21
//========================VSS Auto=================================
// $Revision: 1.1 $
// $Date: 2002/03/26 17:35:24 $
// $Author: jtremblay $
//=================================================================
// REVISION: 
// 
//=========== Copyright ToonBoom Technologies Inc. 2002  ==========

//=================================================================
//						INCLUDE
//=================================================================
#ifndef _SDK_ARRAY_HEADER_
#define _SDK_ARRAY_HEADER_

/// Subset of the std::vector class. Implements the minimum needed for
/// this SDK.
template <class T>
class SDK_Array
{
	SDK_Array(const SDK_Array&); ///< Private and not implemented
public:
	typedef T *iterator;
	typedef const T *const_iterator;

	SDK_Array() { m_array = 0; m_size = m_maxSize = 0; }
	~SDK_Array() { Alloc(0); }

	void resize(int size) {
		if (size <= 0)
		{
			Alloc(0);
		}
		else if (size > m_maxSize)
		{
			T   *tmp = m_array;
			int previousSize = m_size;
			m_array= 0;
			Alloc(size);
			for(int i = 0 ; i<previousSize ; ++i)
			{
				m_array[i] = tmp[i];
			}
			delete [] tmp;
		}
		else if (size > m_size)
		{
			m_size = size;
		}
		else 
		{
			for(int i=size ; i<m_size ; ++i)
				m_array[i] = T();
			m_size = size;
		}
	}

	void reserve(int size)
	{
		if (size > m_maxSize)
		{
			int oldSize = m_size;
			resize(size);
			m_size = oldSize;
		}
	}

	void push_back(const T &elem) {
		if (m_size == m_maxSize)
		{
			int size = m_size;

			if (!m_maxSize)
				Alloc(1);
			else
				resize(m_maxSize*2);

			m_array[size] = elem;
			m_size = size+1;
		} else
		{
			m_array[m_size] = elem;
			m_size++;
		}
	}

	void pop_back() {
		resize(m_size-1);
	}

	T &front() { return m_array[0]; }
	T &back() { return m_array[m_size-1]; }

	iterator begin() { return m_array; }
	iterator end() { return m_array + m_size; }
	const_iterator begin() const { return m_array; }
	const_iterator end() const { return m_array + m_size; }

	T &operator[] (int i) { return m_array[i]; }
	const T &operator[] (int i) const { return m_array[i]; }

	int size() const { return m_size; }

	void clear() { resize(0); }

	bool empty() const { return m_size == 0; }
	
private:

	void Alloc(int n) { 
		delete [] m_array;
		m_size = m_maxSize = n;
		m_array = new T[n];
	}

	T   *m_array;
	int  m_size;
	int  m_maxSize;
};

#endif // _SDK_ARRAY_HEADER_
