//========== Copyright ToonBoom Technologies Inc. 2002 ============
//
// SOURCE FILE : SDK_ComplexTypes.h
// MODULE NAME : 
// DESCRIPTION : 
//
//=================================================================
// Author : Jacques Tremblay
// Modif  : 
//
// Creation Date		 : 2002-3-21
//========================VSS Auto=================================
// $Revision: 1.3 $
// $Date: 2002/04/04 18:04:30 $
// $Author: jtremblay $
//=================================================================
// REVISION: 
// 
//=========== Copyright ToonBoom Technologies Inc. 2002  ==========

#ifndef _SDK_COMPLEX_TYPES_HEADER_
#define _SDK_COMPLEX_TYPES_HEADER_

template <int degree>
class SDK_Bezier
{
public:
	SDK_Bezier() {}
	SDK_Point &operator[] (int i) { return m_points[i]; }
	const SDK_Point &operator[] (int i) const { return m_points[i]; }
private:
	SDK_Point m_points[degree+1];
};

class SDK_BezierPath
{
	SDK_BezierPath(const SDK_BezierPath &); ///< Not implemented
public:
	SDK_BezierPath() { }

	template <int N> void Append(const SDK_Bezier<N> &bezier)
	{
		if (m_points.empty())
		{
			for(int i=0 ; i<N+1 ; ++i)
				m_points.push_back(bezier[i]);
			m_indices.push_back(0);
			int n = N;
			m_indices.push_back(n);
		} else
		{
			for(int i=1 ; i<N+1 ; ++i)
			{
				m_points.push_back(bezier[i]);
			}
			m_indices.push_back(m_points.size()-1);
		}
	}
	void Append(const SDK_Point &point, bool onCurve=true)
	{
		m_points.push_back(point);
		if (onCurve)
			m_indices.push_back(m_points.size()-1);
	}

	int GetNumBeziers() const { return m_indices.size() ? m_indices.size() - 1 : 0; }
	int GetBezierDegree(int i) { return m_indices[i+1] - m_indices[i]; }

	const SDK_Point &GetBezierPoint(int bezierIndex, int bezierPoint) const {
		return m_points[m_indices[bezierIndex] + bezierPoint];
	}

	void Clear() { m_points.clear(); m_indices.clear(); }
	
	int *GetIndicesBegin() { return &m_indices[0]; }
	SDK_Point *GetPointsBegin() { return &m_points[0]; }

	SDK_Point GetFromPoint() const { return m_points.front(); }
	SDK_Point GetToPoint() const { return m_points.back(); }

	int GetNumPoints() const
	{
		return m_points.size();
	}

	double GetPolygonArea() const
	{
		if (m_points.empty())
			return 0.0;

		double area = 0.0;
		SDK_Point start = m_points[0];
		for (int i = 1; i < GetNumPoints() - 1; i++)	
			area += (m_points[i] - start).GetDeterminant(m_points[i + 1] - start);
		return area / 2.0; 
	}

	SDK_BezierPath& Reverse()
	{
		// Reverse points
		std::reverse(m_points.begin(), m_points.end());

		// Reverse indices
		int mid = m_indices.size() / 2 + m_indices.size() % 2;
		for (int i = 0; i < mid; i++)
		{
			int tmpIndex = m_indices[i];
			m_indices[i] = m_points.size() - m_indices[m_indices.size() - i - 1] - 1;
			m_indices[m_indices.size() - i - 1] = m_points.size() - tmpIndex - 1;
		}
		return *this;
	}

private:
	std::vector<SDK_Point> m_points;
	std::vector<int>       m_indices;

};

class SDK_Image
{
	SDK_Image();                     ///< Private and not implemented
	SDK_Image(const SDK_Image &img); ///< Private and not implemented
public:
	SDK_Image(int w, int h) { m_w = w; m_h = h; m_pixels.resize(w*h); }
	SDK_RGBA &GetPixelRefAt(int x, int y) { return m_pixels[y * m_w + x]; }

	int Width() const { return m_w; }
	int Height() const { return m_h; }

private:
	int                   m_w;
	int                   m_h;
	std::vector<SDK_RGBA>   m_pixels;
};

#endif // _SDK_COMPLEX_TYPES_HEADER_
