//========== Copyright ToonBoom Technologies Inc. 2002 ============
//
// SOURCE FILE : SDK_DrawingFactory.h
// MODULE NAME : 
// DESCRIPTION : 
//
//=================================================================
// Author : Jacques Tremblay
// Modif  : 
//
// Creation Date		 : 2002-3-20
//========================VSS Auto=================================
// $Revision: 1.2 $
// $Date: 2002/04/02 14:55:03 $
// $Author: jtremblay $
//=================================================================
// REVISION: 
// 
//=========== Copyright ToonBoom Technologies Inc. 2002  ==========

#ifndef _SDK_DRAWING_FACTORY_HEADER_
#define _SDK_DRAWING_FACTORY_HEADER_

//=================================================================
//						INCLUDE
//=================================================================

#include "SDK_Types.h"

class SDK_Framework;
class SDK_ColorID;
class SDK_GradientID;
class SDK_TextureID;

////////////////////////////////////////////////////////////////
/// This class is provided by the SDK framework to enable client
/// code to create drawings in the current TBS animation.
class SDK_DrawingFactory
{
public:

	typedef enum
	{
		STROKE_RIGHT, ///< Right of the stroke while looking from end to beginning
		STROKE_LEFT   ///<  Left of the stroke while looking from end to beginning
	} StrokeSide;

	typedef enum
	{
		NO_LINESTYLE,				///<	stroke delimiting color boundaries (free-hand contour).
		CUTTER_LINESTYLE,			///<	cutter stroke, can have the same color on each side.	
		STROKE_LINESTYLE,			///<	invisible and permanent stroke added by user.
		HAIR_LINESTYLE,			///<	one-pixel thin line, independant of zoom level.
		THICK_LINESTYLE			///<	line having a specific thickness, dependant on zoom level.
	} StrokeStyle;

	virtual ~SDK_DrawingFactory() = 0;

	/// Call this method to begin a new drawing
	virtual void BeginDrawing() = 0;

	/// Call this method when to finish the current drawing before
	/// proceeding to a new one.
	virtual void EndDrawing() = 0;

	virtual void SetCurrentColor(StrokeSide side, const SDK_ColorID *color) = 0;
	virtual void SetCurrentColor(StrokeSide side, const SDK_GradientID *gradient, const SDK_Matrix2x3 &applicationMatrix) = 0;
	virtual void SetCurrentColor(StrokeSide side, const SDK_TextureID *texture, const SDK_Matrix2x3 &applicationMatrix) = 0;

	virtual void SetCurrentStrokeStyle(StrokeStyle style) = 0;
	virtual void SetCurrentStrokeColor(const SDK_ColorID *color) = 0;
	virtual void SetCurrentStrokeWidth(float width) = 0;

	virtual void AddStroke(int nIndices, int *indices, SDK_Point *points) = 0;

	/// Tell the factory that the next layer will be a clipping layer and
	/// the other layers will be clipee layers.
	virtual void BeginClip() = 0;

	/// Performs the clipping of all the layers created after the clipping
	/// layer
	virtual void EndClip() = 0;

	virtual void BeginLayer() = 0;
	virtual void EndLayer() = 0;

	/// Returns a reference to the framework.
	virtual SDK_Framework &GetFramework() = 0;

	virtual double GetModelWidth() = 0;
	virtual double GetRoundingQuantum() = 0;

	/// If this returns true, the plugin must stop the import ASAP...
	virtual bool CancelImport() = 0;
};



#endif // _SDK_DRAWING_FACTORY_HEADER_
