//========== Copyright ToonBoom Technologies Inc. 2002 ============
//
// SOURCE FILE : SDK_Importer.h
// MODULE NAME : 
// DESCRIPTION : 
//
//=================================================================
// Author : Jacques Tremblay
// Modif  : 
//
// Creation Date		 : 2002-3-20
//========================VSS Auto=================================
// $Revision: 1.1 $
// $Date: 2002/03/26 17:35:24 $
// $Author: jtremblay $
//=================================================================
// REVISION: 
// 
//=========== Copyright ToonBoom Technologies Inc. 2002  ==========

#ifndef _SDK_IMPORTER_HEADER_
#define _SDK_IMPORTER_HEADER_

class SDK_Framework;
class SDK_DrawingFactory;
class SDK_MovieFactory;
class SDK_FileSpec;

/// The importer dll must export a function with this type and named 
///                           SDK_IMPORTER_INIT_SYMBOL_NAME
typedef int (*SDK_ImporterInitFunctionPtr) (SDK_Framework &framework);
#define SDK_IMPORTER_INIT_SYMBOL_NAME SDKImporterInit

class SDK_DrawingImporter
{
public:
	virtual ~SDK_DrawingImporter() = 0;

	/// This method must be implemented by the client code to
	/// import a drawing who is contained in the file file.
	virtual int Import(const SDK_FileSpec &file, SDK_DrawingFactory &factory) = 0;

	/// This must return the description of the files it imports
	virtual const char *GetFileDescription() = 0;

	// This must return the number of know extensions. Usually 1.
	virtual int GetNumFileExtensions() = 0;
	
	// This must return the ith known extension.
	virtual const char *GetExtension(int i) = 0;
};

class SDK_MovieImporter
{
public:
	virtual ~SDK_MovieImporter() = 0;

	virtual int Import(const SDK_FileSpec &file, SDK_MovieFactory &factory) = 0;

	virtual const char *GetFileDescription() = 0;

	virtual int GetNumFileExtensions() = 0;
	
	virtual const char *GetExtension(int i) = 0;
};

#endif // _SDK_IMPORTER_HEADER_

