//========== Copyright ToonBoom Technologies Inc. 2002 ============
//
// SOURCE FILE : SDK_PaletteManager.h
// MODULE NAME : 
// DESCRIPTION : 
//
//=================================================================
// Author : Jacques Tremblay
// Modif  : 
//
// Creation Date		 : 2002-3-21
//========================VSS Auto=================================
// $Revision: 1.1 $
// $Date: 2002/03/26 17:35:24 $
// $Author: jtremblay $
//=================================================================
// REVISION: 
// 
//=========== Copyright ToonBoom Technologies Inc. 2002  ==========

#ifndef _SDK_PALETTE_MANAGER_HEADER_
#define _SDK_PALETTE_MANAGER_HEADER_

class SDK_Palette;
class SDK_RGBA;
class SDK_Gradient;
class SDK_ColorID;
class SDK_GradientID;
class SDK_TextureID;

class SDK_PaletteManager {
public:
	virtual ~SDK_PaletteManager() = 0;

	virtual SDK_Palette *FindOrAddPalette(const char *name) = 0;
	virtual SDK_Palette *AddPalette(const char *baseName) = 0;

	virtual SDK_ColorID *FindOrAddColor(SDK_Palette *inPalette, const SDK_RGBA &color) = 0;
	virtual SDK_ColorID *AddColor(SDK_Palette *inPalette, const SDK_RGBA &color) = 0;

	virtual SDK_GradientID *FindOrAddGradient(SDK_Palette *inPalette, const SDK_Gradient &color) = 0;
	virtual SDK_GradientID *AddGradient(SDK_Palette *inPalette, const SDK_Gradient &color) = 0;

	virtual SDK_TextureID *AddTexture(SDK_Palette *inPalette, int w, int h, const SDK_RGBA *pixelArray, bool tiled) = 0;
};

#endif // _SDK_PALETTE_MANAGER_HEADER_
