//========== Copyright ToonBoom Technologies Inc. 2002 ============
//
// SOURCE FILE : SDK_Types.h
// MODULE NAME : 
// DESCRIPTION : 
//
//=================================================================
// Author : Jacques Tremblay
// Modif  : 
//
// Creation Date		 : 2002-3-20
//========================VSS Auto=================================
// $Revision: 1.4 $
// $Date: 2002/04/17 17:55:33 $
// $Author: jtremblay $
//=================================================================
// REVISION: 
// 
//=========== Copyright ToonBoom Technologies Inc. 2002  ==========

#ifndef _SDK_TYPES_HEADER_
#define _SDK_TYPES_HEADER_

//=================================================================
//						DEFINE
//=================================================================

// Error code
#define SDK_IMPORT_NO_ERROR             0
#define SDK_IMPORT_COULD_NOT_OPEN_FILE -1
#define SDK_IMPORT_FAILED              -2
#define SDK_IMPORT_WRONG_FILE_TYPE     -3
#define SDK_IMPORT_UNSUPPORTED_VERSION -4
#define SDK_IMPORT_INIT_FAILED         -5

///////////////////////////////////////////////////////////////////
// Classes

class SDK_Matrix2x3;

class SDK_Vector
{
public:
	SDK_Vector() { m_x = m_y = 0.0f; }
	SDK_Vector(float x, float y) { m_x = x; m_y = y; }

	float &GetX() { return m_x; }
	float GetX() const { return m_x; }
	float &GetY() { return m_y; }
	float GetY() const { return m_y; }
	void SetX(float x) { m_x = x; }
	void SetY(float y) { m_y = y; }
	void SetXY(float x, float y) { m_x = x; m_y = y; }

	SDK_Vector operator*(double s) { return SDK_Vector(m_x*s, m_y*s); }
	SDK_Vector &operator+(const SDK_Vector &v) {
		m_x += v.m_x;
		m_y += v.m_y;
		return *this;
	}
	SDK_Vector operator-() const { return SDK_Vector(-m_x, -m_y); }

	double GetLength() const { return sqrt(m_x*m_x + m_y*m_y); }

	double GetDeterminant(const SDK_Vector &pt) const
	{
		return m_x * pt.m_y - m_y * pt.m_x;
	}

private:
	float m_x;
	float m_y;
};

class SDK_Point
{
public:
	SDK_Point() { m_x = m_y = 0.0f; }
	SDK_Point(float x, float y) { m_x = x; m_y = y; }

	float &GetX() { return m_x; }
	float GetX() const { return m_x; }
	float &GetY() { return m_y; }
	float GetY() const { return m_y; }
	void SetX(float x) { m_x = x; }
	void SetY(float y) { m_y = y; }
	void SetXY(float x, float y) { m_x = x; m_y = y; }
	
	SDK_Point operator*(const SDK_Matrix2x3& i_matrix) const;

	bool operator==(const SDK_Point &pt) const { return m_x == pt.m_x && m_y == pt.m_y; }
	bool operator!=(const SDK_Point &pt) const { return m_x != pt.m_x || m_y != pt.m_y; }

	SDK_Vector operator-(const SDK_Point &rhs) const
	{
		return SDK_Vector(m_x-rhs.m_x, m_y-rhs.m_y);
	}

private:
	float m_x;
	float m_y;
};



class SDK_Matrix2x3 
{
public:
	SDK_Matrix2x3()
	{
		Identity();
	}

	SDK_Matrix2x3(	const SDK_Vector & xAxis,
			         const SDK_Vector & yAxis,
						const SDK_Point & origin)
	{
		m_matrix[0][0] = xAxis.GetX();
		m_matrix[0][1] = xAxis.GetY();
		m_matrix[1][0] = yAxis.GetX();
		m_matrix[1][1] = yAxis.GetY();
		m_matrix[2][0] = origin.GetX();
		m_matrix[2][1] = origin.GetY();
	}

	SDK_Matrix2x3(const double *array) {
		memcpy(m_matrix, array, sizeof(double) * 6);
	}

	double *GetMatrix() { return &m_matrix[0][0]; }
	const double *GetMatrix() const { return &m_matrix[0][0]; }

	SDK_Matrix2x3 &Identity() {
		m_matrix[0][0] = 1;
		m_matrix[0][1] = 0;
		m_matrix[1][0] = 0;
		m_matrix[1][1] = 1;
		m_matrix[2][0] = 0;
		m_matrix[2][1] = 0;
		return *this;
	}

	SDK_Matrix2x3& Translate(const SDK_Vector& i_translate)
	{
		SDK_Matrix2x3 tmp = *this;
		Multiply(tmp, CreateTranslate(i_translate));
		return *this;
	}
	
	SDK_Matrix2x3 CreateTranslate(const SDK_Vector& i_translate)
	{
		return SDK_Matrix2x3(SDK_Vector(1.0, 0.0), 
									SDK_Vector(0.0, 1.0),
									SDK_Point(i_translate.GetX(), i_translate.GetY()));
	}

	SDK_Matrix2x3 CreateScale(const SDK_Vector& i_scale)
	{
		return SDK_Matrix2x3(SDK_Vector(i_scale.GetX(), 0.0), 
							SDK_Vector(0.0, i_scale.GetY()),
							SDK_Point(0.0, 0.0));
	}

	void SDK_Matrix2x3::Multiply(const SDK_Matrix2x3& i_matrix1, const SDK_Matrix2x3& i_matrix2)
	{		
		// first row
		(*this)(0, 0) = i_matrix1(0, 0) * i_matrix2(0, 0) + i_matrix1(1, 0) * i_matrix2(0, 1);
		(*this)(1, 0) = i_matrix1(0, 0) * i_matrix2(1, 0) + i_matrix1(1, 0) * i_matrix2(1, 1);

		// second row
		(*this)(0, 1) = i_matrix1(0, 1) * i_matrix2(0, 0) + i_matrix1(1, 1) * i_matrix2(0, 1);
		(*this)(1, 1) = i_matrix1(0, 1) * i_matrix2(1, 0) + i_matrix1(1, 1) * i_matrix2(1, 1);

		// third row
		(*this)(0, 2) = i_matrix1(0, 2) * i_matrix2(0, 0) + i_matrix1(1, 2) * i_matrix2(0, 1) + i_matrix2(0, 2);
		(*this)(1, 2) = i_matrix1(0, 2) * i_matrix2(1, 0) + i_matrix1(1, 2) * i_matrix2(1, 1) + i_matrix2(1, 2);
	}

	SDK_Matrix2x3& Scale(const SDK_Vector& i_scale)
	{
		SDK_Matrix2x3 tmp = *this;
		Multiply(tmp, CreateScale(i_scale));
		return *this;
	}


	double& operator()(unsigned int i_column, unsigned int i_row) {
		return m_matrix[i_row][i_column];
	}
	
	const double& operator()(unsigned int i_column, unsigned int i_row) const {
		return m_matrix[i_row][i_column];
	}


	SDK_Point Transform(const SDK_Point& i_point) const
	{
		return SDK_Point(i_point.GetX() * (*this)(0, 0) + i_point.GetY() * (*this)(0, 1) + (*this)(0, 2),
							  i_point.GetX() * (*this)(1, 0) + i_point.GetY() * (*this)(1, 1) + (*this)(1, 2));
	}

	SDK_Vector Transform(const SDK_Vector& i_vector) const
	{
		return SDK_Vector(i_vector.GetX() * (*this)(0, 0) + i_vector.GetY() * (*this)(0, 1),
								i_vector.GetX() * (*this)(1, 0) + i_vector.GetY() * (*this)(1, 1));	
	}

	SDK_Matrix2x3 operator*(const SDK_Matrix2x3& i_matrix) const
	{
		return SDK_Matrix2x3(
			// first row
			SDK_Vector((*this)(0, 0) * i_matrix(0, 0) + (*this)(1, 0) * i_matrix(0, 1),
			(*this)(0, 0) * i_matrix(1, 0) + (*this)(1, 0) * i_matrix(1, 1)),

			// second row
			SDK_Vector((*this)(0, 1) * i_matrix(0, 0) + (*this)(1, 1) * i_matrix(0, 1),
			(*this)(0, 1) * i_matrix(1, 0) + (*this)(1, 1) * i_matrix(1, 1)),

			// third row
			SDK_Point((*this)(0, 2) * i_matrix(0, 0) + (*this)(1, 2) * i_matrix(0, 1) + i_matrix(0, 2),
			(*this)(0, 2) * i_matrix(1, 0) + (*this)(1, 2) * i_matrix(1, 1) + i_matrix(1, 2))
			);
	}


private:
	double m_matrix[3][2];
};

inline SDK_Point SDK_Point::operator*(const SDK_Matrix2x3& i_matrix) const
{
	return i_matrix.Transform(*this);
}


class SDK_RGBA
{
public:
	SDK_RGBA() { m_r = m_g = m_b = 0; m_a = 255; }
	SDK_RGBA(unsigned char r, unsigned char g, unsigned char b, unsigned char a = 255) { 
		m_r = r; m_g = g; m_b = b; m_a = a; }

	unsigned char GetR() const { return m_r; }
	unsigned char GetG() const { return m_g; }
	unsigned char GetB() const { return m_b; }
	unsigned char GetA() const { return m_a; }

	void SetR(unsigned char r) { m_r = r; }
	void SetG(unsigned char g) { m_g = g; }
	void SetB(unsigned char b) { m_b = b; }
	void SetA(unsigned char a) { m_a = a; }

	bool operator<(const SDK_RGBA &c) const {
		if (m_r != c.m_r)
			return m_r < c.m_r;
		if (m_g != c.m_g)
			return m_g < c.m_g;
		if (m_b != c.m_b)
			return m_b < c.m_b;
		return m_a < c.m_a;
	}
	
	bool operator==(const SDK_RGBA &c) const {
		return m_r == c.m_r && m_g == c.m_g &&
			m_b == c.m_b && m_a == c.m_a;
	}

	bool operator!=(const SDK_RGBA &c) const {
		return !operator==(c);
	}

private:
	unsigned char m_r;
	unsigned char m_g;
	unsigned char m_b;
	unsigned char m_a;
};

class SDK_Gradient
{
public:
	enum { MAX_NUM_MARKERS = 8 };
	typedef enum { RADIAL, LINEAR } Type;

	SDK_Gradient() { m_numMarkers = 0; }

	bool operator<(const SDK_Gradient &g) const {
		if (m_markers != g.m_markers)
			return m_markers < g.m_markers;
		int i;
		for(i = 0 ; i < m_numMarkers ; ++i)
		{
			if (m_positions[i] != g.m_positions[i])
				return m_positions[i] < g.m_positions[i];
			if (m_markers[i] != g.m_markers[i])
				return m_markers[i] < g.m_markers[i];
		}
		return false;
	}

	int GetNumMarkers() const { return m_numMarkers; }
	SDK_RGBA GetColor(int i) const { return m_markers[i]; }
	float GetPosition(int i) const { return m_positions[i]; }
	Type GetType() const { return m_type; }

	void SetType(Type t) { m_type = t; }
	void SetNumMarkers(int n) { m_numMarkers = n; }
	float *GetPositionBegin() { return &m_positions[0]; }
	SDK_RGBA *GetMarkersBegin() { return &m_markers[0]; }

private:
	Type          m_type;
	int           m_numMarkers;
	SDK_RGBA      m_markers[MAX_NUM_MARKERS];
	float         m_positions[MAX_NUM_MARKERS];
};

class SDK_FileSpec
{
public:
	const wchar_t *GetFileName() const { return m_fileName; }
	wchar_t *GetFileName() { return m_fileName; }
private:
	wchar_t m_fileName[1024];
};


#endif // _SDK_TYPES_HEADER_
