    -- this script file contains the AI classes for gods

-- guixin, always invoke
sgs.ai_skill_invoke.guixin = true

-- shelie
sgs.ai_skill_invoke.shelie = true

local gongxin_skill={}
gongxin_skill.name="gongxin"
table.insert(sgs.ai_skills,gongxin_skill)
gongxin_skill.getTurnUseCard=function(self)
		local card_str = ("@GongxinCard=.")
		local gongxin_card = sgs.Card_Parse(card_str)
		assert(gongxin_card)
        return gongxin_card
end

sgs.ai_skill_use_func["GongxinCard"]=function(card,use,self)
    if self.player:hasUsed("GongxinCard") or not self.enemies  then return end
    self:sort(self.enemies,"handcard")
    
    for _,enemy in ipairs(self.enemies) do  
        local cards = enemy:getHandcards()
		for _, acard in sgs.qlist(cards) do				
			if acard:getSuit() == sgs.Card_Heart and not acard:inherits("Shit") then
				use.card = card
				if use.to then use.to:append(enemy) end
				return
			end
		end
    end
end

local shenlubu_ai = SmartAI:newSubclass "shenlubu"

function shenlubu_ai:useTrickCard(card, use)
	if self.player:getMark("@wrath") > 0 then
		return super.useTrickCard(self, card, use)
	end
end

sgs.ai_skill_choice.wumou = "discard"

sgs.ai_skill_invoke.lianpo = true


--wushen
local shenguanyu_ai = SmartAI:newSubclass "shenguanyu"

function shenguanyu_ai:askForCard(pattern,prompt)
	local card = super.askForCard(self, pattern, prompt)
	if card then return card end
	if pattern == "slash" then
		local cards = self.player:getCards("h")
		cards=sgs.QList2Table(cards)
		self:fillSkillCards(cards)
		self:sortByUseValue(cards,true)
		for _, card in ipairs(cards) do
			if card:getSuit() == sgs.Card_Heart then
				local suit = card:getSuitString()
				local number = card:getNumberString()
				local card_id = card:getEffectiveId()
				return ("slash:wushen[%s:%s]=%d"):format(suit, number, card_id)
			end
		end
	end
   
end

--longhun
local longhun_skill={}
longhun_skill.name="longhun"
table.insert(sgs.ai_skills,longhun_skill)
longhun_skill.getTurnUseCard=function(self,inclusive)
    local cards = self.player:getCards("he")	
    cards=sgs.QList2Table(cards)
	
	local red_card
	
	self:sortByUseValue(cards,true)
	
	for _,card in ipairs(cards)  do
		if card:getSuit()==sgs.Card_Diamond and not card:inherits("FireSlash") and not card:inherits("Peach") 				--not peach
			and ((self:getUseValue(card)<sgs.ai_use_value["FireSlash"]) or inclusive) then
			red_card = card
			break
		end
	end

	if red_card then		
		local suit = red_card:getSuitString()
    	local number = red_card:getNumberString()
		local card_id = red_card:getEffectiveId()
		local card_str = ("fire_slash:longhun[%s:%s]=%d"):format(suit, number, card_id)
		local slash = sgs.Card_Parse(card_str)
		
		assert(slash)
        return slash
	end
end

--qinyin
local function getQinYinExpect(self, choice)
	local expect=0
	local loyal=false
	--ToDo: take jieyin and jijiu and qingnang into consideration
	for _,friend in ipairs(self.friends) do
		if choice=="up" then
			if friend:isWounded() then
				expect=expect+1
				if friend:hasSkill("enyuan") then expect=expect+0.5 end
			end
		else
			if friend:getHp()<=1 then
				expect=expect-2
				if (sgs.ai_explicit[friend:objectName()] == "loyalist" or sgs.ai_explicit[friend:objectName()]=="loyalish") then loyal=true end
			else expect=expect-1 end
		end
	end
	for _,enemy in ipairs(self.enemies) do
		if choice=="up" then
			if enemy:isWounded() then expect=expect-1 end
		else
			if enemy:getHp()<=1 then 
				expect=expect+2 
				if sgs.ai_explicit[enemy:objectName()] == "rebel" or sgs.ai_explicit[enemy:objectName()] == "rebelish" then expect=expect+1.5 end
			else
				expect=expect+1
			end
		end
	end
	if self.player:getHp()<=1 and choice=="down" then expect=expect-1 end
	if self.player:isLord() and loyal then expect=expect-self.player:getCards("he"):length()/2-0.5 end
	return expect
end

sgs.ai_skill_invoke.qinyin=function(self, data)
	return getQinYinExpect(self,"up")>0 or getQinYinExpect(self,"down")>0
end

sgs.ai_skill_choice.qinyin=function(self, choices)
	if getQinYinExpect(self,"up")<0 and getQinYinExpect(self,"down")<0 then assert(false) return "up" end
	if getQinYinExpect(self,"up")>getQinYinExpect(self,"down") then return "up" else return "down" end
end