-- danlao
sgs.ai_skill_invoke.danlao = function(self, data)
	local effect = data:toCardEffect()
	if effect.card:inherits("GodSalvation") and self.player:isWounded() then
		return false
	else
		return true
	end
end

sgs.ai_skill_invoke.jijiangf = function(self, data)
	if self:getSlashNumber(self.player,true)<=0 and #self.friends_noself > 0 then
		self.jijiangf_used = true
		return true
	end
	return false
end

sgs.ai_skill_choice.jijiangf = function(self , choices)
	if self.player:hasSkill("yongsi") or self.player:hasSkill("jijiangf") then
		if self:getSlashNumber(self.player) <= 0 then return "ignore" end
	end
    if self:isFriend(self.room:getLord()) then return "accept" end
    return "ignore"
end

sgs.ai_skill_choice.hujiaf = function(self , choices)
	if self.player:hasSkill("yongsi") or self.player:hasSkill("hujiaf") then
		if self:getJinkNumber(self.player) <= 0 then return "ignore" end
	end
    if self:isFriend(self.room:getLord()) then return "accept" end
    return "ignore"
end

-- hujiaf
sgs.ai_skill_invoke.hujiaf = function(self, data)
	if self:getJinkNumber(self.player,true)<=0 and not self.hujiaf_used and #self.friends_noself > 0 then
		--self.hujiaf_used = true
		return true
	end
	return false
end

local jijiangf_skill={}
jijiangf_skill.name="jijiangf"
table.insert(sgs.ai_skills,jijiangf_skill)
jijiangf_skill.getTurnUseCard=function(self)
	if not self:slashIsAvailable() then return nil end
	if self.jijiangf_used then return nil end
	local card_str = "@JijiangfCard=."
	local slash = sgs.Card_Parse(card_str)
	assert(slash)
	return slash
end

sgs.ai_skill_use_func["JijiangfCard"]=function(card,use,self)
	self:sort(self.enemies, "expect")
	local target_count=0
    for _, enemy in ipairs(self.enemies) do
		if ((self.player:canSlash(enemy, not no_distance)) or (use.isDummy and (self.player:distanceTo(enemy)<=self.predictedRange)))
			and self:objectiveLevel(enemy)>3 and self:slashIsEffective(card, enemy) and not self:slashProhibit(nil, enemy) then
                use.card=card
                if use.to then
                    use.to:append(enemy)
                    self.jijiangf_used=true
                end
                target_count=target_count+1
                if self.slash_targets<=target_count then return end
		end
   end
end

-- linchong
sgs.ai_skill_invoke.zhuiji = function(self, data)
	local damage = data:toDamage()
	return self:isEnemy(damage.to)
end

-- budao
sgs.ai_skill_invoke.budao = function(self, data)
	local damage = data:toDamage()
	return self:isEnemy(damage.to)
end

-- fanji
sgs.ai_skill_invoke.fanji = true

local lijia_skill={}
lijia_skill.name="lijia"
table.insert(sgs.ai_skills,lijia_skill)
lijia_skill.getTurnUseCard=function(self)
	if self.player:hasUsed("LijiaCard") then
		return
	end
	if not self.player:isNude() then
		local card
		local card_id
		if self.player:getArmor() and self.player:isWounded() and self.player:getArmor():objectName()=="silver_lion" then
			card = sgs.Card_Parse("@LijiaCard=" .. self.player:getArmor():getId())
		elseif self.player:getHandcardNum() > self.player:getHp() then
			local cards = self.player:getHandcards()
			cards=sgs.QList2Table(cards)

			for _, acard in ipairs(cards) do
				if not acard:inherits("Peach") and not acard:inherits("Shit") then
					card_id = acard:getEffectiveId()
					break
				end
			end
		elseif not self.player:getEquips():isEmpty() then
			local player=self.player
			if player:getWeapon() then card_id=player:getWeapon():getId()
			elseif player:getOffensiveHorse() then card_id=player:getOffensiveHorse():getId()
			elseif player:getDefensiveHorse() then card_id=player:getDefensiveHorse():getId()
			elseif player:getArmor() and player:getHandcardNum()<=1 then card_id=player:getArmor():getId()
			end
		end
		if not card_id then
			cards=sgs.QList2Table(self.player:getHandcards())
			for _, acard in ipairs(cards) do
				if not acard:inherits("Peach") and not acard:inherits("Shit") then
					card_id = acard:getEffectiveId()
					break
				end
			end
		end
		if not card_id then
			return nil
		else
			card = sgs.Card_Parse("@LijiaCard=" .. card_id)
			return card
		end
	end
	return nil
end

sgs.ai_skill_use_func["LijiaCard"]=function(card,use,self)
	local findFriend_maxSlash=function(self,first)
		self:log("Looking for the friend!")
		local maxSlash = 0
		local friend_maxSlash
		for _, friend in ipairs(self.friends_noself) do
			if self:getSlashNumber(friend)>= maxSlash and friend:getGeneral():isMale() then
				maxSlash=self:getSlashNumber(friend)
				friend_maxSlash = friend
			end
		end
		if friend_maxSlash then
			local safe = false
			if (first:hasSkill("ganglie") or first:hasSkill("enyuan")) then
				if (first:getHp()<=1 and self:getSlashNumber(first)==0) then safe=true end
			elseif (self:getSlashNumber(friend_maxSlash) >= first:getHandcardNum()) then safe=true end
			if safe then return friend_maxSlash end
		else self:log("unfound")
		end
		return nil
	end

	if not self.player:hasUsed("LijiaCard") then
		self:sort(self.enemies, "hp")
		local males = {}
		local first, second
		local zhugeliang_kongcheng,guojia_yiji
		local gift
		local firstSlashNum = 0
		for _, enemy in ipairs(self.enemies) do
			if #males==1 and males[1]:getHp()<=1 and #self.friends_noself > 0 then
				gift = true
				break
			end
			if zhugeliang_kongcheng and #males==1 then table.insert(males, zhugeliang_kongcheng) end
			if enemy:getGeneral():isMale() and not enemy:hasSkill("wuyan") then
				if enemy:hasSkill("kongcheng") and enemy:isKongcheng() then	zhugeliang_kongcheng=enemy
				elseif enemy:hasSkill("yiji") and enemy:getHp()>1 then guojia_yiji = enemy
				else table.insert(males, enemy)	end
				if #males >= 2 then	break end
			end
		end
		if #males==1 and guojia_yiji and not gift then table.insert(males, guojia_yiji) end
		--if (#males==0) then self:log("No real men!") end
		if #males>0 then
			firstSlashNum = self:getSlashNumber(males[1])
		end
		if (#males==1) and #self.friends_noself>0 and not gift then
			--self:log("Only 1")
			first = males[1]
			if zhugeliang_kongcheng then table.insert(males, zhugeliang_kongcheng)
			else
				local friend_maxSlash = findFriend_maxSlash(self,first)
				if friend_maxSlash and firstSlashNum <= self:getSlashNumber(friend_maxSlash) then table.insert(males, friend_maxSlash) end
			end
		end

		if (#males >= 2) then
			first = males[1]
			second = males[2]
		end

		if second or (first and gift) then
			local lord = self.room:getLord()
			if (first:getHp()<=1) then
				if self.player:isLord() or isRolePredictable() then
					local friend_maxSlash = findFriend_maxSlash(self,first)
					if friend_maxSlash then second=friend_maxSlash end
				elseif (lord:getGeneral():isMale()) and (not lord:hasSkill("wuyan")) then
					if (self.role=="rebel") and (not first:isLord()) then
						second = lord
					else
						if (self.role=="loyalist" or self.role=="renegade") and (not (first:hasSkill("ganglie") and first:hasSkill("enyuan")) or lord:getHp() >= 3)
							and	(firstSlashNum <= self:getSlashNumber(lord)) then
							--the first male maybe have a "Slash" Card
							second = lord
						end
					end
				end
			end

			if first and second then
				if use.to then
			        use.to:append(first)
			        use.to:append(second)
			        self.lijia_used = true
				end
			end
            use.card=card
		end
	end
end

local shixian_skill={}
shixian_skill.name="shixian"
table.insert(sgs.ai_skills,shixian_skill)
shixian_skill.getTurnUseCard=function(self,inclusive)
	if not self.player:hasUsed("ShixianCard") and self.player:getHandcardNum() < self.player:getMaxHP() then
		return sgs.Card_Parse("@ShixianCard=.")
	end
end

sgs.ai_skill_use_func["ShixianCard"]=function(card,use,self)
	use.card=card
end

-- libai
local jiusheng_skill={}
jiusheng_skill.name="jiusheng"
table.insert(sgs.ai_skills,jiusheng_skill)
jiusheng_skill.getTurnUseCard=function(self)
    local cards = self.player:getCards("h")
    cards=sgs.QList2Table(cards)

	local anal_card

	self:sortByUseValue(cards,true)

	for _,card in ipairs(cards)  do
		if card:inherits("Analeptic") then
			anal_card = card
			break
		end
	end

	if anal_card then
		local suit = anal_card:getSuitString()
    	local number = anal_card:getNumberString()
		local card_id = anal_card:getEffectiveId()
		local card_str = ("peach:jiusheng[%s:%s]=%d"):format(suit, number, card_id)
		local slash = sgs.Card_Parse(card_str)

		assert(peach)
        return peach
	end
end

local shentou_skill={}
shentou_skill.name="shentou"
table.insert(sgs.ai_skills,shentou_skill)
shentou_skill.getTurnUseCard=function(self,inclusive)
    local cards = self.player:getCards("he")
    cards=sgs.QList2Table(cards)

	local card

	self:sortByUseValue(cards,true)

	local has_weapon=false

	for _,acard in ipairs(cards)  do
	    if acard:inherits("Weapon") and not (acard:getSuit() == sgs.Card_Club) then has_weapon=true end
	end

	for _,acard in ipairs(cards)  do
		if (acard:getSuit() == sgs.Card_Club) and ((self:getUseValue(acard)<sgs.ai_use_value["Snatch"]) or inclusive) then
		    local shouldUse=true

		    if acard:inherits("Armor") then
                if not self.player:getArmor() then shouldUse=false
                elseif self:hasEquip(acard) then shouldUse=false
                end
            end

            if acard:inherits("Weapon") then
                if not self.player:getWeapon() then shouldUse=false
                elseif self:hasEquip(acard) and not has_weapon then shouldUse=false
                end
            end

		    if shouldUse then
			    card = acard
			    break
			end
		end
	end

    if not card then return end
	local number = card:getNumberString()
    local card_id = card:getEffectiveId()
	local card_str = ("snatch:shentou[club:%s]=%d"):format(number, card_id)
	local  snatch= sgs.Card_Parse(card_str)

    assert(snatch)

    return snatch
end

-- xiaoqiao
sgs.ai_skill_invoke.tianxian = function(self, data)
	local hand_card = self.player:getHandcards()
	local judge_list = self.player:getCards("j")
	for _, judge in sgs.qlist(judge_list) do
		for _, card in sgs.qlist(hand_card) do
			if card:getSuit() == judge:getSuit() then return true end
		end
	end

	return false
end

local touji_skill={}
touji_skill.name="touji"
table.insert(sgs.ai_skills,touji_skill)
touji_skill.getTurnUseCard=function(self,inclusive)
    local cards = self.player:getCards("he")
    cards=sgs.QList2Table(cards)

	local card

	self:sortByUseValue(cards,true)

	local has_weapon=false

	for _,acard in ipairs(cards)  do
	    if acard:inherits("Weapon") and not (acard:getSuit() == sgs.Card_Spade) then has_weapon=true end
	end

	for _,acard in ipairs(cards)  do
		if (acard:getSuit() == sgs.Card_Spade) and ((self:getUseValue(acard)<sgs.ai_use_value["Collateral"]) or inclusive) then
		    local shouldUse=true

		    if acard:inherits("Armor") then
                if not self.player:getArmor() then shouldUse=false
                elseif self:hasEquip(acard) then shouldUse=false
                end
            end

            if acard:inherits("Weapon") then
                if not self.player:getWeapon() then shouldUse=false
                elseif self:hasEquip(acard) and not has_weapon then shouldUse=false
                end
            end

		    if shouldUse then
			    card = acard
			    break
			end
		end
	end

    if not card then return end
	local number = card:getNumberString()
    local card_id = card:getEffectiveId()
	local card_str = ("collateral:touji[spade:%s]=%d"):format(number, card_id)
	local  collateral= sgs.Card_Parse(card_str)

    assert(collateral)

    return collateral
end

-- tiemuzhen
sgs.ai_skill_invoke.qianglue = function(self, data)
	local effect = data:toSlashEffect()
	return not self:isFriend(effect.to) or (self:hasSkills(sgs.lose_equip_skill,effect.to) and not effect.to:getEquips():isEmpty())
end

--tianxiang
sgs.ai_skill_use["@tianxiang"]=function(self, data)
	local friend_lost_hp = 10
	local friend_hp = 0
	local card_id
	local target
	local cant_use_skill
	local dmg

	if data=="@@tianxiang-card" then
		dmg = self.player:getTag("TianxiangDamage"):toDamage()
	else
		dmg=data
	end

	self:sort(self.enemies,"hp")

	for _, enemy in ipairs(self.enemies) do
		if (enemy:getHp() <= dmg.damage) then

		if (enemy:getHandcardNum() <= 2)
		or enemy:containsTrick("indulgence")
		or enemy:hasSkill("guose")
		or enemy:hasSkill("leiji")
		or enemy:hasSkill("ganglie")
		or enemy:hasSkill("enyuan")
		or enemy:hasSkill("qingguo")
		or enemy:hasSkill("wuyan")
		or enemy:hasSkill("kongcheng")
		then target = enemy break end

		end
	end

	if target then
		local cards = self.player:getCards("h")
        cards=sgs.QList2Table(cards)
		self:sortByUseValue(cards,true)
        for _,card in ipairs(cards) do
			if (card:getSuit() == sgs.Card_Spade or card:getSuit() == sgs.Card_Heart) then
				card_id = card:getId()
				return "@TianxiangCard="..card_id.."->"..target:objectName()
			end
		end
	end

	for _, friend in ipairs(self.friends_noself) do
		if (friend:getLostHp() + dmg.damage>1) then
				if friend:isChained() and #self:getChainedFriends()>1 and dmg.nature>0 then

				elseif friend:getHp() >= 2 and dmg.damage<2 and
				(
				friend:hasSkill("yiji")
				or friend:hasSkill("jieming")
				or (friend:getHandcardNum()<3 and friend:hasSkill("rende"))
				or friend:hasSkill("buqu")
				or friend:hasSkill("shuangxiong")
				or friend:hasSkill("zaiqi")
				or friend:hasSkill("yinghun")
				or friend:hasSkill("jianxiong")
				or friend:hasSkill("fangzhu")
				)
				then target=friend break

				elseif friend:hasSkill("buqu") then target=friend break end
		end
	end

	if target then
		local cards = self.player:getCards("h")
        cards=sgs.QList2Table(cards)
		self:sortByUseValue(cards,true)
        for _,card in ipairs(cards) do
			if (card:getSuit() == sgs.Card_Spade or card:getSuit() == sgs.Card_Heart) and not card:inherits("Peach") then
				card_id = card:getId()
				return "@TianxiangCard="..card_id.."->"..target:objectName()
			end
		end
	end

	for _, enemy in ipairs(self.enemies) do
		if (enemy:getLostHp() <= 1) or dmg.damage>1 then

		if (enemy:getHandcardNum() <= 2)
		or enemy:containsTrick("indulgence")
		or enemy:hasSkill("guose")
		or enemy:hasSkill("leiji")
		or enemy:hasSkill("ganglie")
		or enemy:hasSkill("enyuan")
		or enemy:hasSkill("qingguo")
		or enemy:hasSkill("wuyan")
		or enemy:hasSkill("kongcheng")
		then target = enemy break end

		end
	end

	if target then
		local cards = self.player:getCards("h")
        cards=sgs.QList2Table(cards)
		self:sortByUseValue(cards,true)
        for _,card in ipairs(cards) do
			if (card:getSuit() == sgs.Card_Spade or card:getSuit() == sgs.Card_Heart) and not card:inherits("Peach") then
				card_id = card:getId()
				return "@TianxiangCard="..card_id.."->"..target:objectName()
			end
		end
	end

	return "."
end

sgs.ai_skill_choice["guhuo"] = function(self, choices)
	local players = self.room:getOtherPlayers(self.player)
	local yuji
	for _, other in sgs.qlist(players) do
		if other:hasSkill("guhuo") then yuji = other break end
	end
	if self.lua_ai:isFriend(yuji) then return "noquestion"
	else
		if self.player:getHp() >= 2 then
			local r = math.random(0, 1)
			if r == 0 then
				return "question"
			else
				return "noquestion"
			end
		else return "noquestion"
		end
	end
end
