import MySQLdb
import MySQLdb.cursors
import StringIO
from bugzilla import *
import time

class Client(object) :

    def __init__(self, host, port, login, password, db_name = "bugs") :
        self.sql_cnx = MySQLdb.connect(host = host, port = port, user = login, passwd = password,
                                       db = db_name, cursorclass = MySQLdb.cursors.DictCursor, charset = "cp866")
        self.db_host = "%s:%s/" % (host, str(port))

    def get_bz_users(self) :
        cursor = self.sql_cnx.cursor()
        cursor.execute("SELECT userid, login_name, realname FROM profiles")
        result = list([])
        for row in cursor :
            user = BzUser(row['userid'])
            user.login = row['login_name']
            user.email = row['login_name']
            user.full_name = row['realname']
            result.append(user)
        return result

    def get_project_description(self, product_id) :
        cursor = self.sql_cnx.cursor()
        cursor.execute("SELECT description FROM products WHERE id = %s", (product_id,))
        desc = cursor.fetchone()["description"].encode('utf8')
        return desc

    def get_components(self, product_id) :
        cursor = self.sql_cnx.cursor()
        cursor.execute("SELECT id, description, initialowner, name FROM components WHERE product_id = %s", (product_id,))
        result = list([])
        for row in cursor :
            cmp = BzComponent(row['id'])
            cmp.description = row['description'].encode('utf8')
            cmp.initial_owner = self.get_login_by_id(row['initialowner'])
            cmp.name = row['name'].encode('utf8')
            result.append(cmp)
        return result

    def get_versions(self, product_id) :
        cursor = self.sql_cnx.cursor()
        cursor.execute("SELECT id, value FROM versions WHERE product_id = %s", (product_id))
        result = list([])
        for row in cursor :
            version = BzVersion(row['id'])
            version.value = row['value'].encode('utf8')
            result.append(version)
        return result

    def get_platforms(self) :
        cursor = self.sql_cnx.cursor()
        cursor.execute("SELECT value FROM rep_platform")
        result = list([])
        for row in cursor :
            result.append(row['value'])
        return result

    def get_op_systems(self) :
        cursor = self.sql_cnx.cursor()
        cursor.execute("SELECT value FROM op_sys")
        result = list([])
        for row in cursor :
            result.append(row['value'])
        return result

    def get_custom_fields(self) :
        cursor = self.sql_cnx.cursor()
        cursor.execute("SELECT name, type FROM fielddefs WHERE (custom = 1) AND NOT (type = 6)")
        result = list([])
        for row in cursor :
            cf = BzCustomField(row['name'][3:])
            cf.type = str(row['type'])
            if (cf.type in ["2", "3"]) :
                values_cursor = self.sql_cnx.cursor()
                values_cursor.execute("SELECT value FROM " + row['name'])
                for v in values_cursor :
                    value = v['value']
                    if (value != "---") :
                        cf.values.append(value)
            result.append(cf)
        return result

    def get_issue_link_types(self) :
        cursor = self.sql_cnx.cursor()
        cursor.execute("SELECT name, description FROM fielddefs WHERE (custom = 1) AND (type = 6)")
        result = list([])
        for row in cursor :
            link_type = BzIssueLinkType(row['name'][3:])
            link_type.description = row['description'].encode('utf8')
            result.append(link_type)
        return result

    def get_issue_links(self) :
        link_types = self.get_issue_link_types()
        result = set([])
        if (len(link_types) == 0) :
            return result
        request = "SELECT bug_id, product_id, "
        for elem in link_types :
            request = request + "cf_" + elem.name + ", "
        request = request[:-2]
        request = request + " FROM bugs"
        cursor = self.sql_cnx.cursor()
        cursor.execute(request)
        for row in cursor :
            bug_id = row['bug_id']
            for type in link_types :
                target = row["cf_" + type.name]
                if (target is not None) :
                    link = BzIssueLink(type.name, str(bug_id), str(target))
                    link.source_product_id = str(row["product_id"])
                    link.target_product_id = str(self.get_product_id_by_bug_id(target))
                    result.add(link)
        return result

    def get_issues(self, product_id) :
        cursor = self.sql_cnx.cursor()
        cursor.execute("SELECT assigned_to, bug_id, bug_severity, bug_status, component_id, creation_ts, keywords, " +
                       "op_sys, priority, rep_platform, reporter, resolution, short_desc, version, votes "
                       + "FROM bugs WHERE product_id = %s", (product_id,))
        result = list([])
        cf_cursor = self.sql_cnx.cursor()
        cf_cursor.execute("SELECT name, type FROM fielddefs WHERE (custom = 1) AND NOT (type = 6)")
        cf_map = dict([])
        for row in cf_cursor :
            cf_map[row['name']] = row['type']
        for row in cursor :
            issue = BzIssue(str(row['bug_id']))
            issue.assignee = self.get_login_by_id(row['assigned_to'])
            issue.severity = row['bug_severity']
            issue.status = row['bug_status']
            component_cursor = self.sql_cnx.cursor()
            component_cursor.execute("SELECT name FROM components WHERE id = %s", (row['component_id'],))
            for c in component_cursor :
                issue.component = c['name']
            issue.created = time.mktime(row['creation_ts'].timetuple())+1e-6*row['creation_ts'].microsecond
            keywords = row['keywords'].split(",")
            # tags
            for kw in keywords :
                kw = kw.strip()
                if (kw != "") :
                    issue.keywords.add(kw)
            # flags
            issue.flags = self.get_flags_by_id(row['bug_id'])
            issue.op_sys = row['op_sys'].encode('utf8')
            issue.priority = row['priority']
            issue.platform = row['rep_platform'].encode('utf8')
            issue.reporter = self.get_login_by_id(row['reporter'])
            issue.resolution = row['resolution']
            issue.summary = row['short_desc']
            issue.version = row['version']
            if (row['votes'] != 0) :
                issue.voters = self.get_voters_by_id(row['bug_id'])
            # assignees
            cc_cursor = self.sql_cnx.cursor()
            cc_cursor.execute("SELECT who FROM cc WHERE bug_id = %s", (row['bug_id']))
            for cc in cc_cursor :
                issue.cc.append(self.get_login_by_id(cc['who']))
            # custom fields
            cf_values = self.get_cf_values_by_id(cf_map, row['bug_id'])
            for key in cf_values :
                issue.cf[key] = []
                for elem in cf_values[key] :
                    if (elem is not None) :
                        if (isinstance(elem, unicode)) :
                            issue.cf[key].append(elem)
                        else :
                            issue.cf[key].append(str(elem))
            # comments
            issue.comments = self.get_comments_by_id(row['bug_id'])
            # attachments
            issue.attachments = self.get_attachments_by_id(row['bug_id'])
            result.append(issue)
        return result

    def get_duplicate_links(self) :
        cursor = self.sql_cnx.cursor()
        request = "SELECT dupe, dupe_of FROM duplicates"
        cursor.execute(request)
        result = set([])
        for row in cursor :
            link = BzIssueLink("Duplicate", str(row['dupe']), str(row["dupe_of"]))
            link.source_product_id = self.get_product_id_by_bug_id(row["dupe"])
            link.target_product_id = self.get_product_id_by_bug_id(row["dupe_of"])
            result.add(link)
        return result

    def get_dependencies_link(self) :
        cursor = self.sql_cnx.cursor()
        request = "SELECT blocked, dependson FROM dependencies"
        cursor.execute(request)
        result = set([])
        for row in cursor :
            link = BzIssueLink("Depend", str(row['blocked']), str(row["dependson"]))
            link.source_product_id = self.get_product_id_by_bug_id(row["blocked"])
            link.target_product_id = self.get_product_id_by_bug_id(row["dependson"])
            result.add(link)
        return result

    def get_login_by_id(self, id) :
        cursor = self.sql_cnx.cursor()
        cursor.execute("SELECT login_name FROM profiles WHERE userid = %s", (id,))
        return cursor.fetchone()['login_name']

    def get_cf_values_by_id(self, cf_map, bug_id) :
        single_fields = list([])
        multiple_fields = list([])
        for key in cf_map :
            if (cf_map[key] == 3) :
                multiple_fields.append(key)
            else :
                single_fields.append(key)
        result = dict([])
        sing_cursor = self.sql_cnx.cursor()
        if (len(single_fields) != 0) :
            request = "SELECT "
            for elem in single_fields :
                request = request + elem + ", "
            request = request[:-2]
            request = request + " FROM bugs WHERE bug_id = %s" % (str(bug_id))
            sing_cursor.execute(request)
            for row in sing_cursor :
                for elem in single_fields :
                    if (row[elem] != "---") :
                        result[elem[3:]] = list([row[elem]])
        for cf in multiple_fields :
            mult_cursor = self.sql_cnx.cursor()
            mult_cursor.execute("SELECT value FROM bug_" + cf + " WHERE bug_id = %s", (str(bug_id)))
            result[cf[3:]] = list([])
            for row in mult_cursor :
                if (row['value'] != '---') :
                    result[cf[3:]].append(row['value'])
        return result

    def get_comments_by_id(self, bug_id) :
        result = list([])
        cursor = self.sql_cnx.cursor()
        cursor.execute("SELECT bug_when, thetext, who FROM longdescs WHERE bug_id = %s", (str(bug_id)))
        for row in cursor :
            comment = BzComment(time.mktime(row['bug_when'].timetuple())+1e-6*row['bug_when'].microsecond)
            comment.reporter = self.get_login_by_id(row['who'])
            comment.content = row['thetext']
            result.append(comment)
        return result
        
    def get_attachments_by_id(self, bug_id) :
        result = list([])
        cursor = self.sql_cnx.cursor()
        cursor.execute("SELECT attach_id, creation_ts, filename, isurl, submitter_id FROM attachments WHERE bug_id = %s", (str(bug_id),))
        for row in cursor :
            file_cursor = self.sql_cnx.cursor()
            file_cursor.execute("SELECT thedata FROM attach_data WHERE id = %s", (str(row['attach_id'])))
            attach = BzAttachment(row['filename'])
            attach.content = file_cursor.fetchone()['thedata']
            attach.reporter = self.get_login_by_id(row['submitter_id'])
            attach.created = time.mktime(row['creation_ts'].timetuple())+1e-6*row['creation_ts'].microsecond
            result.append(attach)
        return result

    def get_flags_by_id(self, bug_id) :
        result = set([])
        cursor = self.sql_cnx.cursor()
        cursor.execute("SELECT type_id FROM flags WHERE (bug_id = %s) AND (status = %s)", (str(bug_id), "+"))
        for row in cursor :
            flag_cursor = self.sql_cnx.cursor()
            flag_cursor.execute("SELECT name FROM flagtypes WHERE id = %s LIMIT 1", (str(row['type_id'])))
            result.add(flag_cursor.fetchone()['name'].encode('utf8'))
        return result

    def get_voters_by_id(self, bug_id) :
        result = set([])
        cursor = self.sql_cnx.cursor()
        cursor.execute("SELECT who FROM votes WHERE bug_id = %s", (str(bug_id),))
        for row in cursor :
            result.add(self.get_login_by_id(row['who']))
        return result

    def get_product_id_by_bug_id(self, bug_id) :
        cursor = self.sql_cnx.cursor()
        cursor.execute("SELECT product_id FROM bugs WHERE bug_id=%s LIMIT 1", (str(bug_id),))
        return cursor.fetchone()["product_id"]


    def get_product_id_by_name(self, name) :
        cursor = self.sql_cnx.cursor()
        cursor.execute("SELECT id, name FROM products")
        for row in cursor :
            if (row["name"].encode('utf8') == str(name)) :
                return row["id"]


    def get_product_names(self) :
        cursor = self.sql_cnx.cursor()
        cursor.execute("SELECT name FROM products")
        result = []
        for row in cursor :
            result.append(row["name"].encode('utf8'))
        return result
