CF_TYPES = dict([])
REPRODUCIBILITY = dict([])
PRIORITY = dict([])
SEVERITY = dict([])
STATUS = dict([])
RESOLUTION = dict([])
LINK_TYPES = dict([])
CREATE_CF_FOR_SUBPROJECT = True
CHARSET = "cp866"

class MantisUser(object) :

    def __init__(self, name) :
        self.user_name = name
        self.real_name = ""
        self.email = ""

class MantisIssue(object) :

    def __init__(self, id) :
        self.id = str(id)
        self.subproject_name = ""
        self.reporter_name = ""
        self.handler_name = ""
        self.priority = None
        self.severity = None
        self.reproducibility = None
        self.status = None
        self.resolution = None
        self.description = ""
        self.steps_to_reproduce = ""
        self.additional_information = ""
        self.os = ""
        self.os_build = ""
        self.platform = ""
        self.version = ""
        self.fixed_in_version = ""
        self.build = ""
        self.summary = ""
        self.target_version = ""
        self.category = ""
        self.date_submitted = None
        self.due_date = None
        self.last_updated = None
        self.cf_values = dict([])
        self.tags = []
        self.comments = []

class MantisCategory(object) :
    def __init__(self, name) :
        self.name = name
        self.assignee = None

class MantisVersion(object) :
    def __init__(self, name) :
        self.name = name
        self.is_released = True
        self.is_obsolete = False

class MantisCustomFieldDef(object) :
    def __init__(self, id) :
        self.name = None
        self.type = None
        self.values = []
        self.field_id = id
        self.default_value = None

class MantisComment(object) :
    def __init__(self) :
        self.reporter = ""
        self.date_submitted = None
        self.text = ""

class MantisIssueLink(object) :
    def __init__(self, source, target, type):
        self.source = source
        self.target = target
        self.source_project_id = None
        self.target_project_id = None
        self.type = type

class MantisAttachment(object):
    def __init__(self, id, cnx):
        self.id = id
        cursor = cnx.cursor()
        cursor.execute("SELECT * FROM mantis_bug_file_table WHERE id = %s" %(id,))
        row = cursor.fetchone()
        self.bug_id = row["bug_id"]
        project_id_cursor = cnx.cursor()
        project_id_cursor.execute("SELECT project_id FROM mantis_bug_table WHERE id=%s", (self.bug_id,))
        self.project_id = project_id_cursor.fetchone()["project_id"]
        self.title = row["title"]
        self.filename = row["filename"]
        self.file_type = row["file_type"]
        self.content = row["content"]
        self.user_id = row["user_id"]
        self.date_added = row["date_added"]
