import mantis

# maps the cf type in mantis with the cf type in yt
mantis.CF_TYPES = {
    0 : "string",     #String
    1 : "integer",    #Nimeric
    2 : "string",     #Float
    3 : "enum[1]",    #Enumeration
    4 : "string",     #Email
    5 : "enum[*]",    #Checkbox
    6 : "enum[1]",    #List
    7 : "enum[*]",    #Multiselection list
    8 : "date",       #Date
    9 : "enum[1]"     # Radio
}
# maps the int value from mantis db with its human readable representation
mantis.REPRODUCIBILITY = {
    10  : "Always",
    30  : "Sometimes",
    50  : "Random",
    70  : "Have not tried",
    90  : "Unable to reproduce",
    100 : "N/A"
}
# maps mantis priorities with yt priorities
mantis.PRIORITY = {
    10 : "0",         #none : Minor
    20 : "0",         #low : Minor
    30 : "1",         #normal : Normal
    40 : "2",         #high : Major
    50 : "3",         #urgent : Critical
    60 : "4"          #immidiate : Show-stoper
}
# maps the int value from mantis db with its human readable representation
mantis.SEVERITY = {
    10 : "Feature",
    20 : "Trivial",
    30 : "Text",
    40 : "Tweak",
    50 : "Minor",
    60 : "Major",
    70 : "Crash",
    80 : "Block"
}
# maps the int value from mantis db with its human readable representation
mantis.STATUS = {
    40 : "Verified"           #confirmed
}
# maps the int value from mantis db with its human readable representation
mantis.RESOLUTION = {
    10 : "Open",              #open
    20 : "Fixed",             #fixed
    30 : "Reopened",          #reopened
    40 : "Can't Reproduce",   #unable to reproduce
    50 : "Won't fix",         #not fixable
    60 : "Duplicate",         #duplicate
    70 : "Obsolete",          #no change required
    80 : "Incomplete",        #suspended
    90 : "Won't fix"          #won't fix
}

#maps mantis link types with yt link types
mantis.LINK_TYPES = {
    0 : "Duplicate",    #duplicate of
    1 : "Relates",      #related to
    2 : "Depend"        #parent of
}
# if this parameter is True custom field "Subproject" will be created,
# else all information about subproject will be lost
mantis.CREATE_CF_FOR_SUBPROJECT = True
# charset of your mantis database
CHARSET = "cp866"
  