from youtrack.connection import Connection
from mantis.mantisClient import MantisClient
from youtrack import *
from mantis import MantisCustomFieldDef
import time
import sys
import mantis
import mantis.defaultMantis
from StringIO import StringIO

def main() :
    try :
        target_url, target_login, target_pass, mantis_db, mantis_host, mantis_port, mantis_login, mantis_pass = sys.argv[1:9]
        mantis_product_names = sys.argv[9:]
    except :
        print "Not enough arguments to start execution"
    mantis2youtrack(target_url, target_login, target_pass, mantis_db, mantis_host,
                    mantis_port, mantis_login, mantis_pass, mantis_product_names)

def to_yt_user(mantis_user) :
    yt_user = User()
    yt_user.login = mantis_user.user_name
    yt_user.fullName = mantis_user.real_name
    yt_user.email = mantis_user.email
    return yt_user

def to_yt_subsystem(mantis_cat) :
    subsys = Subsystem()
    subsys.name = mantis_cat.name
    subsys.isDefault = False
    assignee = mantis_cat.assignee
    if (assignee is not None) :
        subsys.defaultAssignee = assignee
    else :
        subsys.defaultAssignee = ""
    return subsys

def to_yt_version(mantis_version) :
    yt_version = Version()
    yt_version.name = mantis_version.name
    yt_version.isReleased = mantis_version.is_released
    yt_version.isArchived = mantis_version.is_obsolete
    yt_version.releaseDate = str(int(time.time() * 1000))
    return yt_version

def to_yt_comment(mantis_comment) :
    yt_comment = Comment()
    yt_comment.author = mantis_comment.reporter
    yt_comment.text = mantis_comment.text
    yt_comment.created = str(int(mantis_comment.date_submitted * 1000))
    return yt_comment

def to_yt_issue(mantis_issue, date_fields) :
    issue = Issue()
    issue.numberInProject = mantis_issue.id
    issue.summary = mantis_issue.summary
    # description
    description = mantis_issue.description
    steps_to_reproduce = mantis_issue.steps_to_reproduce
    if ((steps_to_reproduce is not None) and (len(steps_to_reproduce.strip()) > 0)) :
        description = description + "\n Steps to reproduce : \n" + steps_to_reproduce
    additional = mantis_issue.additional_information
    if ((additional is not None) and (len(additional.strip()) > 0)) :
        description = description + "\n Additional information : \n" + additional
    issue.description = description
    issue.created = str(int(mantis_issue.date_submitted * 1000))
    issue.updated = str(int(mantis_issue.last_updated * 1000))
    issue.reporterName = mantis_issue.reporter_name
    issue.assigneeName = mantis_issue.handler_name
    if (mantis_issue.severity == 10) :
        issue.type = "feature"
    else :
        issue.type = "bug"
    issue.priority = mantis.PRIORITY[mantis_issue.priority]
    issue_status = mantis_issue.status
    if (issue_status in mantis.STATUS) :
        issue.state = mantis.STATUS[issue_status]
    else :
        issue.state = mantis.RESOLUTION[mantis_issue.resolution]
    issue.subsystem = mantis_issue.category
    affected_version = mantis_issue.version
    if (affected_version != "") :
        issue.affectsVersion = affected_version
    fixed_version = mantis_issue.fixed_in_version
    if (fixed_version != "") :
        issue.fixedVersion = fixed_version
    issue.fixedInBuild = mantis_issue.build
    issue.comments = []
    for c in mantis_issue.comments :
        issue.comments.append(to_yt_comment(c))
    #Custom fields
    issue["Severity"] = mantis.SEVERITY[mantis_issue.severity]
    issue["Reproducibility"] = mantis.REPRODUCIBILITY[mantis_issue.reproducibility]
    issue["Platform"] = mantis_issue.platform
    issue["OS"] = mantis_issue.os
    issue["OS version"] = mantis_issue.os_build
    if (mantis.CREATE_CF_FOR_SUBPROJECT) :
        issue["Subproject"] = mantis_issue.subproject_name
    for cf_name in mantis_issue.cf_values :
        value = mantis_issue.cf_values[cf_name]
        if (value != "") :
            if (cf_name in date_fields) :
                issue[cf_name] = str(int(value) * 1000)
            else  :
                issue[cf_name] = value
    return issue

def get_bundle_name_for_custom_field(mantis_cf) :
    return "enum_" + str(mantis_cf.field_id)

def to_yt_link(mantis_link):
    link = Link()
    link.source = "%s-%s" % (mantis_link.source_project_id, mantis_link.source)
    link.target = "%s-%s" % (mantis_link.target_project_id, mantis_link.target)
    link.typeName = mantis.LINK_TYPES[mantis_link.type]
    return link


def mantis2youtrack(target_url, target_login, target_pass, mantis_db_name, mantis_db_host,  mantis_db_port,
                    mantis_db_login, mantis_db_pass, mantis_project_names) :
    print "target_url             : " + target_url
    print "target_login           : " + target_login
    print "target_pass            : " + target_pass
    print "mantis_db_name         : " + mantis_db_name
    print "mantis_db_host         : " + mantis_db_host
    print "mantis_db_port         : " + mantis_db_port
    print "mantis_db_login        : " + mantis_db_login
    print "mantis_db_pass         : " + mantis_db_pass
    print "mantis_project_names   : " + repr(mantis_project_names)

    #connacting to yt
    target = Connection(target_url,target_login, target_pass)
    #connacting to mantis
    client = MantisClient(mantis_db_host, int(mantis_db_port), mantis_db_login,
                          mantis_db_pass, mantis_db_name, mantis.CHARSET)
    if (len(mantis_project_names) == 0) :
        print "You should declarer at least one project to import"
        exit()

    print "Importing users"
    yt_users = []
    for user in client.get_mantis_users() :
        print "Processing user [ %s ]" % user.user_name
        yt_users.append(to_yt_user(user))
    target.importUsers(yt_users)
    print "Importing users finished"

    print "Creating custom fields definitions"
    # adding some custom fields that are predefined in mantis
    project_ids = []
    for name in mantis_project_names :
        project_ids.append(client.get_project_id_by_name(name))

    custom_fields = client.get_mantis_custom_fields(project_ids)
    mantis_predefined_fields = []
    #reproducibility
    rep_cf = MantisCustomFieldDef("repr")
    rep_cf.default_value = unicode("Have not tried")
    rep_cf.values = mantis.REPRODUCIBILITY.values()
    rep_cf.type = 6
    rep_cf.name = "Reproducibility"
    mantis_predefined_fields.append(rep_cf)
    #severity
    sever_cf = MantisCustomFieldDef("sever")
    sever_cf.default_value = unicode("Minor")
    sever_cf.type = 6
    sever_cf.name = "Severity"
    sever_cf.values = mantis.SEVERITY.values()
    mantis_predefined_fields.append(sever_cf)
    #platform
    platform_cf = MantisCustomFieldDef("Platform")
    platform_cf.type = 0
    platform_cf.name = "Platform"
    platform_cf.default_value = unicode("Undifined")
    mantis_predefined_fields.append(platform_cf)
    #os
    os_cf = MantisCustomFieldDef("OS")
    os_cf.type = 0
    os_cf.name = "OS"
    os_cf.default_value = unicode("Undefined")
    mantis_predefined_fields.append(os_cf)
    #os_version
    os_version_cf = MantisCustomFieldDef("version")
    os_version_cf.type = 0
    os_version_cf.name = "OS version"
    os_version_cf.default_value = unicode("Undefined")
    mantis_predefined_fields.append(os_version_cf)
    custom_fields.extend(mantis_predefined_fields)

    date_fields = []

    for cf_def in custom_fields :
        print "Processing custom field [ %s ]" % cf_def.name
        cf_type = mantis.CF_TYPES[cf_def.type]
        if (cf_def.type == 8) :
                date_fields.append(cf_def.name)
        if (cf_type in ["enum[1]", "enum[*]"]) :
            bundle_name = get_bundle_name_for_custom_field(cf_def)
            try :
                print "Creating enum bundle with name [ %s ]" % bundle_name
                target.createEnumBundleDetailed(bundle_name, cf_def.values)
            except :
                print "Can't create enum bundle with name [ %s ] (maybe because it already exists)" % bundle_name
        try :
            target.createCustomFieldDetailed(cf_def.name, cf_type, False, True)
        except :
            print "Can't create prototype for custom field [ %s ] (maybe because it already exists)" % (cf_def.name)

    if (mantis.CREATE_CF_FOR_SUBPROJECT) :
        try :
            target.createCustomFieldDetailed("Subproject", "enum[1]", False, True)
        except :
            print "Can't create prototype for custom field [ Subproject ] (maybe because it already exists)"
    #importing type cf if needed

#    contains_type = False
#    for cf in target.getProjectCustomFields(project_id) :
#        if (cf.name == "Type") :
#            contains_type = True
#            break
#    if (not(contains_type)) :
#        print "Custom field Type is not attached to project"
#        try :
#            target.createEnumBundleDetailed("DefaultTypes", ["Bug", "Feature"])
#        except :
#            print "Enum bundle with name [ DefaultTypes ] already exists"
#        try :
#            target.createCustomFieldDetailed("Type", "enum[1]", False, True)
#        except :
#            print "Prototype for custom field [ Type ] already exists"
#        target.createProjectCustomFieldDetailed(project_id, "Type", "Bug", params={"bundle" : "DefaultTypes"})

    print "Creating custom fields definitions finished"

    for name in mantis_project_names :
        project_id = int(client.get_project_id_by_name(name))
        print "Creating project [ %s ] with name [ %s ]" % (project_id, name)
        try :
            target.getProject(str(project_id))
        except :
            target.createProjectDetailed(str(project_id), name, client.get_project_description(project_id), target_login)

        print "Importing components to project [ %s ]" % project_id
        for category in client.get_mantis_categories(project_id) :
            print "Processing category [ %s ]" % category.name
            try :
                target.createSubsystem(str(project_id), to_yt_subsystem(category))
            except :
                print "Can't create subsystem with name [ %s ] in project [ %s ] (maybe because it already exists)" % (category.name, project_id)
        print "Importing components to projext [ %s ] finished" % project_id

        print "Importing versions to project [ %s ]" % project_id
        for version in client.get_mantis_versions(project_id) :
            print "Processing version [ %s ]" % version.name
            try :
                target.createVersion(str(project_id), to_yt_version(version))
            except :
                print "Can't create version with name [ %s ] in project [ %s ] (maybe because it already exists)" % (version.name, project_id)
        print "Importing versions to project [ %s ] finished" % project_id

        print "Attaching custom fields to project [ %s ]" % project_id
        cf_ids = client.get_custom_fields_attached_to_project(project_id)

        for cf in custom_fields :
            if ((cf.field_id in cf_ids) or (cf in mantis_predefined_fields)) :
                bundle_name = None
                if (mantis.CF_TYPES[cf.type] in ["enum[1]", "enum[*]"]) :
                    bundle_name = get_bundle_name_for_custom_field(cf)
                try :
                    target.createProjectCustomFieldDetailed(str(project_id), cf.name, cf.default_value, params = {"bundle" : bundle_name})
                except :
                    print "Can't attach custom field [ %s ] to project [ %s ] (maby because it was already attached)" % (cf.name, project_id)
        if (mantis.CREATE_CF_FOR_SUBPROJECT) :
            bundle_name = "project_%s_subprojects" % project_id
            bundle_values = client.get_mantis_subprojects(project_id)
            try :
                print 'Creating enum bundle with name [ %s ]' % bundle_name
                target.createEnumBundleDetailed(bundle_name, bundle_values)
            except :
                print "Can't create enum bundle with name [ %s ] (maybe because it already exists)" % bundle_name
            try :
                target.createProjectCustomFieldDetailed(str(project_id), "Subproject", "General", params = {"bundle" : bundle_name})
            except :
                print "Can't attach custom field [ Subproject ] to project [ %s ] (maby because it was already attached)" % project_id
        print "Attaching custom fields to project [ %s ] finished" % project_id


        print "Importing issues to project [ %s ]" % project_id
        mantis_issues = client.get_mantis_issues(project_id)
        yt_issues = []
        max_count = 100
        for issue in mantis_issues  :
            print "Processing issue [ %s ]" % str(issue.id)
            yt_issues.append(to_yt_issue(issue, date_fields))
            if (len(yt_issues) >= max_count) :
                print target.importIssues(str(project_id), name + "Assignees", yt_issues)
                yt_issues = []
        print target.importIssues(str(project_id), name + "Assignees", yt_issues)
        print "Importing issues to project [ %s ] finished" % project_id

        print "Importing issue attachments to project [ %s ]" % project_id
        mantis_attachments = client.get_mantis_attachments(project_id)
        for attachment in mantis_attachments  :
            print "Processing issue attachment [ %s ]" % str(attachment.id)
            content = StringIO(attachment.content)
            authorLogin = client.get_user_name_by_id(attachment.user_id)
            target.createAttachment("%s-%s" %(project_id,attachment.bug_id),attachment.filename, content, authorLogin, attachment.file_type,None,
                                    str(attachment.date_added * 1000))
        print "Importing issue attachments to project [ %s ] finished" % project_id

        print "Importing tags to issues from project [ %s ]" % project_id
        for issue in mantis_issues :
            print "Processing tags for issue [ %s ]" % str(issue.id)
            for tag in issue.tags :
                print "Processing tag [ %s ]" % tag.encode('utf8')
                target.executeCommand(str(project_id) + "-" + str(issue.id), "tag " + tag.encode('utf8'))
        print "Importing tags to issues from project [ %s ] finished" % project_id

    print "Importing issue links"
    mantis_issue_links = client.get_issue_links()
    yt_issue_links = []
    for link in mantis_issue_links  :
        print "Processing issue link for source issue [ %s ]" % str(link.source)
        yt_issue_links.append(to_yt_link(link))
    print target.importLinks(yt_issue_links)
    print "Importing issue links finished"




if __name__ == "__main__":
    main()