import random
import unittest
from youtrack.connection import Connection, youtrack, os, os
import math

class ConnectionTest(unittest.TestCase):

    con = Connection

    def setUp(self):
        self.con = Connection('http://teamsys.intellij.net', 'resttest', 'resttest')

    def test_getProject(self):
        p = self.con.getProject('SB')
        self.assertEqual(p.id, 'SB')
        self.assertEqual(p.name, 'Sandbox')

    def test_getSubsystems(self):
        subsystems = self.con.getSubsystems('SB')
        default = [s for s in subsystems if s.isDefault][0]
        self.assertTrue(default is not None)        

    def test_getIssue(self):
        i = self.con.getIssue('SB-1')
        self.assertEqual(i.id, 'SB-1')
        self.assertEqual(i.numberInProject, '1')
        self.assertEqual(i.projectShortName, 'SB')

    def test_getEnumBundle(self):
        b = self.con.getEnumBundle('OS')
        self.assertEqual(b.name, 'OS')

    def test_createEnumBundle(self):
        eb = youtrack.EnumBundle()
        name = 'Test Enum ' + str(random.random())
        eb.name = name
        eb.values = ['e1', 'e2']
        self.con.createEnumBundle(eb)

        b = self.con.getEnumBundle(name)
        self.assertEqual(b.name, name)
        self.assertEqual(b.values, ['e1', 'e2'])

        self.con.deleteEnumBundle(name)

    def test_createIssue(self):
        i = self.con.createIssue('SB', 'resttest', 'Test issue', 'Test description', '2', 'Bug', 'First', 'Open', '', '', '')
        self.assertEqual(i.projectShortName, 'SB')
        self.assertEqual(i.priority, '2')
        self.assertEqual(i.type, 'Bug')
        self.assertEqual(i.subsystem, 'First')

    def test_createIssueAttachment(self):
        i = self.con.createIssue('SB', 'resttest', 'For attachmkents test', 'Test description', '2', 'Bug', 'First', 'Open', '', '', '')
        fname = 'connection_test.py'
        content = open(fname)
        self.con.createAttachment(i.id, fname, content)
        self.assertEqual(fname, self.con.getAttachments(i.id)[0].name)

    def test_createAndDeleteSubsystem(self):
        name = 'Test Subsystem [' + str(random.random()) + "]"
        self.con.createSubsystemDetailed('SB', name, False, 'resttest')
        s = self.con.getSubsystem('SB', name)
        self.assertEqual(s.name, name)
        self.assertEqual(s.isDefault, 'false')
        #todo: uncomment when fix deployed to teamsys
        #self.assertEqual(s.defaultAssignee, 'resttest')
        self.con.deleteSubsystem('SB', name)

if __name__ == '__main__':
    unittest.main()
