from trac.db.api import *
from youtrack.connection import Connection
from tracLib.client import Client
import youtrack
import sys
import tracLib.defaultTrac
from tracLib import TracCustomFieldDeclaration

def main() :
    try :
        target_url, target_login, target_password, project_ID, project_name, env_path = sys.argv[1:]
        print "url                  : " + target_url
        print "login                : " + target_login
        print "pass                 : " + target_password
        print "id                   : " + project_ID
        print "name                 : " + project_name
        print "trac environment at  : " + env_path
    except BaseException, e :
        print e
        return
    trac2youtrack(target_url, target_login, target_password, project_ID, project_name, env_path)

def to_youtrack_user(trac_user) :
    user = youtrack.User()
    user.login = trac_user.name
    user.email = tracLib.DEFAULT_EMAIL
    if not (trac_user.email is None):
        if (len(trac_user.email) != 0):
            user.email = trac_user.email
    return user

def to_non_authorised_youtrack_user(user_name):
    user = youtrack.User()
    # non authorized users in trac are stored like this "name <email_address>"
    start = user_name.find("<")
    end = user_name.rfind(">")
    # we don't accept users who didn't leave the email
    if ((start > -1) and (end > start + 1)):
        if (user_name.find("@", start, end) > 0):
            user.email = user_name[start + 1 : end].replace(" ", "_")
            user.login = user_name[start + 1 : end].replace(" ", "_")
            return user
    return None

def to_youtrack_subsystem(trac_component) :
    yt_subsystem = youtrack.Subsystem()
    yt_subsystem.name = trac_component.name
    # no subsystem is set as default
    yt_subsystem.isDefault = False
    yt_subsystem.defaultAssignee = trac_component.owner
    return yt_subsystem

def to_youtrack_issue(trac_issue, check_box_fields) :
    issue = youtrack.Issue()
    issue.numberInProject = str(trac_issue.id)    
    issue.summary = trac_issue.summary
    issue.description = trac_issue.description
    if (trac_issue.time > 0):
        issue.created = str(trac_issue.time)
    if (trac_issue.changetime > 0):
        issue.updated = str(trac_issue.changetime)
    # anonymous in trac == guest in youtrack
    if (trac_issue.reporter == "anonymous"):
        issue.reporterName = "guest"
    else:
        issue.reporterName = trac_issue.reporter
    # "somebody means that there is no owner
    if (trac_issue.owner == "somebody"):
        issue.assigneeName = ""
    else:
        issue.assigneeName = trac_issue.owner
    if (trac_issue.type in tracLib.TYPES):
        #issue.type = tracLib.TYPES[trac_issue.type]
        issue.type = tracLib.TYPES[trac_issue.type]
    else:
        issue.type = trac_issue.type
#        print "You should declare mapping between trac and youtrack issue types (see defaultTrac.py)"
#        print "type    :    " + trac_issue.type
#        exit()
    if (trac_issue.priority in tracLib.PRIORITIES):
        issue.priority = tracLib.PRIORITIES[trac_issue.priority]
    else:
        print "You should declare mapping between trac and youtrack issue priorities (see defaultTrac.py)"
        print "priority    :    " + trac_issue.priority
        exit()
    if (trac_issue.resolution in tracLib.RESOLUTIONS):
        issue.state = tracLib.RESOLUTIONS[trac_issue.resolution]
    elif (trac_issue.status in tracLib.STATES):
        issue.state = tracLib.STATES[trac_issue.status]
    else:
        print "You should declare mapping between trac statuses and resolutions and youtrack issue states (see defaultTrac.py)"
        print "resolution    :    " + trac_issue.resolution + "        statis    :    " + trac_issue.status
        exit()
    issue.subsystem = trac_issue.component
    version = trac_issue.version
    if (version is not None):
        if (len(version) > 0):
            #issue.affectsVersion = trac_issue.version
            issue.fixedVersion = trac_issue.version
    #watchers
    issue.watcherName = set([])
    for cc in trac_issue.cc:
        issue.watcherName.add(cc)
    #adding custom fields to issue
    if (trac_issue.severity is not None):
        issue["severity"] = trac_issue.severity
    custom_fields = trac_issue.custom_fields
    for cf in custom_fields:
        if (cf in check_box_fields):
            if (custom_fields[cf] != "0"):
                issue[cf] = check_box_fields[cf]
        else:
            issue[cf] = custom_fields[cf]
#    issue.fixedInBuild = trac_issue.version
    issue.comments = []
    for comment in trac_issue.comments:
        issue.comments.append(to_youtrack_comment(comment))
    return issue

def to_youtrack_version(trac_version):
    version = youtrack.Version()
    version.name = trac_version.name
    version.isReleased = True
    version.isArchived = False
    version.description = trac_version.description
    version.releaseDate = trac_version.time
    return version

def to_youtrack_comment(trac_comment):
    comment = youtrack.Comment()
    if (trac_comment.author == "anonymous"):
        comment.author = "guest"
    else:
        comment.author = trac_comment.author
    comment.text = trac_comment.content
    comment.created = trac_comment.time
    return comment

def trac2youtrack(target_url, target_login,target_password, project_ID, project_name, env_path):
    # creating connection to trac to import issues to
    client = Client(env_path)
    # creating connection to youtrack to import issues in
    target = Connection(target_url, target_login, target_password)

    #create project
    print "Creating project[%s]" % (project_name)
    try :
        target.getProject(project_ID)
    except :
        target.createProjectDetailed(project_ID, project_name, client.get_project_description(), target_login)

    #importing users
    trac_users = client.get_users()
    print "Importing users"
    yt_users = list([])
    # converting trac users to yt users
    registered_users = set([])
    for user in trac_users :
        print "Processing user [ %s ]" % (user.name)
        registered_users.add(user.name)
        yt_users.append(to_youtrack_user(user))
    # adding users to yt project
    target.importUsers(yt_users)
    print "Importing users finished"



    print "Importing components"
    trac_components = client.get_components()
    yt_subsystem_names = set([])
    for subsystem in target.getSubsystems(project_ID):
        yt_subsystem_names.add(subsystem.name)
    for cmp in trac_components:
        print "Processing compomemt [ %s ]" % (cmp.name)
        if not (cmp.owner in registered_users):
            if (tracLib.ACCEPT_NON_AUTHORISED_USERS):
                yt_user = to_non_authorised_youtrack_user(cmp.owner)
                if (yt_user is None):
                    cmp.owner = ""
                else:
                    if not (yt_user.login in registered_users):
                        target.importUsers([yt_user])
                        registered_users.add(yt_user.login)
                    cmp.owner = yt_user.login
            else:
                cmp.owner = ""
        subsystem = to_youtrack_subsystem(cmp)
        if (subsystem.name in yt_subsystem_names):
            target.deleteSubsystem(project_ID, subsystem.name)
        target.createSubsystem(project_ID, subsystem)
    print "Importing components finished"

    print "Importing versions"
    trac_versions = client.get_versions()
    for version in trac_versions:
        print "Priocessing version [ %s ]" % (version.name)
        target.createVersion(project_ID, to_youtrack_version(version))
    print "Importing versions finished"

    print "Creating project custom fields"

    existing_custom_fields = target.getCustomFields()
    trac_types = client.get_issue_types()
    contains_type = False
    bundle_name = "DefaultTypes_enum_" + str(project_name)
    for cf in existing_custom_fields:
        if (cf.name == "Type"):
            # !!! IF YOU DON"T USE "DefaultTypes" FOR TYPE FIELD
            # YOU SHOULD  DECLARE IT IN THE LINE BELOW
            # INSTEAD OF "DefaultTypes"
            bundle_name = "DefaultTypes"
            contains_type = True
    if not contains_type:
        target.createEnumBundleDetailed(bundle_name, [])
        types_enum = target.getEnumBundle(bundle_name)
        target.createCustomFieldDetailed("Type", "enum[1]", False, True)
        target.createProjectCustomFieldDetailed(project_ID, "Type", "No type", {"bundle" : bundle_name})
    else:
        types_enum = target.getEnumBundle(bundle_name)
    for t in trac_types:
        if not (t in tracLib.TYPES):
            if not (t in types_enum.values):
                target.addValueToEnumBundle(types_enum.name, t)
        else:
            if not (tracLib.TYPES[t] in types_enum.values):
                target.addValueToEnumBundle(types_enum.name, tracLib.TYPES[t])


    trac_severities = client.get_severities()
    trac_custom_fields = client.get_custom_fields_declared()
    if (len(trac_severities) > 0):
        sev_field = TracCustomFieldDeclaration("severity")
        sev_field.label = "severity"
        sev_field.type = "select"
        sev_field.value = trac_severities[1]
        for s in trac_severities:
            sev_field.options.append(s)
        trac_custom_fields.append(sev_field)

    check_box_fields = dict([])

    for elem in trac_custom_fields:
        print "Processing custom field [ %s ]" % (elem.name)
        #creating enum for custom field if needed
        type_name = None
        if (elem.type == "checkbox"):
            if (len(elem.label) > 0):
                opt = elem.label
            else:
                opt = elem.name
            options = list([opt])
            check_box_fields[elem.name] = opt
        else:
            options = elem.options
        if (len(options) > 0):
            #this field has predefined values, so we create enum
            type_name = elem.name + "_enum_" + str(project_name)
            target.createEnumBundleDetailed(type_name, options)
        try :
            target.createCustomFieldDetailed(elem.name, tracLib.CUSTOM_FIELD_TYPES[elem.type], False, True)
        except BaseException, e:
            print "Protorype for custom field %s already exists" % (elem.name)            
        target.createProjectCustomFieldDetailed(project_ID, elem.name, "No " + elem.label, params={'bundle': type_name})
    print "Creating project custom fields finished"

    print "Importing issues"
    trac_issues = client.get_issues()
    yt_issues = list([])
    counter = 0
    max = 100
    for issue in trac_issues:
        print "Processing issue [ %s ]" % (str(issue.id))
        counter = counter + 1
        if not (issue.reporter in registered_users):
            if (tracLib.ACCEPT_NON_AUTHORISED_USERS):
                yt_user = to_non_authorised_youtrack_user(issue.reporter)
                if (yt_user is None):
                    issue.reporter = "guest"
                else:
                    if not (yt_user.login in registered_users):
                        target.importUsers([yt_user])
                        registered_users.add(yt_user.login)
                    issue.reporter = yt_user.login
            else:
                issue.reporter = "guest"
        if not (issue.owner in registered_users) :
            if (tracLib.ACCEPT_NON_AUTHORISED_USERS):
                yt_user = to_non_authorised_youtrack_user(issue.owner)
                if (yt_user is None):
                    issue.owner = ""
                else:
                    if not (yt_user.login in registered_users):
                        target.importUsers([yt_user])
                        registered_users.add(yt_user.login)
                    issue.owner = yt_user.login
            else:
                issue.owner = ""
        legal_cc = set([])
        for cc in issue.cc:
            if (cc in registered_users):
                legal_cc.add(cc)
        issue.cc = legal_cc

        yt_issues.append(to_youtrack_issue(issue, check_box_fields))
        if (counter == max):
            counter = 0
            print target.importIssues(project_ID, project_name + ' Assignees', yt_issues)
            yt_issues = list([])
            users_to_register = set([])
    print target.importIssues(project_ID, project_name + ' Assignees', yt_issues)
    print 'Importing issues finished'
    #importing tags
    print "Importing keywords"
    for issue in trac_issues:
        print "Importing tags from issue [ %s ]" % (str(issue.id))
        tags = issue.keywords
        for t in tags:
            target.executeCommand(str(project_ID) + "-" + str(issue.id), "tag " + t)
    print "Importing keywords finished"

    print "Importing attachments"
    for issue in trac_issues:
        print "Processing issue [ %s ]" % (str(issue.id))
        issue_attach = issue.attachment
        for attach in issue_attach:
            print "Processing attachment [ %s ]" % (attach.filename)
            if not (attach.author_name in registered_users):
                if (tracLib.ACCEPT_NON_AUTHORISED_USERS):
                    yt_user = to_non_authorised_youtrack_user(attach.author_name)
                    if (yt_user is None):
                        attach.author_name = "guest"
                    else:
                        if not (yt_user.login in registered_users):
                            target.importUsers([yt_user])
                        attach.author_name = yt_user.login
                else:
                    attach.author_name = "guest"
            content = open(attach.filename)
            target.createAttachment(str(project_ID) + "-" + str(issue.id), attach.filename, content, attach.author_name,
                                    created=attach.time, group = None)
    print "Importing attachments finished"

  

if __name__ == "__main__":
    main()

    
    