from trac.env import Environment
from tracLib import *
from ConfigParser import ConfigParser
import trac.util.datefmt


class Client(object):
    
    def __init__(self, env_path):
        self.env_path = env_path
        self.env = Environment(env_path)
        self.db_cnx = self.env.get_db_cnx()

    def get_project_description(self):
        return self.env.project_description

    def get_users(self):
        result = self.env.get_known_users()
        trac_users = list([])
        for user in result:
            u = TracUser(user[0])
            u.password = user[1] 
            u.email = user[2]
            trac_users.append(u)
            # ??? get permissions

        return trac_users

    def get_severities(self):
        cursor = self._get_data_from_enum("severity")
        result = list([])
        for row in cursor:
            result.append(row[0])
        return result


    def get_issue_types(self):
        cursor = self._get_data_from_enum("ticket_type")
        trac_issue_types = list([])
        for row in cursor:
            trac_issue_types.append(row[0])
#            type = TracIssueType(row[0])
#            if (row[1] is not None):
#                type.value = row[1]
#            trac_issue_types.append(type)
        return trac_issue_types

    def get_issue_priorities(self):
        cursor = self._get_data_from_enum("priority")
        trac_issue_priorities = list([])
        for row in cursor:
            priority = TracIssuePriority(row[0])
            if (row[1] is not None):
                priority.value = row[1]
            trac_issue_priorities.append(priority)
        return trac_issue_priorities

    def get_issue_statuses(self):
        cursor = self._get_data_from_enum("status")
        trac_issue_statuses = list([])
        for row in cursor:
            status = TracIssueStatus(row[0])
            if (row[1] is not None):
                status.value = row[1]
            trac_issue_statuses.append(status)
        return trac_issue_statuses

    def get_components(self):
        cursor = self.db_cnx.cursor()
        cursor.execute("SELECT name, owner, description FROM component")
        trac_components = list([])
        for row in cursor:
            component = TracComponent(row[0])
            if (row[1] is not None):
                component.owner = row[1]
            if (row[2] is not None):
                component.description = row[2]
            trac_components.append(component)
        return trac_components   

    def get_versions(self):
        cursor = self.db_cnx.cursor()
        cursor.execute("SELECT name, time, description FROM version")
        trac_versions = list([])
        for row in cursor:
            version = TracVersion(row[0])
            if (row[1] != 0):
                version.time = row[1] * 1000
            if (row[2] is not None):
                version.description = row[2]
            trac_versions.append(version)
        return trac_versions
                
    def get_issues(self):
        cursor = self.db_cnx.cursor()
        cursor.execute("SELECT id, type, time, changetime, component, severity, priority, owner, reporter,"
                       "cc, version, status, resolution, summary, description, keywords FROM ticket")
        trac_issues = list([])
        for row in cursor:
            issue = TracIssue(row[0])
            issue.type = row[1]
            issue.time = row[2] * 1000
            issue.changetime = row[3] * 1000
            issue.component = row[4]
            issue.severity = row[5]
            issue.priority = row[6]
            issue.owner = row[7]
            issue.reporter = row[8]
            cc = row[9].split(",")
            for c in cc:
                if (len(c) > 0):
                    issue.cc.add(c.strip())
            issue.version = row[10]
            issue.status = row[11]
            issue.resolution = row[12]
            issue.summary = row[13]
            issue.description = row[14]
            keywords = row[15].rsplit(",")
            for kw in keywords:
                if (len(kw) > 0):
                    issue.keywords.add(kw.strip())
            #getting custom fields from ticket_custom table
            custom_field_cursor = self.db_cnx.cursor()
            custom_field_cursor.execute("SELECT name, value FROM ticket_custom WHERE ticket=%s", (str(row[0]),))
            for cf in custom_field_cursor:
                issue.custom_fields[cf[0]] = cf[1]
            # getting attachments from attachment table
            attachment_cursor = self.db_cnx.cursor()
            attachment_cursor.execute("SELECT filename, size, time, description, author FROM attachment WHERE "
                                      "type = %s AND id = %s", ("ticket", str(issue.id)))
            path = self.env_path + "/attachments/ticket/" + str(issue.id) + "/"
            for elem in attachment_cursor:
                at = TracAttachment(path + elem[0])
                at.name = elem[0]
                at.size = elem[1]
                at.time = elem[2] * 1000
                at.description = elem[3]
                at.author_name = elem[4]
                issue.attachment.add(at)
            trac_issues.append(issue)
            #getting comments
            change_cursor = self.db_cnx.cursor()
            change_cursor.execute("SELECT time, author, newvalue, oldvalue FROM ticket_change WHERE ticket = %s AND field = %s ORDER BY time DESC", (str(row[0]), "comment",))
            for elem in change_cursor:
                if (len(elem[2]) == 0):
                    continue
                comment = TracComment(elem[0] * 1000)
                comment.author = str(elem[1])
                comment.content = str(elem[2])
                comment.id = elem[3]
                issue.comments.add(comment)
                print "author : " + str(elem[1]) + "   newvalue : " + str(elem[2])
        return trac_issues


    def get_custom_fields_declared(self):
        ini_file_path = self.env_path + "/conf/trac.ini"
        parser = ConfigParser()
        parser.read(ini_file_path)
        if not("ticket-custom" in parser.sections()):
              return set([])
        result = parser.items("ticket-custom")
        items = dict([])
        for elem in result:
            items[elem[0]] = elem[1]

        keys = items.keys()
        custom_fields = list([])
        for k in keys:
            if not("." in k):
                field = TracCustomFieldDeclaration(k)
                field.type = items[k]
                options_key = k + ".options"
                if (options_key in items):
                    opts_str = items[options_key]
                    opts = opts_str.rsplit("|")
                    for o in opts:
                        field.options.append(o)
                value_key = k + ".value"
                if (value_key in items):
                    field.value = items[value_key]
                label_key = k + ".label"
                if (label_key in items):
                    field.label = items[label_key]
                custom_fields.append(field)

        return custom_fields

        

    def _get_data_from_enum(self, type_name):
        cursor = self.db_cnx.cursor()
        cursor.execute("SELECT name, value FROM enum WHERE type=%s", (type_name,))
        return cursor

