import tracLib

#if you defined your own types you should add them to the map
tracLib.TYPES = {
    "defect"        :   "Bug",
    "enhancement"   :   "Feature",
    "task"          :   "Task",
}

#if you defined your own priorities you should add them to the map
tracLib.PRIORITIES = {
    "trivial"       :   "0",        #Minor
    "minor"         :   "1",        #Normal
    "major"         :   "2",        #Major
    "critical"      :   "3",        #Critical
    "blocker"       :   "4"         #Show-stopper
}
#we convert resolutions and statuses into statuses
tracLib.RESOLUTIONS = {
    "duplicate"     :   "Duplicate",
    "fixed"         :   "Fixed",
    "wontfix"       :   "Won't fix",
    "worksforme"    :   "Can't Reproduce",
    "invalid"       :   "Can't Reproduce"
    #   :   "To be discussed
}
tracLib.STATES = {
    "accepted"      :   "Submitted",
    "new"           :   "Open",
    "reopened"      :   "Reopened",
    "assigned"      :   "Submitted"
}

# if you don't change rules of importing, don't change this map
tracLib.CUSTOM_FIELD_TYPES = {
    "text"          :   "string",
    "checkbox"      :   "enum[*]",
    "select"        :   "enum[1]",
    "radio"         :   "enum[1]",
    "teaxtarea"     :   "string"
}

# the default email to register users who doesn't have one
tracLib.DEFAULT_EMAIL = "anna.zhdan@gmail.com"
# if true users who were not authorized are registered
# else they are known as guests
tracLib.ACCEPT_NON_AUTHORISED_USERS = True


