import os.path
import httplib2
from xml.dom import minidom
import youtrack
from xml.dom import Node
import urllib2
import urllib
from xml.sax.saxutils import escape, quoteattr
import urllib2_file

class Connection(object):
    def __init__(self, url, login, password, proxy_info = None):
        self.http = httplib2.Http() if proxy_info is None else httplib2.Http(proxy_info = proxy_info)
        self.url = url
        self.baseUrl = url + "/rest"
        self._login(login, password)

    def _login(self, login, password):
        response, content = self.http.request(
                self.baseUrl + "/user/login?login=" + login + "&password=" + password, 'POST',
                headers = {'Content-Length':'0'})
        if response.status != 200:
            raise youtrack.YouTrackException('/user/login', response, content)    
        self.headers = {'Cookie': response['set-cookie'],
                        'Cache-Control': 'no-cache'}

        #print response
        

    def _req(self, method, url, body=None, ignoreStatus=None):
        headers = self.headers

        if method == 'PUT' or method == 'POST':
            headers = headers.copy()
            headers['Content-Type'] = 'application/xml; charset=UTF-8'
            headers['Content-Length'] = str(len(body)) 

        response, content = self.http.request(self.baseUrl + url, method, headers=headers, body=body)
        if response.status != 200 and response.status != 201 and (ignoreStatus != response.status):
            raise youtrack.YouTrackException(url, response, content)

        #print response

        return (response, content)

    def _reqXml(self, method, url, body=None, ignoreStatus=None):
        response, content = self._req(method, url, body, ignoreStatus)
        if response.has_key('content-type'):
            if (response["content-type"].find('application/xml') != -1 or response["content-type"].find('text/xml') != -1) and content is not None and content != '':
                    return minidom.parseString(content)

        if method == 'PUT' and hasattr(response, 'location'):
            return 'Created: ' + response['location']
        else:
            return content

    def _get(self, url):
        return self._reqXml('GET', url)

    def _put(self, url):
        return self._reqXml('PUT', url, '<empty/>\n\n')

    def getIssue(self, id):
        return youtrack.Issue(self._get("/issue/" + id), self)

    def createIssue(self, project, assignee, summary, description, priority, type, subsystem, state, affectsVersion, fixedVersion, fixedInBuild):
        return youtrack.Issue(self._reqXml('POST', '/issue?' +
                            urllib.urlencode({
                                'project': project,
                                'assignee': assignee,
                                'summary': summary,
                                'description': description,
                                'priority': priority,
                                'type': type,
                                'subsystem': subsystem,
                                'state': state,
                                'affectsVersion': affectsVersion,
                                'fixedVersion': fixedVersion,
                                'fixedInBuild': fixedInBuild}), ''))        

    def getComments(self, id):
        response, content = self._req('GET', '/issue/' + id + '/comment')
        xml = minidom.parseString(content)
        return [youtrack.Comment(e, self) for e in xml.documentElement.childNodes if e.nodeType == Node.ELEMENT_NODE]

    def getAttachments(self, id):
        response, content = self._req('GET', '/issue/' + id + '/attachment')
        xml = minidom.parseString(content)
        return [youtrack.Attachment(e, self) for e in xml.documentElement.childNodes if e.nodeType == Node.ELEMENT_NODE]

    def getAttachmentContent(self, url):
        f = urllib2.urlopen(urllib2.Request(self.url + url, headers=self.headers))
        return f

    def createAttachmentFromAttachment(self, issueId, a):
        content = a.getContent()
        return self.createAttachment(issueId, a.name, content, a.authorLogin,
                                     contentLength=int(content.headers.dict['content-length']),
                                     contentType=content.info().type,
                                     created=a.created if hasattr(a, 'created') else None,
                                     group=a.group if hasattr(a, 'group') else None)

    def createAttachment(self, issueId, name, content, authorLogin = '', contentType = None, contentLength = None, created = None, group = ''):
        if contentLength is not None:
            content.contentLength = contentLength

        if contentType is not None:
            content.contentType = contentType

        #post_data = {'attachment': content}
        post_data = {name : content}

        headers = self.headers.copy()
        #headers['Content-Type'] = contentType

        # name without extension to workaround: http://youtrack.jetbrains.net/issue/JT-6110
        params = {#'name': os.path.splitext(name)[0],
                  'group': group,
                  'authorLogin': authorLogin,
                  'group': group}

        if (created is not None):
            params['created'] = created

        r = urllib2.Request(self.baseUrl + '/issue/' + issueId + "/attachment?" +
                            urllib.urlencode(params),
                            headers=headers, data=post_data)
        #r.set_proxy('localhost:8888', 'http')
        try:
            res = urllib2.urlopen(r)
        except urllib2.HTTPError, e:
            if e.code == 201:
                return e.msg + ' ' + name
            raise e

        return res

    def getLinks(self, id, outwardOnly = False):
        response, content = self._req('GET', '/issue/' + urllib.quote(id) + '/link')
        xml = minidom.parseString(content)
        res = []
        for c in [e for e in xml.documentElement.childNodes if e.nodeType == Node.ELEMENT_NODE]:
            link = youtrack.Link(c, self)
            if link.source != id or not outwardOnly:
                res.append(link)
        return res
        
    def getUser(self, login):
        """ http://confluence.jetbrains.net/display/YTD2/GET+user
        """
        return youtrack.User(self._get("/admin/user/" + urllib.quote(login)), self)
        
    def createUser(self, user):
        """ user from getUser
        """
        # self.createUserDetailed(user.login, user.fullName, user.email, user.jabber)
        self.importUsers([user])

    def createUserDetailed(self, login, fullName, email, jabber):
        print self.importUsers([{'login':login, 'fullName':fullName, 'email':email, 'jabber':jabber}])
#        return self._put('/admin/user/' + login + '?' +
#                         'password=' + password +
#                         '&fullName=' + fullName +
#                         '&email=' + email +
#                         '&jabber=' + jabber)


    def importUsers(self, users):
        """ Import users, returns import result (http://confluence.jetbrains.net/display/YTD2/Import+Users)
            Example: importUsers([{'login':'vadim', 'fullName':'vadim', 'email':'eee@ss.com', 'jabber':'fff@fff.com'},
                                  {'login':'maxim', 'fullName':'maxim', 'email':'aaa@ss.com', 'jabber':'www@fff.com'}])
        """
        if len(users) <= 0:
            return

        xml = '<list>\n'
        for u in users:
            xml += '  <user ' + "".join(k + '=' + quoteattr(u[k].encode('utf8')) + ' ' for k in u) + '/>\n'
        xml += '</list>'
        print xml
        #TODO: convert response xml into python objects
        return self._reqXml('PUT', '/import/users', xml, 400).toxml()

    def importIssuesXml(self, projectId, assigneeGroup, xml):
        return self._reqXml('PUT', '/import/' + urllib.quote(projectId) + '/issues?' +
                        urllib.urlencode({'assigneeGroup': assigneeGroup}),
                        xml, 400).toxml()

    def importLinks(self, links):
        """ Import links, returns import result (http://confluence.jetbrains.net/display/YTD2/Import+Links)
            Accepts result of getLinks()
            Example: importLinks([{'login':'vadim', 'fullName':'vadim', 'email':'eee@ss.com', 'jabber':'fff@fff.com'},
                                  {'login':'maxim', 'fullName':'maxim', 'email':'aaa@ss.com', 'jabber':'www@fff.com'}])
        """
        xml = '<links>\n'
        for l in links:
            # ignore typeOutward and typeInward returned by getLinks()
            xml += '  <link ' + "".join(attr + '=' + quoteattr(l[attr]) + ' ' for attr in l if attr not in ['typeInward', 'typeOutward']) + '/>\n'
        xml += '</links>'
        print xml
        #TODO: convert response xml into python objects
        res = self._reqXml('PUT', '/import/links', xml, 400)
        return res.toxml() if hasattr(res, "toxml") else res

    def importIssues(self, projectId, assigneeGroup, issues):
        """ Import issues, returns import result (http://confluence.jetbrains.net/display/YTD2/Import+Issues)
            Accepts retrun of getIssues()
            Example: importIssues([{'numberInProject':'1', 'summary':'some problem', 'description':'some description', 'priority':'1',
                                    'fixedVersion':['1.0', '2.0'],
                                    'comment':[{'author':'yamaxim', 'text':'comment text', 'created':'1267030230127'}]},
                                   {'numberInProject':'2', 'summary':'some problem', 'description':'some description', 'priority':'1'}])
        """
        if len(issues) <= 0:
            return

        xml = '<issues>\n'
        for issue in issues:
            xml += '  <issue>\n'

            comments = None
            if getattr(issue, "getComments", None):
                comments = issue.getComments()

            for issueAttr in issue:
                    attrValue = issue[issueAttr]
                    if issueAttr == 'comments':
                        comments = attrValue
                    else:
                        # ignore bad fields from getIssue()
                        if issueAttr not in ['id', 'projectShortName', 'votes', 'commentsCount', 'historyUpdated',
                                             'updatedByFullName', 'reporterFullName', 'links', 'attachments']:
                            xml += '    <field name="' + issueAttr + '">\n'
                            if isinstance(attrValue, list) or getattr(attrValue, '__iter__', False):
                                xml += "".join('      <value>' + escape(v) + '</value>\n' for v in attrValue)
                            else:
                                xml += '      <value>' + escape(attrValue) + '</value>\n'
                            xml += '    </field>\n'

            if comments:
                for comment in comments:
                    xml += '    <comment ' + "".join(ca + '=' + quoteattr(comment[ca]) + ' ' for ca in comment) + '/>\n'
                    
            xml += '  </issue>\n'
        xml += '</issues>'
        xml = xml.encode('utf-8')         
        print xml
        #TODO: convert response xml into python objects
        return self._reqXml('PUT', '/import/' + urllib.quote(projectId) + '/issues?' +
                            urllib.urlencode({'assigneeGroup': assigneeGroup}),
                            xml, 400).toxml()

    def getProject(self, projectId):
        """ http://confluence.jetbrains.net/display/YTD2/GET+project
        """
        return youtrack.Project(self._get("/admin/project/" + urllib.quote(projectId)), self)

    def getProjectAssigneeGroups(self, projectId):
        response, content = self._req('GET', '/admin/project/' + urllib.quote(projectId) + '/assignee/group')
        xml = minidom.parseString(content)
        return [youtrack.Group(e, self) for e in xml.documentElement.childNodes if e.nodeType == Node.ELEMENT_NODE]

    def getGroup(self, name):
        return youtrack.Group(self._get("/admin/group/" + urllib.quote(name)), self)

    def createGroup(self, group):
        raise NotImplementedError

    def getRole(self, name):
        return youtrack.Role(self._get("/admin/role/" + urllib.quote(name)), self)

    def getSubsystem(self, projectId, name):
        response, content = self._req('GET', '/admin/project/' + projectId + '/subsystem/' + urllib.quote(name))
        xml = minidom.parseString(content)
        return youtrack.Subsystem(xml, self)

    def getSubsystems(self, projectId):
        response, content = self._req('GET', '/admin/project/' + projectId + '/subsystem')
        xml = minidom.parseString(content)
        return [youtrack.Subsystem(e, self) for e in xml.documentElement.childNodes if e.nodeType == Node.ELEMENT_NODE]

    def getVersions(self, projectId):
        response, content = self._req('GET', '/admin/project/' + urllib.quote(projectId) + '/version')
        xml = minidom.parseString(content)
        return [self.getVersion(projectId, v.getAttribute('name')) for v in xml.documentElement.getElementsByTagName('version')]

    def getVersion(self, projectId, name):
        return youtrack.Version(self._get("/admin/project/" + urllib.quote(projectId) + "/version/" + urllib.quote(name)), self)

    def getBuilds(self, projectId):
        response, content = self._req('GET', '/admin/project/' + urllib.quote(projectId) + '/build')
        xml = minidom.parseString(content)
        return [youtrack.Build(e,self) for e in xml.documentElement.childNodes if e.nodeType == Node.ELEMENT_NODE]

    def createBuild(self):
        raise NotImplementedError

    def createBuilds(self):
        raise NotImplementedError

    def createProject(self, project):
        return self.createProjectDetailed(project.id, project.name, project.description, project.lead)

    def createProjectDetailed(self, projectId, name, description, projectLeadLogin, startingNumber = 1):
        return self._put('/admin/project/' + projectId + '?' +
                         urllib.urlencode({'projectName': name,
                                           'description': description + ' ',
                                           'projectLeadLogin': projectLeadLogin,
                                           'lead': projectLeadLogin,
                                           'startingNumber': str(startingNumber)}))

    def createSubsystems(self, projectId, subsystems):
        """ Accepts result of getSubsystems()
        """

        for s in subsystems:
            self.createSubsystem(projectId, s)

    def createSubsystem(self, projectId, s):
         return self.createSubsystemDetailed(projectId, s.name, s.isDefault, s.defaultAssignee if s.defaultAssignee != '<no user>' else '')

    def createSubsystemDetailed(self, projectId, name, isDefault, defaultAssigneeLogin):
        self._put('/admin/project/' + projectId + '/subsystem/' + urllib.quote(name) + "?" +
                         urllib.urlencode({'isDefault': str(isDefault),
                                           'defaultAssignee': defaultAssigneeLogin}))

        return 'Created'

    def deleteSubsystem(self, projectId, name):
        return self._reqXml('DELETE', '/admin/project/' + projectId + '/subsystem/' + urllib.quote(name), '')

    def createVersions(self, projectId, versions):
        """ Accepts result of getVersions()
        """

        for v in versions:
            self.createVersion(projectId, v)

    def createVersion(self, projectId, v):
        return self.createVersionDetailed(projectId, v.name, v.isReleased, v.isArchived, releaseDate=v.releaseDate, description=v.description)

    def createVersionDetailed(self, projectId, name, isReleased, isArchived, releaseDate = None, description=''):
        params = {'description': description,
                  'isReleased': str(isReleased),
                  'isArchived': str(isArchived)}
        if (releaseDate is not None):
            params['releaseDate'] = str(releaseDate)            
        return self._put('/admin/project/' + urllib.quote(projectId) + '/version/' + urllib.quote(name) + "?" +
                         urllib.urlencode(params))

    def getIssues(self, projectId, filter, after, max):
        response, content = self._req('GET', '/project/issues/' + urllib.quote(projectId) + "?" +
            urllib.urlencode({'after' : str(after),
                              'max': str(max),
                              'filter': filter}))
        xml = minidom.parseString(content)
        return [youtrack.Issue(e, self) for e in xml.documentElement.childNodes if e.nodeType == Node.ELEMENT_NODE]

    def executeCommand(self, issueId, command, comment = None, group = None):
        params = {'command' : command}

        if comment is not None:
            params['comment'] = comment

        if group is not None:
            params['group'] = group

        response, content = self._req('POST', '/issue/' + issueId + "/execute?" +
                                      urllib.urlencode(params), body='')

        return "Command executed"

    def getCustomField(self, name):
        return youtrack.CustomField(self._get("/admin/customfield/field/" + name), self)

    def getCustomFields(self):
        response, content = self._req('GET', '/admin/customfield/field')
        xml = minidom.parseString(content)
        return [self.getCustomField(e.getAttribute('name')) for e in xml.documentElement.childNodes if e.nodeType == Node.ELEMENT_NODE]

    def createCustomField(self, cf):
        return self.createCustomFieldDetailed(cf.name, cf.type, cf.isPrivate, cf.visibleByDefault)

    def createCustomFieldDetailed(self, customFieldName, typeName, isPrivate, defaultVisibility):
        self._put('/admin/customfield/field/' + urllib.quote(customFieldName) + '?' +
                         urllib.urlencode({'typeName': typeName,
                                           'isPrivate': str(isPrivate),
                                           'defaultVisibility' : str(defaultVisibility)}))

        return "Created"

    def createCustomFields(self, cfs):
        for cf in cfs:
            self.createCustomField(cf)

    def getEnumBundle(self, name):
        return youtrack.EnumBundle(self._get("/admin/customfield/bundle/" + urllib.quote(name)), self)

    def createEnumBundle(self, eb):
        return self._reqXml('PUT', '/admin/customfield/bundle', body = eb.toXml(), ignoreStatus = 400)

    def deleteEnumBundle(self, name):
        content, result = self._req('DELETE', '/admin/customfield/bundle/' + urllib.quote(name), '')

        return content

    def createEnumBundleDetailed(self, name, values):
        xml = '<enumeration name=\"' + name + '\">'
        xml += ' '.join('<value>' + v + '</value>' for v in values)
        xml += '</enumeration>'
        return self._reqXml('PUT', '/admin/customfield/bundle', body = xml.encode('utf8'), ignoreStatus = 400)

    def addValueToEnumBundle(self, name, value):
        return self._put('/admin/customfield/bundle/' + name + "/" + value)

    def addValuesToEnumBundle(self, name, values):
        return ", ".join(self.addValueToEnumBundle(name, value) for value in values)

    def getProjectCustomField(self, projectId, name):
        return youtrack.ProjectCustomField(self._get("/admin/project/" + urllib.quote(projectId) + "/customfield/" + urllib.quote(name.encode('utf8'))), self)

    def getProjectCustomFields(self, projectId):
        response, content = self._req('GET', '/admin/project/' + urllib.quote(projectId) + '/customfield')
        xml = minidom.parseString(content)
        return [self.getProjectCustomField(projectId, e.getAttribute('name')) for e in xml.getElementsByTagName('projectCustomFieldRef')]

    def createProjectCustomField(self, projectId, pcf):
        return self.createProjectCustomFieldDetailed(projectId, pcf.name, pcf.emptyText, pcf.params)

    def createProjectCustomFieldDetailed(self, projectId, customFieldName, emptyFieldText, params = None):
        _params = {'emptyFieldText': emptyFieldText}
        if params is not None:
            _params.update(params)
        return self._put('/admin/project/' + projectId + '/customfield/' + urllib.quote(customFieldName) + '?' +
                         urllib.urlencode(_params))

    def getIssueLinkTypes(self):
        response, content = self._req('GET', '/admin/issueLinkType')
        xml = minidom.parseString(content)
        return [youtrack.IssueLinkType(e, self) for e in xml.getElementsByTagName('issueLinkType')]

    def createIssueLinkTypes(self, issueLinkTypes):
        for ilt in issueLinkTypes:
            return self.createIssueLinkType(ilt)    

    def createIssueLinkType(self, ilt):
        return self.createIssueLinkTypeDetailed(ilt.name, ilt.outwardName, ilt.inwardName, ilt.directed)

    def createIssueLinkTypeDetailed(self, name, outwardName, inwardName, directed):
        return self._put('/admin/issueLinkType/' + urllib.quote(name) + '?' +
                         urllib.urlencode({'outwardName': outwardName,
                                           'inwardName': inwardName,
                                           'directed': directed}))
