# migrate project from youtrack to youtrack

from youtrack.connection import Connection, youtrack
import httplib2
import socks
#from sets import Set
import youtrack
import sys

#httplib2.debuglevel=4

def main():


#    source_url = 'http://teamsys.intellij.net'
#    source_login = 'xxx'
#    source_password = 'xxx'
#
#    target_url = 'http://v-rot-mne-nogi.myjetbrains.com/youtrack'
#    #target_url = 'http://localhost:8080'
#    target_login = 'xxx'
#    target_password = 'xxx'
#
#    projectId = 'ADM'

    try:
        source_url, source_login, source_password, target_url, target_login, target_password, projectId = sys.argv[1:]
    except BaseException, e:
        print "Usage: youtrack2youtrack source_url source_login source_password target_url target_login target_password projectId"
        return

    youtrack2youtrack(source_url, source_login, source_password, target_url, target_login, target_password, projectId)


def youtrack2youtrack(source_url, source_login, source_password, target_url, target_login, target_password, projectId):
    source = Connection(source_url, source_login, source_password)
    target = Connection(target_url, target_login, target_password) #, proxy_info = httplib2.ProxyInfo(socks.PROXY_TYPE_HTTP, 'localhost', 8888)

    # copy project, subsystems, versions
    project = source.getProject(projectId)

    print "Import issue link types"
    for ilt in source.getIssueLinkTypes():
        try:
            print target.createIssueLinkType(ilt)
        except youtrack.YouTrackException, e:
            print e.message

    print "Import project [" + project.name + "]"
    lead = source.getUser(project.lead)

    print "Create project lead [" + lead.login +  "]"
    print target.createUser(lead)

    try:
        target.getProject(projectId)
    except youtrack.YouTrackException:
        target.createProject(project)

    print "Create users for subsystems"
    subsystems = source.getSubsystems(projectId)
    users = set([])
    for s in subsystems:
        if s.defaultAssignee != '<no user>' and s.defaultAssignee != '':
            users.add(source.getUser(s.defaultAssignee))
    print target.importUsers(users)

    print "Create subsystems"
    for s in subsystems:
        try:
            print target.createSubsystem(projectId, s)
        except youtrack.YouTrackException, e:
            print e.message

    print "Create versions"
    for v in source.getVersions(projectId):
        try:
            print target.createVersion(projectId, v)
        except youtrack.YouTrackException, e:
            print e.message

    cf_ignored_values = dict([])
    print "Create custom fields"
    for pcf in source.getProjectCustomFields(projectId):

        print "Create custom field [" + pcf.name + "]"

        # create global custom fields
        try:
            print target.createCustomField(source.getCustomField(pcf.name))
        except youtrack.YouTrackException, e:
            print e.message
        cf_ignored_values[pcf.name] = pcf.emptyText
        # create bundle if needed
        try:
            if pcf.type.startswith('enum'):
                print target.createEnumBundle(source.getEnumBundle(pcf.bundle))
        except youtrack.YouTrackException, e:
            print e.message

        try:
            print target.createProjectCustomField(projectId, pcf)
        except youtrack.YouTrackException, e:
            print e.message

    # TODO: copy assignees and groups

    # copy issues
    start = 0
    max = 100

    print "Import issues"
    createdUsers = set([])

    while True:
        print "Get issues from " + str(start) + " to " + str(start + max)
        issues = source.getIssues(projectId, '', start, max)

        if len(issues) <= 0:
            break

        users = set([])

        for issue in issues:
            print "Collect users for issue [ " + issue.id + "]"

            if issue.reporterName not in createdUsers:
                users.add(issue.getReporter())
            if issue.hasAssignee() and issue.assigneeName not in createdUsers:
                users.add(issue.getAssignee())
            #TODO: http://youtrack.jetbrains.net/issue/JT-6100
            #users.add(issue.getUpdater())

            for comment in issue.getComments():
                if comment.author not in createdUsers:
                    users.add(comment.getAuthor())

        users = users.difference(createdUsers)
        print "Create users [" + str(len(users)) + "]"
        print target.importUsers(users)
        createdUsers = createdUsers.union(users)

        for issue in issues :
            for key in cf_ignored_values :
                if (key in issue) :
                    if (issue[key] == cf_ignored_values[key]) :
                        issue[key] = ""

        print "Create issues [" + str(len(issues)) + "]"
        print target.importIssues(projectId, project.name + ' Assignees', issues)

        print "Transfer attachments"
        for issue in issues:
            for a in issue.getAttachments():
                print "Transfer attachment of " + issue.id + ": " + a.name
                # TODO: add authorLogin to workaround http://youtrack.jetbrains.net/issue/JT-6082
                a.authorLogin = target_login
                target.createAttachmentFromAttachment(issue.id, a)

        start += max

    # copy links
    print "Import issues links"
    start = 0
    max = 100

    links = []
    maxLinks = 100
    while True:
        print "Get issues from " + str(start) + " to " + str(start + max)
        issues = source.getIssues(projectId, '', start, max)

        if len(issues) <= 0:
            break

        for issue in issues:
            print "Collect links for issue [ " + issue.id + "]"
            links.extend(issue.getLinks(True))

        if (len(links) > maxLinks):
            print "Create links [" + str(len(links)) + "]"
            print target.importLinks(links)
            links = []

        start += max

    if (len(links) > 0):
        print "Create links [" + str(len(links)) + "]"
        print target.importLinks(links)

if __name__ == "__main__":
    main()
