// Bouncer Shader
// 
// Copyright Outerspace Software, all rights reserved

string description = "Bouncer effect";

float4x4	World;
float4x4	ViewProjection;
float4		LightPosModelSpace;
float4		EyePosModelSpace;

float4		AmbientCol;
float4		DiffuseCol;
float		Time=0;

float		PI = 3.14159;

//Tweakables

float4 Prop0
<
string UIName="Period";
float UIMin=0;
float UIMax=5;
float3 UIDefault=float3(1,0,0);
int UISliders=1;
float UIScale=1;
bool UIInteger=false;
int UIWidget=0;
> = float4(1,0,0,0);

float4 Prop1
<
string UIName="Amplitude";
float UIMin=0;
float UIMax=200;
float3 UIDefault=float3(100,0,0);
int UISliders=1;
float UIScale=1;
bool UIInteger=false;
int UIWidget=0;
> = float4(100,0,0,0);


struct VS_INPUT{
	float4 position:	POSITION;
	float3 normal:		NORMAL;
	float3 diffuse:		COLOR;
	float2 tex:			TEXCOORD0;
};

struct VS_OUTPUT{
	float4 position:	POSITION;
	float4 diffuse:		COLOR;
	float2 tex:			TEXCOORD0;
};

VS_OUTPUT VS(VS_INPUT input){
	VS_OUTPUT output;

	float4 Position = input.position;
	Position = mul(Position, World);

	float Alfa=0;
	if(Prop0.x>0) Alfa = sin((Time*PI*2)/Prop0.x);
	
	float sa=sin(Alfa);
	if(sa>0){		
		float gamma = sa*PI*0.05*sin(Position.x*0.01);
		
		float3x3 M;
		M[0] = float3(cos(gamma),-sin(gamma),0);
		M[1] = float3(sin(gamma),cos(gamma),0);
		M[2] = float3(0,0,1);
		
		Position = input.position;
		Position.xyz = mul(M, Position.xyz);						

		Position = mul(Position, World);	
	
		Position.y += sa * Prop1.x;
	}
	else{
		float3 s= float3(1 -sa*0.2,1 + sa*1,1 -sa*0.2);
		Position = input.position;
		Position.xyz *= s;
		Position = mul(Position, World);	

	}

	float3 NormalVector				= normalize(input.normal);	

	Position = mul(Position, ViewProjection);	
	float3 LightVector				= normalize(LightPosModelSpace - Position);
	float3 EyeVector				= normalize(EyePosModelSpace   - Position);
	
	//ambient component
	output.diffuse = AmbientCol;

	//diffuse component
	output.diffuse += DiffuseCol * saturate(dot(NormalVector, LightVector));
	
	output.diffuse.w = DiffuseCol.w;
	output.tex = input.tex;
	output.position = Position;	
	return output;
}

technique Shader
{
    pass P0
    {
        VertexShader = compile vs_1_1 VS();
        PixelShader  = NULL;
    }
}
