// Jumper Shader
// 
// Copyright Outerspace Software, all rights reserved

string description = "Jumper effect";

float4x4	WorldViewProjection;
float4		LightPosModelSpace;
float4		EyePosModelSpace;

float4		AmbientCol;
float4		DiffuseCol;
float		Time=0;

float		PI  = 3.14159;


float4 Prop0
<
string UIName="Jump Distance and Height";
float UIMin=0;
float UIMax=200;
float3 UIDefault=float3(80,80,0);
int UISliders=2;
float UIScale=1;
bool UIInteger=false;
int UIWidget=0;
> = float4(80,80,0,0);

float4 Prop1
<
string UIName="Number of Jumps";
float UIMin=1;
float UIMax=16;
float3 UIDefault=float3(8,0,0);
int UISliders=1;
float UIScale=1;
bool UIInteger=true;
int UIWidget=0;
> = float4(8,0,0,0);

float4 Prop2
<
string UIName="Vertical Centre";
float UIMin=0;
float UIMax=60;
float3 UIDefault=float3(30,0,0);
int UISliders=1;
float UIScale=1;
bool UIInteger=false;
int UIWidget=0;
> = float4(30,0,0,0);




struct VS_INPUT{
	float4 position:	POSITION;
	float3 normal:		NORMAL;
	float3 diffuse:		COLOR;
	float2 tex:			TEXCOORD0;
};

struct VS_OUTPUT{
	float4 position:	POSITION;
	float4 diffuse:		COLOR;
	float2 tex:			TEXCOORD0;
};

VS_OUTPUT VS(VS_INPUT input){
	VS_OUTPUT output;
	
	float4 Position = input.position;
	
	float dt = fmod(Time,1);
	float a=dt*PI*2;
	
	float t = sin(a);
	
	Position.y-=Prop2.x;
	float gamma=t*0.9 * Position.y / 100;
		
	float3x3 M;
	M[0] = float3(cos(gamma),-sin(gamma),0);
	M[1] = float3(sin(gamma),cos(gamma),0);
	M[2] = float3(0,0,1);
		
	Position.xyz = mul(M, Position.xyz);

	Position.y+=Prop2.x;

	if(a>PI){
		gamma=(a-PI);
		Position.y += sin(gamma)*Prop0.y;
	}
	else{
		gamma=a;
		Position.y *= (1-0.5*sin(gamma));
	}

	if(a>PI && a<PI*2){
		gamma=-PI+(a-PI);
		Position.x -= (1+cos(gamma))*Prop0.x;
	}

	int Jumps = Prop1.x;

	int dti = Time % Jumps;
	
	Position.x -= dti*Prop0.x*2;	
	
	Position = mul(Position, WorldViewProjection);	

	float3 NormalVector				= normalize(input.normal);	
	float3 LightVector				= normalize(LightPosModelSpace - Position);
	
	//ambient component
	output.diffuse = AmbientCol;

	//diffuse component
	output.diffuse += DiffuseCol * saturate(dot(NormalVector, LightVector));
	
	output.diffuse.w = DiffuseCol.w;
	output.tex = input.tex;
	output.position = Position;	
	return output;
}

technique Shader
{
    pass P0
    {
        VertexShader = compile vs_1_1 VS();
        PixelShader  = NULL;
    }
}
