// Mrs. Wiggle Shader
// 
// Copyright Outerspace Software, all rights reserved

string Description = "This effect morphs the object.";

float4x4	WorldViewProjection;
float4		EyePosModelSpace;
float4		LightPosModelSpace;
float		AmbientCol;
float4		DiffuseCol;
float4		SpecularCol;
float		Power;
float		Time;

float PI=3.14159;

float4 Prop0
<
string UIName="Period";
float UIMin=0;
float UIMax=5;
float3 UIDefault=float3(1,0,0);
int UISliders=1;
float UIScale=1;
bool UIInteger=false;
int UIWidget=0;
> = float4(1,0,0,0);

float4 Prop1
<
string UIName="WaveLength";
float UIMin=0;
float UIMax=40;
float3 UIDefault=float3(20,0,0);
int UISliders=1;
float UIScale=1;
bool UIInteger=false;
int UIWidget=0;
> = float4(2,0,0,0);

float4 Prop2
<
string UIName="Amplitude";
float UIMin=0;
float UIMax=10;
float3 UIDefault=float3(5,0,0);
int UISliders=1;
float UIScale=1;
bool UIInteger=false;
int UIWidget=0;
> = float4(5,0,0,0);


struct VS_INPUT{
	float4 position:	POSITION;
	float3 normal:		NORMAL;
	float3 diffuse:		COLOR;
	float2 tex:		TEXCOORD0;
};

struct VS_OUTPUT{
	float4 position:	POSITION;
	float4 diffuse:		COLOR;
	float2 tex:		TEXCOORD0;
};

VS_OUTPUT VS(VS_INPUT input) {
    VS_OUTPUT output;
                    
    float4 pos = float4(input.position.xyz,1);
    float angle = pos.y / Prop1.x + (Time*PI*2)/Prop0.x;
    pos.x += sin(angle) * Prop2.x;
    
    pos.x += cos((Time*PI*2)/Prop0.x)*Prop2.x;

	output.position = mul(pos, WorldViewProjection);
    
    float3 NormalVector = normalize(input.normal);
//	NormalVector.x += cos(angle);
//	NormalVector = normalize(NormalVector);

	float3 LightVector				= normalize(LightPosModelSpace - input.position);
	float3 EyeVector				= normalize(EyePosModelSpace   - input.position);
	float3 LightReflectionVector	= -reflect(LightVector,NormalVector);
	
	//ambient component
	output.diffuse = AmbientCol;

	//diffuse component
	output.diffuse += DiffuseCol * saturate(dot(NormalVector, LightVector));
	
	//specular component	
	output.diffuse += SpecularCol * pow(saturate(dot(EyeVector, LightReflectionVector)),Power);
	
	output.diffuse.w = DiffuseCol.w;

	output.tex = input.tex;
	return output;
}

technique Shader
{
    pass p0
    {		
		VertexShader = compile vs_1_1 VS();
    }
}
