// WaveMorpher Shader
// 
// Copyright Outerspace Software, all rights reserved

string description = "The deflection of this animated morph effect is a function of the texture coordinates.";

float4x4	WorldViewProjection;
float4		LightPosModelSpace;
float4		EyePosModelSpace;
float4		UVBounds0 = float4(0,1,0,1);

float4		AmbientCol;
float4		DiffuseCol;
float4		SpecularCol;
float		Power = 100;
float		Time=0;

float		PI = 3.14159;


float4 Prop0
<
string UIName="Period";
float UIMin=0;
float UIMax=10;
float3 UIDefault=float3(2,0,0);
int UISliders=1;
float UIScale=1;
bool UIInteger=true;
int UIWidget=0;
> = float4(2,0,0,0);

float4 Prop1
<
string UIName="Wave Density";
float UIMin=0;
float UIMax=10;
float3 UIDefault=float3(2,2,0);
int UISliders=2;
float UIScale=1;
bool UIInteger=false;
int UIWidget=0;
> = float4(2,2,0,0);

float4 Prop2
<
string UIName="Amplitude";
float UIMin=0;
float UIMax=20;
float3 UIDefault=float3(6,0,0);
int UISliders=1;
float UIScale=1;
bool UIInteger=false;
int UIWidget=0;
> = float4(6,0,0,0);



struct VS_INPUT{
	float4 position:	POSITION;
	float3 normal:		NORMAL;
	float3 diffuse:		COLOR;
	float2 tex:			TEXCOORD0;
};

struct VS_OUTPUT{
	float4 position:	POSITION;
	float4 diffuse:		COLOR;
	float2 tex:			TEXCOORD0;
};

VS_OUTPUT VS(VS_INPUT input){
	VS_OUTPUT output;
	
	float4 Position					= input.position;
	float3 NormalVector				= normalize(input.normal);	
	
	float Alfa= input.tex.x*Prop1.x + input.tex.y*Prop1.y + (Time*PI*2)/Prop0.x;
	Position.xyz += (1+sin(Alfa)) * NormalVector * Prop2.x;

	Position = mul(Position, WorldViewProjection);	
	float3 LightVector				= normalize(LightPosModelSpace - Position);
	float3 EyeVector				= normalize(EyePosModelSpace   - Position);
	float3 LightReflectionVector	= -reflect(LightVector,NormalVector);
	
	//ambient component
	output.diffuse = AmbientCol;

	//diffuse component
	output.diffuse += DiffuseCol * saturate(dot(NormalVector, LightVector));
	
	//specular component	
	output.diffuse += SpecularCol * pow(saturate(dot(EyeVector, LightReflectionVector)),Power);
	
	output.diffuse.w = DiffuseCol.w;
	output.tex = input.tex;
	output.position = Position;	
	return output;
}

technique Shader
{
    pass P0
    {
        VertexShader = compile vs_1_1 VS();
        PixelShader  = NULL;
    }
}
