// Cartoon Shader
//
// Copyright Outerspace Software, all rights reserved

string description = "A cartoon shader effect. The first texture is used as a colour lookup table for diffuse lighting. The texture should be a horizontal gradient from dark (left) to bright (right). The second texture is not used.";

float4x4	WorldViewProjection;	
float4		LightPosModelSpace;
float4		DiffuseCol;

struct VS_INPUT{
	float4 position:	POSITION;
	float3 normal:		NORMAL;
	float3 diffuse:		COLOR;
	float2 tex:			TEXCOORD0;
};

struct VS_OUTPUT{
	float4 position:	POSITION;
	float4 diffuse:		COLOR;
	float2 tex:			TEXCOORD0;
};


VS_OUTPUT VS(VS_INPUT input){
	VS_OUTPUT output;      
	output.position = mul(input.position, WorldViewProjection);

	float3 NormalVector = normalize(input.normal);
	float3 LightVector  = normalize(LightPosModelSpace - input.position);

	output.tex.x = saturate(dot(NormalVector, LightVector));
	output.tex.y = 0;

	output.diffuse = DiffuseCol;
	return output;
}

technique Shader
{
    pass P0
    {
		ADDRESSU[0] = CLAMP;
		ADDRESSV[0] = CLAMP;    
    
        VertexShader = compile vs_1_1 VS();
        PixelShader  = NULL;
    }
}
