// 7Copies Effect
//
// Copyright Outerspace Software, all rights reserved

string description = "This effect renders a picture, video or video capture layer 7 times. Every next picture is a bit smaller and brighter. It works best when placed a bit off screen."; 

float4x4	WorldViewProjection;
float4		DiffuseCol;

//Tweakables

float4 Prop0
<
string UIName="Scale Factor";
float UIMin=0;
float UIMax=1;
float3 UIDefault=float3(0.9,0,0);
int UISliders=1;
float UIScale=1;
bool UIInteger=false;
int UIWidget=0;
> = float4(0.9,0,9,9);

float4 Prop1
<
string UIName="Brightness Factor";
float UIMin=0;
float UIMax=1;
float3 UIDefault=float3(0.95,0,0);
int UISliders=1;
float UIScale=1;
bool UIInteger=false;
int UIWidget=0;
> = float4(0.95,0,0,0);

//scale factor: every next picture is this amount smaller
float sf=0.9;

//colour factor: every picture is this amount darker
float cf=0.95;


struct VS_INPUT{
	float4 position:	POSITION;
	float3 normal:		NORMAL;
	float3 diffuse:		COLOR;
	float2 tex:		TEXCOORD0;
};

struct VS_OUTPUT{
	float4 position:	POSITION;
	float4 diffuse:		COLOR;
	float2 tex:		TEXCOORD0;
};

VS_OUTPUT DoIt(VS_INPUT input, float inScale, float inColour){
	VS_OUTPUT output;      
	float4 p=input.position;
	p.x*=inScale;
	p.y*=inScale;
	output.position = mul(p, WorldViewProjection);
	output.diffuse  = DiffuseCol * inColour;
	output.tex	= input.tex;
	return output;
}

VS_OUTPUT VS0(VS_INPUT input){	return DoIt(input,1,Prop1.x*Prop1.x*Prop1.x*Prop1.x*Prop1.x*Prop1.x); }
VS_OUTPUT VS1(VS_INPUT input){	return DoIt(input,Prop0.x,Prop1.x*Prop1.x*Prop1.x*Prop1.x*Prop1.x*Prop1.x); }
VS_OUTPUT VS2(VS_INPUT input){	return DoIt(input,Prop0.x*Prop0.x,Prop1.x*Prop1.x*Prop1.x*Prop1.x*Prop1.x); }
VS_OUTPUT VS3(VS_INPUT input){	return DoIt(input,Prop0.x*Prop0.x*Prop0.x,Prop1.x*Prop1.x*Prop1.x*Prop1.x); }
VS_OUTPUT VS4(VS_INPUT input){	return DoIt(input,Prop0.x*Prop0.x*Prop0.x*Prop0.x,Prop1.x*Prop1.x*Prop1.x); }
VS_OUTPUT VS5(VS_INPUT input){	return DoIt(input,Prop0.x*Prop0.x*Prop0.x*Prop0.x*Prop0.x,Prop1.x*Prop1.x); }
VS_OUTPUT VS6(VS_INPUT input){	return DoIt(input,Prop0.x*Prop0.x*Prop0.x*Prop0.x*Prop0.x*Prop0.x,1); }

technique Shader
{
    pass P0
    {
	ZWriteEnable = FALSE;
        VertexShader = compile vs_1_1 VS0();
        PixelShader  = NULL;
    }
    pass P1
    {
        VertexShader = compile vs_1_1 VS1();
        PixelShader  = NULL;
    }
    pass P2
    {
        VertexShader = compile vs_1_1 VS2();
        PixelShader  = NULL;
    }
    pass P3
    {
        VertexShader = compile vs_1_1 VS3();
        PixelShader  = NULL;
    }
    pass P4
    {
        VertexShader = compile vs_1_1 VS4();
        PixelShader  = NULL;
    }
    pass P5
    {
        VertexShader = compile vs_1_1 VS5();
        PixelShader  = NULL;
    }
    pass P6
    {
        VertexShader = compile vs_1_1 VS6();
        PixelShader  = NULL;
    }
}
