// Kaleidoscope Shader
// 
// Copyright Outerspace Software, all rights reserved

string description = "This effect renders the layer 8 times.";

float4x4	World;
float4x4	ViewProjection;

float4		DiffuseCol;

float 		PI=3.14159;

struct VS_INPUT{
	float4 position:	POSITION;
	float3 normal:		NORMAL;
	float3 diffuse:		COLOR;
	float2 tex:		TEXCOORD0;
};

struct VS_OUTPUT{
	float4 position:	POSITION;
	float4 diffuse:		COLOR;
	float2 tex:		TEXCOORD0;
};

VS_OUTPUT VS(VS_INPUT input, float inAngle){
	VS_OUTPUT output;      

	float4x4 RM;
	RM[0] = float4(cos(inAngle),-sin(inAngle),0,0);
	RM[1] = float4(sin(inAngle),cos(inAngle),0,0);
	RM[2] = float4(0,0,1,0);
	RM[3] = float4(0,0,0,1);
	
	float4x4 M = World;
	M = mul(M,RM);
	M = mul(M,ViewProjection);	

	output.position = mul(input.position, M);
	
	output.diffuse = DiffuseCol;

	output.tex = input.tex;
	return output;
}


VS_OUTPUT VS0(VS_INPUT input){ return VS(input,PI*0.25*0); }
VS_OUTPUT VS1(VS_INPUT input){ return VS(input,PI*0.25*1); }
VS_OUTPUT VS2(VS_INPUT input){ return VS(input,PI*0.25*2); }
VS_OUTPUT VS3(VS_INPUT input){ return VS(input,PI*0.25*3); }
VS_OUTPUT VS4(VS_INPUT input){ return VS(input,PI*0.25*4); }
VS_OUTPUT VS5(VS_INPUT input){ return VS(input,PI*0.25*5); }
VS_OUTPUT VS6(VS_INPUT input){ return VS(input,PI*0.25*6); }
VS_OUTPUT VS7(VS_INPUT input){ return VS(input,PI*0.25*7); }

technique Shader
{
    pass P0
    {
	ZWriteEnable = FALSE;
        VertexShader = compile vs_1_1 VS0();
        PixelShader  = NULL;
    }
    pass P1
    {
        VertexShader = compile vs_1_1 VS1();
        PixelShader  = NULL;
    }
    pass P2
    {
        VertexShader = compile vs_1_1 VS2();
        PixelShader  = NULL;
    }
    pass P3
    {
        VertexShader = compile vs_1_1 VS3();
        PixelShader  = NULL;
    }
    pass P4
    {
        VertexShader = compile vs_1_1 VS4();
        PixelShader  = NULL;
    }
    pass P5
    {
        VertexShader = compile vs_1_1 VS5();
        PixelShader  = NULL;
    }
    pass P6
    {
        VertexShader = compile vs_1_1 VS6();
        PixelShader  = NULL;
    }
    pass P7
    {
        VertexShader = compile vs_1_1 VS7();
        PixelShader  = NULL;
    }
}
