// Mirror Shader
// 
// Copyright Outerspace Software, all rights reserved

string description = "A mirror effect featuring ambient, diffuse and specular lighting.";

float4x4	WorldViewProjection;
float4x4	World;
float4x4	ViewProjection;
float4		LightPosModelSpace;
float4		EyePosModelSpace;

float4		AmbientCol;
float4		DiffuseCol;
float4		SpecularCol;
float		Power = 100;

float		Time;

float		PI = 3.14159;

float4		MyTextureResolution0;

float4 Prop0
<
string UIName="Transparency Reflection";
float UIMin=0;
float UIMax=1;
float3 UIDefault=float3(0.3,0,0);
int UISliders=1;
float UIScale=1;
bool UIInteger=false;
int UIWidget=0;
> = float4(0.3,0,0,0);

float4 Prop1
<
string UIName="Mirror Position";
float UIMin=-100;
float UIMax=100;
float3 UIDefault=float3(-75,0,0);
int UISliders=1;
float UIScale=1;
bool UIInteger=false;
int UIWidget=0;
> = float4(-75,0,0,0);

struct VS_INPUT{
	float4 position:	POSITION;
	float3 normal:		NORMAL;
	float3 diffuse:		COLOR;
	float2 tex:		TEXCOORD0;
};

struct VS_OUTPUT{
	float4 position:	POSITION;
	float4 diffuse:		COLOR;
	float2 tex:		TEXCOORD0;
};

//the mirrored image
VS_OUTPUT VS1(VS_INPUT input){
	VS_OUTPUT output;      
	
	float4 pos = mul(input.position, World);
	pos.y = 2*Prop1.x - pos.y;	
	
	output.position = mul(pos, ViewProjection);

	float3 NormalVector		= normalize(input.normal);
	float3 LightVector		= normalize(LightPosModelSpace - input.position);
	float3 EyeVector		= normalize(EyePosModelSpace   - input.position);
	float3 LightReflectionVector	= -reflect(LightVector,NormalVector);
	
	//ambient component
	output.diffuse = AmbientCol;

	//diffuse component
	output.diffuse += DiffuseCol * saturate(dot(NormalVector, LightVector));
	
	//specular component	
	output.diffuse += SpecularCol * pow(saturate(dot(EyeVector, LightReflectionVector)),Power);
	
	output.diffuse.w = DiffuseCol.w * Prop0.x;

	output.tex = input.tex;
	return output;
}

VS_OUTPUT VS2(VS_INPUT input){
	VS_OUTPUT output;      

	float4 pos = mul(input.position, World);
	output.position = mul(pos, ViewProjection);

	float3 NormalVector		= normalize(input.normal);
	float3 LightVector		= normalize(LightPosModelSpace - input.position);
	float3 EyeVector		= normalize(EyePosModelSpace   - input.position);
	float3 LightReflectionVector	= -reflect(LightVector,NormalVector);
	
	//ambient component
	output.diffuse = AmbientCol;

	//diffuse component
	output.diffuse += DiffuseCol * saturate(dot(NormalVector, LightVector));
	
	//specular component	
	output.diffuse += SpecularCol * pow(saturate(dot(EyeVector, LightReflectionVector)),Power);
	
	output.diffuse.w = DiffuseCol.w;

	output.tex = input.tex;
	return output;
}

technique Shader
{
    pass P0
    {

	Alphablendenable= TRUE;
	SRCBLEND	= SRCALPHA;
	DESTBLEND	= INVSRCALPHA;
	ALPHAARG1[0]	= TEXTURE;
	ALPHAARG2[0]	= DIFFUSE;
	ALPHAOP[0]	= MODULATE;
	ALPHATESTENABLE	= TRUE;
	ALPHAREF	= 1;
	ALPHAFUNC	= GREATEREQUAL;

	CullMode	= CW;
        VertexShader	= compile vs_1_1 VS1();
	PixelShader	= NULL;
    }
    
    pass P1
    {
	CullMode	= CCW;
        VertexShader	= compile vs_1_1 VS2();
	PixelShader	= NULL;
    }
}
