// CubeMapDDS
//
// Copyright Outerspace Software, all rights reserved

string description = "A reflection mapping shader using the DirectX DDS cubemap picture format. The texture should be a DDS cubemap. The second texture is not used.";

float4x4	World;
float4x4	ViewProjection;
float4x4	WorldInverseTranspose;
float4		EyePos;
float4		DiffuseCol;

texture MyTexture0;
samplerCUBE MyTextureSampler0 = sampler_state {
	Texture = <MyTexture0>;
	MinFilter = Linear;
	MagFilter = Linear;
	MipFilter = Linear;
};

struct VS_INPUT{
	float4 position:	POSITION;
	float3 normal:		NORMAL;
	float3 diffuse:		COLOR;
	float2 tex:		TEXCOORD0;
};

struct VS_OUTPUT{
	float4 position:	POSITION;
	float4 diffuse:		COLOR;
	float3 tex:		TEXCOORD0;
};

struct PS_OUTPUT{
    float4 color:		COLOR;
};

VS_OUTPUT VS(VS_INPUT input){
	VS_OUTPUT output;

	float4 Pos=mul(input.position, World);
	output.position = mul(Pos, ViewProjection);

	float3 NormalVector	= normalize(mul(input.normal,WorldInverseTranspose));
	float3 EyeVector	= normalize(EyePos - Pos);

	output.tex = reflect(NormalVector,EyeVector);

	output.diffuse = DiffuseCol;
	return output;
}

PS_OUTPUT PS(VS_OUTPUT input){
	PS_OUTPUT output;

	float3 r = normalize(input.tex);
  
    	output.color.xyz = DiffuseCol * texCUBE(MyTextureSampler0,r);
    	output.color.w = DiffuseCol.w;
	return output;
}

technique Shader
{
    pass P0
    {
        VertexShader = compile vs_1_1 VS();
        PixelShader  = compile ps_2_0 PS();
    }
}

