// CubeMapDDS Lightened
//
// Copyright Outerspace Software, all rights reserved

string description = "A reflection mapping shader using the DirectX DDS cubemap picture format. The texture should be a DDS cubemap. The second texture is not used.";

float4x4	World;
float4x4	ViewProjection;
float4x4	WorldInverseTranspose;
float4		LightPos;
float4		EyePos;

float		AmbientCol;
float4		DiffuseCol;
float4		SpecularCol;
float		Power = 100;

float4 Prop0
<
string UIName="Lighting Factor";
float UIMin=0;
float UIMax=1;
float3 UIDefault=float3(0.5,0,0);
int UISliders=1;
float UIScale=1;
bool UIInteger=false;
int UIWidget=0;
> = float4(0.3,0,0,0);

texture MyTexture0;
samplerCUBE MyTextureSampler0 = sampler_state {
	Texture = <MyTexture0>;
	MinFilter = Linear;
	MagFilter = Linear;
	MipFilter = Linear;
};

struct VS_INPUT{
	float4 position:	POSITION;
	float3 normal:		NORMAL;
	float3 diffuse:		COLOR;
	float2 tex:		TEXCOORD0;
};

struct VS_OUTPUT{
	float4 position:	POSITION;
	float4 diffuse:		COLOR;
	float3 tex:		TEXCOORD0;
};

struct PS_OUTPUT{
    float4 color:		COLOR;
};

VS_OUTPUT VS(VS_INPUT input){
	VS_OUTPUT output;
	float4 Pos=mul(input.position, World);
	output.position = mul(Pos, ViewProjection);

	float3 NormalVector		= normalize(mul(input.normal,WorldInverseTranspose));
	float3 LightVector		= normalize(LightPos - Pos);
	float3 EyeVector		= normalize(EyePos   - Pos);
	float3 LightReflectionVector	= -reflect(LightVector,NormalVector);
	
	//ambient component
	output.diffuse = AmbientCol;

	//diffuse component
	output.diffuse += DiffuseCol * saturate(dot(NormalVector, LightVector));
	
	//specular component	
	output.diffuse += SpecularCol * pow(saturate(dot(EyeVector, LightReflectionVector)),Power);
	
	output.diffuse.xyz *= Prop0.x;
	output.diffuse.w = DiffuseCol.w;

	output.tex = reflect(NormalVector,EyeVector);
	return output;
	
}

PS_OUTPUT PS(VS_OUTPUT input){
	PS_OUTPUT output;

	float3 r = normalize(input.tex);
  
	output.color.xyz = input.diffuse + DiffuseCol*(1-Prop0.x)*texCUBE(MyTextureSampler0,r);
	output.color.w = DiffuseCol.w;
	return output;
}

technique Shader
{
    pass P0
    {
        VertexShader = compile vs_1_1 VS();
        PixelShader  = compile ps_2_0 PS();
    }
}
