// CheckAlpha Shader
// 
// Copyright Outerspace Software, all rights reserved

string description = "This displays the alpha channel as a checkerboard.";

float4x4	WorldViewProjection;
float4		DiffuseCol;
float4		ImageResolution0;

float4 Prop0
<
string UIName="Resolution Checkerboard";
float UIMin=3;
float UIMax=65;
float3 UIDefault=float3(33,0,0);
int UISliders=1;
float UIScale=1;
bool UIInteger=true;
int UIWidget=0;
> = float4(33,0,0,0);

float4 Prop1
<
string UIName="Colour 1 Checkerboard";
float UIMin=0;
float UIMax=1;
float3 UIDefault=float3(1,1,1);
int UISliders=3;
float UIScale=255;
bool UIInteger=true;
int UIWidget=2;
> = float4(1,0,0,1);

float4 Prop2
<
string UIName="Colour 2 Checkerboard";
float UIMin=0;
float UIMax=1;
float3 UIDefault=float3(0.8,0.8,0.8);
int UISliders=3;
float UIScale=255;
bool UIInteger=true;
int UIWidget=2;
> = float4(0.8,0.8,0.8,1);

float4 Prop3
<
string UIName="Show Alpha Channel";
float UIMin=0;
float UIMax=1;
float3 UIDefault=float3(0,0,0);
int UISliders=1;
float UIScale=1;
bool UIInteger=false;
int UIWidget=0;
> = float4(0,0,0,1);


texture MyTexture0;
sampler MyTextureSampler0 = sampler_state
{
   Texture = <MyTexture0>;
   MinFilter = Linear;
   MagFilter = Linear;
   MipFilter = Linear;   
   AddressU  = Wrap;
   AddressV  = Wrap;
};

struct VS_INPUT{
	float4 position:	POSITION;
	float3 normal:		NORMAL;
	float3 diffuse:		COLOR;
	float2 tex:		TEXCOORD0;
};

struct VS_OUTPUT{
    float4 position:	POSITION;
    float2 tex:		TEXCOORD0;
};

struct PS_OUTPUT{
    float4 color:		COLOR;
};

VS_OUTPUT VS(VS_INPUT input){
	VS_OUTPUT output;
	output.position = mul(input.position, WorldViewProjection);
	output.tex = input.tex.xy;
	return output;
}

int IsEven(int x){
	int z=x/2;
	return (x-z-z)==0;
}

PS_OUTPUT PS(VS_OUTPUT input){
	PS_OUTPUT output;

   	float4 c=DiffuseCol;
	if(ImageResolution0.x>0){
		c*=tex2D(MyTextureSampler0, input.tex);
	}

	float4 e=float4(c.w,c.w,c.w,1);

	int x=input.tex.x * Prop0.x;
	int y=(input.tex.y * Prop0.x * ImageResolution0.y)/ImageResolution0.x;

	float3 d=Prop1;
	if(IsEven(x) && IsEven(y)) d=Prop2;
	if(!IsEven(x) && !IsEven(y)) d=Prop2;

	c.xyz=c.xyz*c.w + d*(1-c.w);
	c.w=1;

	c=c*(1-Prop3.x) + e*Prop3.x;


	output.color = c;
	return output;
}

technique Shader
{
    pass P0
    {
        VertexShader = compile vs_1_1 VS();
        PixelShader  = compile ps_2_0 PS();
    }
}
