// Export.fx
//
// Copyright Outerspace Software, all rights reserved

string description = "This effect is used to create a 32 bits, antialiased texture for copying to an external framebuffer";

float4x4	WorldViewProjection;
float4		MyTextureResolution0 = float4(256,256,1,0);

texture MyTexture0;
sampler Samp = sampler_state{
    Texture   = (MyTexture0);
    AddressU  = CLAMP;
    AddressV  = CLAMP;
    MipFilter = LINEAR;
    MinFilter = LINEAR;
    MagFilter = LINEAR;
};

struct VS_INPUT{
	float4 position:	POSITION;
	float3 normal:		NORMAL;
	float3 diffuse:		COLOR;
	float2 tex:		TEXCOORD0;
};

struct VS_OUTPUT{
	float4 position:	POSITION;
	float2 tex:		TEXCOORD0;
};

struct PS_OUTPUT{
    float4 color:		COLOR;
};

VS_OUTPUT VS(VS_INPUT input){
	VS_OUTPUT output;	
	output.position	= mul(input.position,WorldViewProjection);
	output.tex	= input.tex;     
	return output;
}

float4 GetAntialiasedPixel(float2 c){

	float dx=1.0/MyTextureResolution0.x;
	float dy=1.0/MyTextureResolution0.y;

	float4 p=tex2D(Samp,c);

	p+=tex2D(Samp,c+float2(-dx,-dy));
	p+=tex2D(Samp,c+float2(0,-dy));
	p+=tex2D(Samp,c+float2(dx,-dy));

	p+=tex2D(Samp,c+float2(-dx,0));
	p+=tex2D(Samp,c+float2(dx,0));

	p+=tex2D(Samp,c+float2(-dx,dy));
	p+=tex2D(Samp,c+float2(0,dy));
	p+=tex2D(Samp,c+float2(dx,dy));

	p/=9;

	//correct pre-muliplied alpha
	if(p.w>0 && p.w<1) p.xyz/=p.w;

	saturate(p.xyz);

	return p;
}

PS_OUTPUT PS(VS_OUTPUT input){
	PS_OUTPUT output;
	output.color = GetAntialiasedPixel(input.tex);
	return output;
}

technique Shader{
    pass p0{   

	ZWriteEnable		=FALSE;
	ZEnable  		=FALSE;
	Alphablendenable	=FALSE;
	CullMode		=NONE;

	VertexShader = compile vs_2_0 VS();
	PixelShader  = compile ps_2_0 PS();
    }
}
