// 4 bit Shader
// 
// Copyright Outerspace Software, all rights reserved

string description = "This effect filters the first texture. The second texture is not used.";

float4x4	WorldViewProjection;
float4		DiffuseCol;

float4 Prop0
<
string UIName="Colour Bit Depth";
float UIMin=1;
float UIMax=8;
float3 UIDefault=float3(2,0,0);
int UISliders=1;
float UIScale=1;
bool UIInteger=true;
int UIWidget=0;
> = float4(2,0,0,0);

float4 Prop1
<
string UIName="Contrast";
float UIMin=0;
float UIMax=2;
float3 UIDefault=float3(1,0,0);
int UISliders=1;
float UIScale=1;
bool UIInteger=false;
int UIWidget=0;
> = float4(1,0,0,0);

texture MyTexture0;
sampler MyTextureSampler0 = sampler_state
{
   Texture = <MyTexture0>;
   MinFilter = Linear;
   MagFilter = Linear;
   MipFilter = Linear;   
   AddressU  = Wrap;
   AddressV  = Wrap;
};

struct VS_INPUT{
	float4 position:	POSITION;
	float3 normal:		NORMAL;
	float3 diffuse:		COLOR;
	float2 tex:			TEXCOORD0;
};

struct VS_OUTPUT{
    float4 position:	POSITION;
    float2 tex:			TEXCOORD0;
};

struct PS_OUTPUT{
    float4 color:		COLOR;
};

VS_OUTPUT VS(VS_INPUT input){
	VS_OUTPUT output;
	output.position = mul(input.position, WorldViewProjection);
	output.tex = input.tex.xy;
	return output;
}


PS_OUTPUT PS(VS_OUTPUT input){
	PS_OUTPUT output;

   	float4 rgba = tex2D(MyTextureSampler0, input.tex);

	float c=Prop1.x;

	rgba.x = 0.5 + c*(rgba.x-0.5);
	rgba.y = 0.5 + c*(rgba.y-0.5);
	rgba.z = 0.5 + c*(rgba.z-0.5);


	float K=256;
	if(Prop0.x<=8) K=255;
	if(Prop0.x<=7) K=128;
	if(Prop0.x<=6) K=64;
	if(Prop0.x<=5) K=32;
	if(Prop0.x<=4) K=16;
	if(Prop0.x<=3) K=8;
	if(Prop0.x<=2) K=4;
	if(Prop0.x<=1) K=2;

	int r = (rgba.x+1.0/K)*K;
	int g = (rgba.y+1.0/K)*K;
	int b = (rgba.z+1.0/K)*K;

	output.color = float4(r/K,g/K,b/K,rgba.w);
	output.color.w *= DiffuseCol.w;

	return output;
}


technique Shader
{
    pass P0
    {
        VertexShader = compile vs_1_1 VS();
        PixelShader  = compile ps_2_0 PS();
    }
}
