// Charcoal Shader
// 
// Copyright Outerspace Software, all rights reserved

string description = "This effect filters the first texture. The second texture is not used.";
bool optimization=false;

float4x4	WorldViewProjection;
float4		DiffuseCol;
float4		TextureResolution0 = float4(256,256,1,0);


float4 Prop0
<
string UIName="Line Width";
float UIMin=0;
float UIMax=10;
float3 UIDefault=float3(1,0,0);
int UISliders=1;
float UIScale=1;
bool UIInteger=false;
int UIWidget=0;
> = float4(1,0,0,0);



texture MyTexture0;
sampler MyTextureSampler0 = sampler_state
{
   Texture = <MyTexture0>;
   MinFilter = Linear;
   MagFilter = Linear;
   MipFilter = Linear;   
   AddressU  = CLAMP;
   AddressV  = CLAMP;
};

struct VS_INPUT{
	float4 position:	POSITION;
	float3 normal:		NORMAL;
	float3 diffuse:		COLOR;
	float2 tex:		TEXCOORD0;
};

struct VS_OUTPUT{
    float4 position:	POSITION;
    float2 tex:			TEXCOORD0;
};

struct PS_OUTPUT{
    float4 color:		COLOR;
};

VS_OUTPUT VS(VS_INPUT input){
	VS_OUTPUT output;
	output.position = mul(input.position, WorldViewProjection);
	output.tex = input.tex.xy;
	return output;
}


PS_OUTPUT PS(VS_OUTPUT input){
	PS_OUTPUT output;
	
	float xr = Prop0.x/TextureResolution0.x;
	float yr = Prop0.x/TextureResolution0.y;
   
    float4 c1 = tex2D(MyTextureSampler0, input.tex);
    float4 c2 = tex2D(MyTextureSampler0, input.tex + float2(xr,0));
    float4 c3 = tex2D(MyTextureSampler0, input.tex + float2(0,yr));
    
    float f = 0;
    f += abs(c1.x-c2.x);
    f += abs(c1.y-c2.y);
    f += abs(c1.z-c2.z);
    
    f += abs(c1.x-c3.x);
    f += abs(c1.y-c3.y);
    f += abs(c1.z-c3.z);
    
    f -= 0.2;  
    
    f=1-saturate(f);  

    c1.w *= DiffuseCol.w;
	    
    output.color = float4(f,f,f,c1.w);

    return output;
}


technique Shader
{
    pass P0
    {
        VertexShader = compile vs_3_0 VS();
        PixelShader  = compile ps_3_0 PS();
    }
}

