// Circles.fx
//
// Copyright Outerspace Software, all rights reserved

string description="Circles effect";
 
float4x4	WorldViewProjection;
float4		LightPosModelSpace;
float4		DiffuseCol;
float4		ImageResolution0=float4(1,1,1,1);
float4		UVBounds0=float4(1,1,1,1);

float4 Prop0
<
string UIName="Outer Dot Size";
float UIMin=0;
float UIMax=0.1;
float3 UIDefault=float3(0.05,0,0);
int UISliders=1;
float UIScale=1;
bool UIInteger=false;
int UIWidget=0;
> = float4(0.05,0,0,0);

float4 Prop1
<
string UIName="Inner Dot Size";
float UIMin=0;
float UIMax=1.41;
float3 UIDefault=float3(0.9,0,0);
int UISliders=1;
float UIScale=1;
bool UIInteger=false;
int UIWidget=0;
> = float4(0.9,0,0,0);

float4 Prop2
<
string UIName="Smooth";
float UIMin=0;
float UIMax=1;
float3 UIDefault=float3(0.2,0,0);
int UISliders=1;
float UIScale=1;
bool UIInteger=false;
int UIWidget=0;
> = float4(0.2,0,0,0);

texture MyTexture0;
sampler Samp = sampler_state{
    Texture   = (MyTexture0);
    AddressU  = WRAP;
    AddressV  = WRAP;
    MipFilter = LINEAR;
    MinFilter = LINEAR;
    MagFilter = LINEAR;
};

struct VS_INPUT{
	float4 position:	POSITION;
	float3 normal:		NORMAL;
	float3 diffuse:		COLOR;
	float2 tex:		TEXCOORD0;
};

struct VS_OUTPUT{
	float4 position:	POSITION;
	float2 tex:		TEXCOORD0;
};

struct PS_OUTPUT{
    float4 color:		COLOR;
};

VS_OUTPUT VS(VS_INPUT input){
	VS_OUTPUT output;
	
	output.position = mul(input.position,WorldViewProjection);
	output.tex	= input.tex;
 
    
    return output;
}

float4 GetColour(float2 inUV){

    float ar=ImageResolution0.x/ImageResolution0.y;

    ar *= (UVBounds0.w-UVBounds0.z)/(UVBounds0.y-UVBounds0.x);
    if(ar<0) ar=-ar;

    inUV.x*=ar;
	
    float2 Pbase = inUV - fmod(inUV, Prop0.x);
    float2 PCenter = Pbase + Prop0.x*0.5;
    
    float r = Prop0.x * 0.5 * Prop1.x;
    float d = length(inUV - PCenter);

    PCenter.x/=ar;
    float4 ret=tex2D(Samp,PCenter);

    if(d>=r) ret.w=0;
    if(d<r && d>=r*(1-Prop2.x)) ret.w*=(r-d)/(r*Prop2.x);
    if(d<r*(1-Prop2.x)) ret.w*=1;
	    
    return ret*DiffuseCol;	   
}

PS_OUTPUT PS(VS_OUTPUT input){
    PS_OUTPUT output;    
    output.color = GetColour(input.tex);	   
    return output;
}

technique pixels{
    pass p0{   
	Alphablendenable= TRUE;
	SRCBLEND	= SRCALPHA;
	DESTBLEND	= INVSRCALPHA;

	VertexShader = compile vs_2_0 VS();
	PixelShader  = compile ps_2_0 PS();
    }
}

