// Colour Invert
// 
// Copyright Outerspace Software, all rights reserved

string description = "This effect inverts all colours.";

float4x4	WorldViewProjection;
float4		DiffuseCol;

float4 Prop0
<
string UIName="Colour Mixer";
float UIMin=0;
float UIMax=5;
float3 UIDefault=float3(3,4,5);
int UISliders=3;
float UIScale=1;
bool UIInteger=true;
int UIWidget=0;
> = float4(3,4,5,0);


texture MyTexture0;
sampler MyTextureSampler0 = sampler_state
{
   Texture = <MyTexture0>;
   MinFilter = Linear;
   MagFilter = Linear;
   MipFilter = Linear;   
   AddressU  = Wrap;
   AddressV  = Wrap;
};

struct VS_INPUT{
	float4 position:	POSITION;
	float3 normal:		NORMAL;
	float3 diffuse:		COLOR;
	float2 tex:		TEXCOORD0;
};

struct VS_OUTPUT{
    float4 position:	POSITION;
    float2 tex:		TEXCOORD0;
};

struct PS_OUTPUT{
    float4 color:	COLOR;
};

VS_OUTPUT VS(VS_INPUT input){
	VS_OUTPUT output;
	output.position = mul(input.position, WorldViewProjection);
	output.tex = input.tex.xy;
	return output;
}


PS_OUTPUT PS(VS_OUTPUT input){
	PS_OUTPUT output;

   	float4 c = tex2D(MyTextureSampler0, input.tex);
   	float4 d = c;
	
	int k=Prop0.x;
	k=k%6;
	if(k==0) d.x=c.x;
	if(k==1) d.x=c.y;
	if(k==2) d.x=c.z;
	if(k==3) d.x=1-c.x;
	if(k==4) d.x=1-c.y;
	if(k==5) d.x=1-c.z;
	
	k=Prop0.y;
	k=k%6;
	if(k==0) d.y=c.x;
	if(k==1) d.y=c.y;
	if(k==2) d.y=c.z;
	if(k==3) d.y=1-c.x;
	if(k==4) d.y=1-c.y;
	if(k==5) d.y=1-c.z;
	
	k=Prop0.z;
	k=k%6;
	if(k==0) d.z=c.x;
	if(k==1) d.z=c.y;
	if(k==2) d.z=c.z;
	if(k==3) d.z=1-c.x;
	if(k==4) d.z=1-c.y;
	if(k==5) d.z=1-c.z;
	
	output.color = d;
	output.color.w *= DiffuseCol.w;

	return output;
}


technique Shader
{
    pass P0
    {
        VertexShader = compile vs_1_1 VS();
        PixelShader  = compile ps_2_0 PS();
    }
}
